## ----include=FALSE------------------------------------------------------------
library(equatiomatic)
library(recipes)
library(parsnip)
knitr::opts_chunk$set(collapse = TRUE, comment = "#>")

## ----cars---------------------------------------------------------------------
# Preparation of the dataset using {recipes}
spline_cars <- recipe(mpg ~ ., data = mtcars) |>
  step_ns(disp, deg_free = 10)
spline_cars_prepped <- prep(spline_cars, mtcars)

## ----lm-----------------------------------------------------------------------
# Fitting of a least-square linear model
lm_fit <- linear_reg() |>
  fit(mpg ~ ., data = juice(spline_cars_prepped))

## ----lm_equation--------------------------------------------------------------
extract_eq(lm_fit, wrap = TRUE)

## ----wflow--------------------------------------------------------------------
library(workflows)

# A model compatible with {equatiomatic}
linear_lm <- linear_reg()

# A workflow object
car_wflow <- workflow() |>
  add_recipe(spline_cars) |>
  add_model(linear_lm)

## ----wflow_fit----------------------------------------------------------------
wflow_fit <- fit(car_wflow, data = mtcars)

## ----wflow_equation-----------------------------------------------------------
extract_eq(wflow_fit, wrap = TRUE)

## ----wflow_equation2----------------------------------------------------------
extract_eq(wflow_fit, wrap = TRUE, swap_var_names = c(..y = "mpg"))

## ----bayes_fit, eval=FALSE----------------------------------------------------
# library(broom.mixed) # Required for some models, or extract_eq() will choke!
# 
# bayes_fit <- linear_reg() |>
#   set_engine("stan") |>
#   fit(mpg ~ hp + drat, data = mtcars)

## ----bayes_equation, eval=FALSE-----------------------------------------------
# extract_eq(bayes_fit)

## ----bayes_equation2, echo=FALSE----------------------------------------------
equation("E( \\operatorname{mpg} ) = \\alpha + \\beta_{1}(\\operatorname{hp}) + \\beta_{2}(\\operatorname{drat})")

