/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tint.impl;

import cern.colt.function.tint.IntFunction;
import cern.colt.function.tint.IntIntFunction;
import cern.colt.function.tint.IntIntIntFunction;
import cern.colt.function.tlong.LongIntProcedure;
import cern.colt.map.tlong.AbstractLongIntMap;
import cern.colt.map.tlong.OpenLongIntHashMap;
import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tint.IntMatrix1D;
import cern.colt.matrix.tint.IntMatrix2D;
import cern.colt.matrix.tint.impl.DenseIntMatrix1D;
import cern.colt.matrix.tint.impl.DenseIntMatrix2D;
import cern.colt.matrix.tint.impl.SelectedSparseIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseCCIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseCCMIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseIntMatrix1D;
import cern.colt.matrix.tint.impl.SparseRCIntMatrix2D;
import cern.colt.matrix.tint.impl.SparseRCMIntMatrix2D;
import cern.jet.math.tint.IntFunctions;
import cern.jet.math.tint.IntMult;
import cern.jet.math.tint.IntPlusMultSecond;
import java.io.IOException;

public class SparseIntMatrix2D
extends IntMatrix2D {
    private static final long serialVersionUID = 1L;
    protected AbstractLongIntMap elements;

    public SparseIntMatrix2D(int[][] nArray) {
        this(nArray.length, nArray.length == 0 ? 0 : nArray[0].length);
        this.assign(nArray);
    }

    public SparseIntMatrix2D(int n, int n2) {
        this(n, n2, n * (n2 / 1000), 0.2, 0.5);
    }

    public SparseIntMatrix2D(int n, int n2, int n3, double d, double d2) {
        block2: {
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = new OpenLongIntHashMap(n3, d, d2);
    }

    public SparseIntMatrix2D(int n, int n2, int[] nArray, int[] nArray2, int n3) {
        block2: {
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = new OpenLongIntHashMap(nArray.length);
        this.insert(nArray, nArray2, n3);
    }

    public SparseIntMatrix2D(int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) {
        block2: {
            try {
                this.setUp(n, n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = new OpenLongIntHashMap(nArray.length);
        this.insert(nArray, nArray2, nArray3);
    }

    public SparseIntMatrix2D(MatrixVectorReader matrixVectorReader) throws IOException {
        block9: {
            int[] nArray;
            int[] nArray2;
            int[] nArray3;
            int n;
            MatrixInfo matrixInfo;
            block8: {
                MatrixSize matrixSize;
                block7: {
                    matrixInfo = matrixVectorReader.hasInfo() ? matrixVectorReader.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                    if (matrixInfo.isPattern()) {
                        throw new UnsupportedOperationException("Pattern matrices are not supported");
                    }
                    if (matrixInfo.isDense()) {
                        throw new UnsupportedOperationException("Dense matrices are not supported");
                    }
                    if (matrixInfo.isComplex()) {
                        throw new UnsupportedOperationException("Complex matrices are not supported");
                    }
                    matrixSize = matrixVectorReader.readMatrixSize(matrixInfo);
                    try {
                        this.setUp(matrixSize.numRows(), matrixSize.numColumns());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        if ("matrix too large".equals(illegalArgumentException.getMessage())) break block7;
                        throw illegalArgumentException;
                    }
                }
                n = matrixSize.numEntries();
                nArray3 = new int[n];
                nArray2 = new int[n];
                nArray = new int[n];
                matrixVectorReader.readCoordinate(nArray2, nArray3, nArray);
                this.elements = matrixInfo.isSymmetric() || matrixInfo.isSkewSymmetric() ? new OpenLongIntHashMap(2 * nArray2.length) : new OpenLongIntHashMap(nArray2.length);
                this.insert(nArray2, nArray3, nArray);
                if (!matrixInfo.isSymmetric()) break block8;
                for (int i = 0; i < n; ++i) {
                    if (nArray2[i] == nArray3[i]) continue;
                    this.set(nArray3[i], nArray2[i], nArray[i]);
                }
                break block9;
            }
            if (!matrixInfo.isSkewSymmetric()) break block9;
            for (int i = 0; i < n; ++i) {
                if (nArray2[i] == nArray3[i]) continue;
                this.set(nArray3[i], nArray2[i], -nArray[i]);
            }
        }
    }

    protected SparseIntMatrix2D(int n, int n2, AbstractLongIntMap abstractLongIntMap, int n3, int n4, int n5, int n6) {
        block2: {
            try {
                this.setUp(n, n2, n3, n4, n5, n6);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ("matrix too large".equals(illegalArgumentException.getMessage())) break block2;
                throw illegalArgumentException;
            }
        }
        this.elements = abstractLongIntMap;
        this.isNoView = false;
    }

    public IntMatrix2D assign(IntFunction intFunction) {
        if (this.isNoView && intFunction instanceof IntMult) {
            this.elements.assign(intFunction);
        } else {
            super.assign(intFunction);
        }
        return this;
    }

    public IntMatrix2D assign(int n) {
        if (this.isNoView && n == 0) {
            this.elements.clear();
        } else {
            super.assign(n);
        }
        return this;
    }

    public IntMatrix2D assign(IntMatrix2D intMatrix2D) {
        if (!(intMatrix2D instanceof SparseIntMatrix2D)) {
            return super.assign(intMatrix2D);
        }
        SparseIntMatrix2D sparseIntMatrix2D = (SparseIntMatrix2D)intMatrix2D;
        if (sparseIntMatrix2D == this) {
            return this;
        }
        this.checkShape(sparseIntMatrix2D);
        if (this.isNoView && sparseIntMatrix2D.isNoView) {
            this.elements.assign(sparseIntMatrix2D.elements);
            return this;
        }
        return super.assign(intMatrix2D);
    }

    public IntMatrix2D assign(final IntMatrix2D intMatrix2D, IntIntFunction intIntFunction) {
        if (!this.isNoView) {
            return super.assign(intMatrix2D, intIntFunction);
        }
        this.checkShape(intMatrix2D);
        if (intIntFunction instanceof IntPlusMultSecond) {
            final int n = ((IntPlusMultSecond)intIntFunction).multiplicator;
            if (n == 0) {
                return this;
            }
            intMatrix2D.forEachNonZero(new IntIntIntFunction(){

                public int apply(int n4, int n2, int n3) {
                    SparseIntMatrix2D.this.setQuick(n4, n2, SparseIntMatrix2D.this.getQuick(n4, n2) + n * n3);
                    return n3;
                }
            });
        } else if (intIntFunction == IntFunctions.mult) {
            this.elements.forEachPair(new LongIntProcedure(){

                public boolean apply(long l, int n) {
                    int n2;
                    int n3 = (int)(l / (long)SparseIntMatrix2D.this.columns);
                    int n4 = n * intMatrix2D.getQuick(n3, n2 = (int)(l % (long)SparseIntMatrix2D.this.columns));
                    if (n4 != n) {
                        SparseIntMatrix2D.this.elements.put(l, n4);
                    }
                    return true;
                }
            });
        } else if (intIntFunction == IntFunctions.div) {
            this.elements.forEachPair(new LongIntProcedure(){

                public boolean apply(long l, int n) {
                    int n2;
                    int n3 = (int)(l / (long)SparseIntMatrix2D.this.columns);
                    int n4 = n / intMatrix2D.getQuick(n3, n2 = (int)(l % (long)SparseIntMatrix2D.this.columns));
                    if (n4 != n) {
                        SparseIntMatrix2D.this.elements.put(l, n4);
                    }
                    return true;
                }
            });
        } else {
            super.assign(intMatrix2D, intIntFunction);
        }
        return this;
    }

    public SparseIntMatrix2D assign(int[] nArray, int[] nArray2, int n, IntIntFunction intIntFunction) {
        int n2 = nArray.length;
        if (intIntFunction == IntFunctions.plus) {
            for (int i = 0; i < n2; ++i) {
                int n3 = nArray[i];
                int n4 = nArray2[i];
                if (n3 >= this.rows || n4 >= this.columns) {
                    throw new IndexOutOfBoundsException("row: " + n3 + ", column: " + n4);
                }
                int n5 = this.rowZero + n3 * this.rowStride + this.columnZero + n4 * this.columnStride;
                int n6 = this.elements.get(n5);
                int n7 = n6 + n;
                if (n7 != 0) {
                    this.elements.put(n5, n7);
                    continue;
                }
                this.elements.removeKey(n5);
            }
        } else {
            for (int i = 0; i < n2; ++i) {
                int n8 = nArray[i];
                int n9 = nArray2[i];
                if (n8 >= this.rows || n9 >= this.columns) {
                    throw new IndexOutOfBoundsException("row: " + n8 + ", column: " + n9);
                }
                int n10 = this.rowZero + n8 * this.rowStride + this.columnZero + n9 * this.columnStride;
                int n11 = this.elements.get(n10);
                int n12 = intIntFunction.apply(n11, n);
                if (n12 != 0) {
                    this.elements.put(n10, n12);
                    continue;
                }
                this.elements.removeKey(n10);
            }
        }
        return this;
    }

    public SparseIntMatrix2D assign(int[] nArray, int[] nArray2, int[] nArray3, IntIntFunction intIntFunction) {
        int n = nArray.length;
        if (intIntFunction == IntFunctions.plus) {
            for (int i = 0; i < n; ++i) {
                int n2 = nArray3[i];
                int n3 = nArray[i];
                int n4 = nArray2[i];
                if (n3 >= this.rows || n4 >= this.columns) {
                    throw new IndexOutOfBoundsException("row: " + n3 + ", column: " + n4);
                }
                int n5 = this.rowZero + n3 * this.rowStride + this.columnZero + n4 * this.columnStride;
                int n6 = this.elements.get(n5);
                if ((n2 += n6) != 0) {
                    this.elements.put(n5, n2);
                    continue;
                }
                this.elements.removeKey(n5);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int n7 = nArray3[i];
                int n8 = nArray[i];
                int n9 = nArray2[i];
                if (n8 >= this.rows || n9 >= this.columns) {
                    throw new IndexOutOfBoundsException("row: " + n8 + ", column: " + n9);
                }
                int n10 = this.rowZero + n8 * this.rowStride + this.columnZero + n9 * this.columnStride;
                int n11 = this.elements.get(n10);
                n7 = intIntFunction.apply(n11, n7);
                if (n7 != 0) {
                    this.elements.put(n10, n7);
                    continue;
                }
                this.elements.removeKey(n10);
            }
        }
        return this;
    }

    public int cardinality() {
        if (this.isNoView) {
            return this.elements.size();
        }
        return super.cardinality();
    }

    public SparseCCIntMatrix2D getColumnCompressed(boolean bl) {
        int n = this.cardinality();
        long[] lArray = this.elements.keys().elements();
        int[] nArray = this.elements.values().elements();
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            long l = lArray[i];
            nArray2[i] = (int)(l / (long)this.columns);
            nArray3[i] = (int)(l % (long)this.columns);
        }
        return new SparseCCIntMatrix2D(this.rows, this.columns, nArray2, nArray3, nArray, false, false, bl);
    }

    public SparseCCMIntMatrix2D getColumnCompressedModified() {
        SparseCCMIntMatrix2D sparseCCMIntMatrix2D = new SparseCCMIntMatrix2D(this.rows, this.columns);
        int n = this.cardinality();
        long[] lArray = this.elements.keys().elements();
        int[] nArray = this.elements.values().elements();
        for (int i = 0; i < n; ++i) {
            int n2 = (int)(lArray[i] / (long)this.columns);
            int n3 = (int)(lArray[i] % (long)this.columns);
            sparseCCMIntMatrix2D.setQuick(n2, n3, nArray[i]);
        }
        return sparseCCMIntMatrix2D;
    }

    public SparseRCIntMatrix2D getRowCompressed(boolean bl) {
        int n = this.cardinality();
        long[] lArray = this.elements.keys().elements();
        int[] nArray = this.elements.values().elements();
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        for (int i = 0; i < n; ++i) {
            long l = lArray[i];
            nArray2[i] = (int)(l / (long)this.columns);
            nArray3[i] = (int)(l % (long)this.columns);
        }
        return new SparseRCIntMatrix2D(this.rows, this.columns, nArray2, nArray3, nArray, false, false, bl);
    }

    public SparseRCMIntMatrix2D getRowCompressedModified() {
        SparseRCMIntMatrix2D sparseRCMIntMatrix2D = new SparseRCMIntMatrix2D(this.rows, this.columns);
        int n = this.cardinality();
        long[] lArray = this.elements.keys().elements();
        int[] nArray = this.elements.values().elements();
        for (int i = 0; i < n; ++i) {
            int n2 = (int)(lArray[i] / (long)this.columns);
            int n3 = (int)(lArray[i] % (long)this.columns);
            sparseRCMIntMatrix2D.setQuick(n2, n3, nArray[i]);
        }
        return sparseRCMIntMatrix2D;
    }

    public AbstractLongIntMap elements() {
        return this.elements;
    }

    public void ensureCapacity(int n) {
        this.elements.ensureCapacity(n);
    }

    public IntMatrix2D forEachNonZero(final IntIntIntFunction intIntIntFunction) {
        if (this.isNoView) {
            this.elements.forEachPair(new LongIntProcedure(){

                public boolean apply(long l, int n) {
                    int n2;
                    int n3 = (int)(l / (long)SparseIntMatrix2D.this.columns);
                    int n4 = intIntIntFunction.apply(n3, n2 = (int)(l % (long)SparseIntMatrix2D.this.columns), n);
                    if (n4 != n) {
                        SparseIntMatrix2D.this.elements.put(l, n4);
                    }
                    return true;
                }
            });
        } else {
            super.forEachNonZero(intIntIntFunction);
        }
        return this;
    }

    public synchronized int getQuick(int n, int n2) {
        return this.elements.get((long)this.rowZero + (long)n * (long)this.rowStride + (long)this.columnZero + (long)n2 * (long)this.columnStride);
    }

    public long index(int n, int n2) {
        return (long)this.rowZero + (long)n * (long)this.rowStride + (long)this.columnZero + (long)n2 * (long)this.columnStride;
    }

    public IntMatrix2D like(int n, int n2) {
        return new SparseIntMatrix2D(n, n2);
    }

    public IntMatrix1D like1D(int n) {
        return new SparseIntMatrix1D(n);
    }

    public synchronized void setQuick(int n, int n2, int n3) {
        long l = (long)this.rowZero + (long)n * (long)this.rowStride + (long)this.columnZero + (long)n2 * (long)this.columnStride;
        if (n3 == 0) {
            this.elements.removeKey(l);
        } else {
            this.elements.put(l, n3);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.rows).append(" x ").append(this.columns).append(" sparse matrix, nnz = ").append(this.cardinality()).append('\n');
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                int n = this.getQuick(i, j);
                if (n == 0) continue;
                stringBuilder.append('(').append(i).append(',').append(j).append(')').append('\t').append(n).append('\n');
            }
        }
        return stringBuilder.toString();
    }

    public void trimToSize() {
        this.elements.trimToSize();
    }

    public IntMatrix1D vectorize() {
        SparseIntMatrix1D sparseIntMatrix1D = new SparseIntMatrix1D((int)this.size());
        int n = 0;
        for (int i = 0; i < this.columns; ++i) {
            for (int j = 0; j < this.rows; ++j) {
                int n2 = this.getQuick(j, i);
                sparseIntMatrix1D.setQuick(n++, n2);
            }
        }
        return sparseIntMatrix1D;
    }

    public IntMatrix1D zMult(IntMatrix1D intMatrix1D, IntMatrix1D intMatrix1D2, final int n, int n2, final boolean bl) {
        boolean bl2;
        int n3 = this.rows;
        int n4 = this.columns;
        if (bl) {
            n3 = this.columns;
            n4 = this.rows;
        }
        boolean bl3 = bl2 = intMatrix1D2 == null;
        if (intMatrix1D2 == null) {
            intMatrix1D2 = new DenseIntMatrix1D(n3);
        }
        if (!(this.isNoView && intMatrix1D instanceof DenseIntMatrix1D && intMatrix1D2 instanceof DenseIntMatrix1D)) {
            return super.zMult(intMatrix1D, intMatrix1D2, n, n2, bl);
        }
        if ((long)n4 != intMatrix1D.size() || (long)n3 > intMatrix1D2.size()) {
            throw new IllegalArgumentException("Incompatible args: " + (bl ? this.viewDice() : this).toStringShort() + ", " + intMatrix1D.toStringShort() + ", " + intMatrix1D2.toStringShort());
        }
        if (!bl2) {
            intMatrix1D2.assign(IntFunctions.mult(n2));
        }
        DenseIntMatrix1D denseIntMatrix1D = (DenseIntMatrix1D)intMatrix1D2;
        final int[] nArray = denseIntMatrix1D.elements;
        final int n5 = denseIntMatrix1D.stride();
        final int n6 = (int)intMatrix1D2.index(0);
        DenseIntMatrix1D denseIntMatrix1D2 = (DenseIntMatrix1D)intMatrix1D;
        final int[] nArray2 = denseIntMatrix1D2.elements;
        final int n7 = denseIntMatrix1D2.stride();
        final int n8 = (int)intMatrix1D.index(0);
        if (nArray2 == null || nArray == null) {
            throw new InternalError();
        }
        this.elements.forEachPair(new LongIntProcedure(){

            public boolean apply(long l, int n9) {
                int n2 = (int)(l / (long)SparseIntMatrix2D.this.columns);
                int n3 = (int)(l % (long)SparseIntMatrix2D.this.columns);
                if (bl) {
                    int n4 = n2;
                    n2 = n3;
                    n3 = n4;
                }
                int n52 = n6 + n5 * n2;
                nArray[n52] = nArray[n52] + n * n9 * nArray2[n8 + n7 * n3];
                return true;
            }
        });
        return intMatrix1D2;
    }

    public IntMatrix2D zMult(IntMatrix2D intMatrix2D, IntMatrix2D intMatrix2D2, final int n, int n2, final boolean bl, boolean bl2) {
        boolean bl3;
        if (!this.isNoView) {
            return super.zMult(intMatrix2D, intMatrix2D2, n, n2, bl, bl2);
        }
        if (bl2) {
            intMatrix2D = intMatrix2D.viewDice();
        }
        int n3 = this.rows;
        int n4 = this.columns;
        if (bl) {
            n3 = this.columns;
            n4 = this.rows;
        }
        int n5 = intMatrix2D.columns();
        boolean bl4 = bl3 = intMatrix2D2 == null;
        if (intMatrix2D2 == null) {
            intMatrix2D2 = new DenseIntMatrix2D(n3, n5);
        }
        if (intMatrix2D.rows() != n4) {
            throw new IllegalArgumentException("Matrix2D inner dimensions must agree:" + this.toStringShort() + ", " + (bl2 ? intMatrix2D.viewDice() : intMatrix2D).toStringShort());
        }
        if (intMatrix2D2.rows() != n3 || intMatrix2D2.columns() != n5) {
            throw new IllegalArgumentException("Incompatibel result matrix: " + this.toStringShort() + ", " + (bl2 ? intMatrix2D.viewDice() : intMatrix2D).toStringShort() + ", " + intMatrix2D2.toStringShort());
        }
        if (this == intMatrix2D2 || intMatrix2D == intMatrix2D2) {
            throw new IllegalArgumentException("Matrices must not be identical");
        }
        if (!bl3) {
            intMatrix2D2.assign(IntFunctions.mult(n2));
        }
        final IntMatrix1D[] intMatrix1DArray = new IntMatrix1D[n4];
        int n6 = n4;
        while (--n6 >= 0) {
            intMatrix1DArray[n6] = intMatrix2D.viewRow(n6);
        }
        final IntMatrix1D[] intMatrix1DArray2 = new IntMatrix1D[n3];
        int n7 = n3;
        while (--n7 >= 0) {
            intMatrix1DArray2[n7] = intMatrix2D2.viewRow(n7);
        }
        final IntPlusMultSecond intPlusMultSecond = IntPlusMultSecond.plusMult(0);
        this.elements.forEachPair(new LongIntProcedure(){

            public boolean apply(long l, int n4) {
                int n2 = (int)(l / (long)SparseIntMatrix2D.this.columns);
                int n3 = (int)(l % (long)SparseIntMatrix2D.this.columns);
                intPlusMultSecond.multiplicator = n4 * n;
                if (!bl) {
                    intMatrix1DArray2[n2].assign(intMatrix1DArray[n3], intPlusMultSecond);
                } else {
                    intMatrix1DArray2[n3].assign(intMatrix1DArray[n2], intPlusMultSecond);
                }
                return true;
            }
        });
        return intMatrix2D2;
    }

    private void insert(int[] nArray, int[] nArray2, int n) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            int n3 = nArray[i];
            int n4 = nArray2[i];
            if (n3 >= this.rows || n4 >= this.columns) {
                throw new IndexOutOfBoundsException("row: " + n3 + ", column: " + n4);
            }
            if (n == 0) continue;
            int n5 = this.rowZero + n3 * this.rowStride + this.columnZero + n4 * this.columnStride;
            int n6 = this.elements.get(n5);
            if (n6 == 0) {
                this.elements.put(n5, n);
                continue;
            }
            int n7 = n6 + n;
            if (n7 == 0) {
                this.elements.removeKey(n5);
                continue;
            }
            this.elements.put(n5, n7);
        }
    }

    private void insert(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray3[i];
            int n3 = nArray[i];
            int n4 = nArray2[i];
            if (n3 >= this.rows || n4 >= this.columns) {
                throw new IndexOutOfBoundsException("row: " + n3 + ", column: " + n4);
            }
            if (n2 == 0) continue;
            int n5 = this.rowZero + n3 * this.rowStride + this.columnZero + n4 * this.columnStride;
            int n6 = this.elements.get(n5);
            if (n6 == 0) {
                this.elements.put(n5, n2);
                continue;
            }
            int n7 = n6 + n2;
            if (n7 == 0) {
                this.elements.removeKey(n5);
                continue;
            }
            this.elements.put(n5, n7);
        }
    }

    protected boolean haveSharedCellsRaw(IntMatrix2D intMatrix2D) {
        if (intMatrix2D instanceof SelectedSparseIntMatrix2D) {
            SelectedSparseIntMatrix2D selectedSparseIntMatrix2D = (SelectedSparseIntMatrix2D)intMatrix2D;
            return this.elements == selectedSparseIntMatrix2D.elements;
        }
        if (intMatrix2D instanceof SparseIntMatrix2D) {
            SparseIntMatrix2D sparseIntMatrix2D = (SparseIntMatrix2D)intMatrix2D;
            return this.elements == sparseIntMatrix2D.elements;
        }
        return false;
    }

    protected IntMatrix1D like1D(int n, int n2, int n3) {
        return new SparseIntMatrix1D(n, this.elements, n2, n3);
    }

    protected IntMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedSparseIntMatrix2D(this.elements, nArray, nArray2, 0);
    }
}

