/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tdouble;

import cern.colt.function.tdouble.DoubleProcedure;
import cern.colt.function.tdouble.IntIntDoubleFunction;
import cern.colt.list.tdouble.DoubleArrayList;
import cern.colt.list.tint.IntArrayList;
import cern.colt.matrix.tdouble.DoubleFactory1D;
import cern.colt.matrix.tdouble.DoubleFactory2D;
import cern.colt.matrix.tdouble.DoubleMatrix1D;
import cern.colt.matrix.tdouble.DoubleMatrix1DProcedure;
import cern.colt.matrix.tdouble.DoubleMatrix2D;
import cern.colt.matrix.tdouble.impl.DenseDoubleMatrix1D;
import cern.jet.math.tdouble.DoubleFunctions;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.util.Random;
import junit.framework.TestCase;

public abstract class DoubleMatrix2DTest
extends TestCase {
    protected DoubleMatrix2D A;
    protected DoubleMatrix2D B;
    protected DoubleMatrix2D Bt;
    protected int NROWS = 13;
    protected int NCOLUMNS = 17;
    protected double TOL = 1.0E-10;
    protected static final Random random = new Random(0L);

    public DoubleMatrix2DTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        this.createMatrices();
        this.populateMatrices();
    }

    protected abstract void createMatrices() throws Exception;

    protected void populateMatrices() {
        int n;
        int n2;
        ConcurrencyUtils.setThreadsBeginN_2D(1);
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            for (n = 0; n < this.A.columns(); ++n) {
                this.A.setQuick(n2, n, random.nextDouble());
            }
        }
        for (n2 = 0; n2 < this.B.rows(); ++n2) {
            for (n = 0; n < this.B.columns(); ++n) {
                this.B.setQuick(n2, n, random.nextDouble());
            }
        }
        for (n2 = 0; n2 < this.Bt.rows(); ++n2) {
            for (n = 0; n < this.Bt.columns(); ++n) {
                this.Bt.setQuick(n2, n, random.nextDouble());
            }
        }
    }

    protected void tearDown() throws Exception {
        this.Bt = null;
        this.B = null;
        this.A = null;
    }

    public void testAggregateDoubleDoubleFunctionDoubleFunction() {
        double d = 0.0;
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                double d2 = this.A.getQuick(i, j);
                d += d2 * d2;
            }
        }
        double d3 = this.A.aggregate(DoubleFunctions.plus, DoubleFunctions.square);
        DoubleMatrix2DTest.assertEquals((double)d, (double)d3, (double)this.TOL);
    }

    public void testAggregateDoubleDoubleFunctionDoubleFunctionDoubleProcedure() {
        DoubleProcedure doubleProcedure = new DoubleProcedure(){

            public boolean apply(double d) {
                return Math.abs(d) > 0.2;
            }
        };
        double d = 0.0;
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                double d2 = this.A.getQuick(i, j);
                if (!(Math.abs(d2) > 0.2)) continue;
                d += d2 * d2;
            }
        }
        double d3 = this.A.aggregate(DoubleFunctions.plus, DoubleFunctions.square, doubleProcedure);
        DoubleMatrix2DTest.assertEquals((double)d, (double)d3, (double)this.TOL);
    }

    public void testAggregateDoubleDoubleFunctionDoubleFunctionIntArrayListIntArrayList() {
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                intArrayList.add(i);
                intArrayList2.add(j);
            }
        }
        double d = 0.0;
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                double d2 = this.A.getQuick(i, j);
                d += d2 * d2;
            }
        }
        double d3 = this.A.aggregate(DoubleFunctions.plus, DoubleFunctions.square, intArrayList, intArrayList2);
        DoubleMatrix2DTest.assertEquals((double)d, (double)d3, (double)this.TOL);
    }

    public void testAggregateDoubleMatrix2DDoubleDoubleFunctionDoubleDoubleFunction() {
        double d = 0.0;
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                double d2 = this.A.getQuick(i, j);
                double d3 = this.B.getQuick(i, j);
                d += d2 * d3;
            }
        }
        double d4 = this.A.aggregate(this.B, DoubleFunctions.plus, DoubleFunctions.mult);
        DoubleMatrix2DTest.assertEquals((double)d, (double)d4, (double)this.TOL);
    }

    public void testAssignDouble() {
        double d = Math.random();
        this.A.assign(d);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DoubleMatrix2DTest.assertEquals((double)d, (double)this.A.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testAssignDoubleArrayArray() {
        int n;
        int n2;
        double[][] dArray = new double[this.A.rows()][this.A.columns()];
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            for (n = 0; n < this.A.columns(); ++n) {
                dArray[n2][n] = Math.random();
            }
        }
        this.A.assign(dArray);
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            DoubleMatrix2DTest.assertTrue((this.A.columns() == dArray[n2].length ? 1 : 0) != 0);
            for (n = 0; n < this.A.columns(); ++n) {
                DoubleMatrix2DTest.assertEquals((double)dArray[n2][n], (double)this.A.getQuick(n2, n), (double)this.TOL);
            }
        }
    }

    public void testAssignDoubleFunction() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        this.A.assign(DoubleFunctions.acos);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                double d = Math.acos(doubleMatrix2D.getQuick(i, j));
                DoubleMatrix2DTest.assertEquals((double)d, (double)this.A.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testAssignDoubleMatrix2D() {
        this.A.assign(this.B);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DoubleMatrix2DTest.assertEquals((double)this.B.getQuick(i, j), (double)this.A.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testAssignDoubleMatrix2DDoubleDoubleFunction() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        this.A.assign(this.B, DoubleFunctions.plus);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DoubleMatrix2DTest.assertEquals((double)(doubleMatrix2D.getQuick(i, j) + this.B.getQuick(i, j)), (double)this.A.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testAssignDoubleMatrix2DDoubleDoubleFunctionIntArrayListIntArrayList() {
        int n;
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        for (int i = 0; i < this.A.rows(); ++i) {
            for (n = 0; n < this.A.columns(); ++n) {
                intArrayList.add(i);
                intArrayList2.add(n);
            }
        }
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        this.A.assign(this.B, DoubleFunctions.div, intArrayList, intArrayList2);
        for (n = 0; n < this.A.rows(); ++n) {
            for (int i = 0; i < this.A.columns(); ++i) {
                DoubleMatrix2DTest.assertEquals((double)(doubleMatrix2D.getQuick(n, i) / this.B.getQuick(n, i)), (double)this.A.getQuick(n, i), (double)this.TOL);
            }
        }
    }

    public void testAssignDoubleProcedureDouble() {
        DoubleProcedure doubleProcedure = new DoubleProcedure(){

            public boolean apply(double d) {
                return Math.abs(d) > 0.1;
            }
        };
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        this.A.assign(doubleProcedure, -1.0);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                if (Math.abs(doubleMatrix2D.getQuick(i, j)) > 0.1) {
                    DoubleMatrix2DTest.assertEquals((double)-1.0, (double)this.A.getQuick(i, j), (double)this.TOL);
                    continue;
                }
                DoubleMatrix2DTest.assertEquals((double)doubleMatrix2D.getQuick(i, j), (double)this.A.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testAssignDoubleProcedureDoubleFunction() {
        DoubleProcedure doubleProcedure = new DoubleProcedure(){

            public boolean apply(double d) {
                return Math.abs(d) > 0.1;
            }
        };
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        this.A.assign(doubleProcedure, DoubleFunctions.tan);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                if (Math.abs(doubleMatrix2D.getQuick(i, j)) > 0.1) {
                    DoubleMatrix2DTest.assertEquals((double)Math.tan(doubleMatrix2D.getQuick(i, j)), (double)this.A.getQuick(i, j), (double)this.TOL);
                    continue;
                }
                DoubleMatrix2DTest.assertEquals((double)doubleMatrix2D.getQuick(i, j), (double)this.A.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testCardinality() {
        int n = this.A.cardinality();
        DoubleMatrix2DTest.assertEquals((int)(this.A.rows() * this.A.columns()), (int)n);
    }

    public void testEqualsDouble() {
        double d = 1.0;
        this.A.assign(d);
        boolean bl = this.A.equals(d);
        DoubleMatrix2DTest.assertTrue((boolean)bl);
        bl = this.A.equals(2.0);
        DoubleMatrix2DTest.assertFalse((boolean)bl);
    }

    public void testEqualsObject() {
        boolean bl = this.A.equals(this.A);
        DoubleMatrix2DTest.assertTrue((boolean)bl);
        bl = this.A.equals(this.B);
        DoubleMatrix2DTest.assertFalse((boolean)bl);
    }

    public void testForEachNonZero() {
        DoubleMatrix2D doubleMatrix2D = this.A.copy();
        IntIntDoubleFunction intIntDoubleFunction = new IntIntDoubleFunction(){

            public double apply(int n, int n2, double d) {
                return Math.sqrt(d);
            }
        };
        this.A.forEachNonZero(intIntDoubleFunction);
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DoubleMatrix2DTest.assertEquals((double)Math.sqrt(doubleMatrix2D.getQuick(i, j)), (double)this.A.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testMaxLocation() {
        this.A.assign(0.0);
        this.A.setQuick(this.A.rows() / 3, this.A.columns() / 3, 0.7);
        this.A.setQuick(this.A.rows() / 2, this.A.columns() / 2, 0.1);
        double[] dArray = this.A.getMaxLocation();
        DoubleMatrix2DTest.assertEquals((double)0.7, (double)dArray[0], (double)this.TOL);
        DoubleMatrix2DTest.assertEquals((int)(this.A.rows() / 3), (int)((int)dArray[1]));
        DoubleMatrix2DTest.assertEquals((int)(this.A.columns() / 3), (int)((int)dArray[2]));
    }

    public void testMinLocation() {
        this.A.assign(0.0);
        this.A.setQuick(this.A.rows() / 3, this.A.columns() / 3, -0.7);
        this.A.setQuick(this.A.rows() / 2, this.A.columns() / 2, -0.1);
        double[] dArray = this.A.getMinLocation();
        DoubleMatrix2DTest.assertEquals((double)-0.7, (double)dArray[0], (double)this.TOL);
        DoubleMatrix2DTest.assertEquals((int)(this.A.rows() / 3), (int)((int)dArray[1]));
        DoubleMatrix2DTest.assertEquals((int)(this.A.columns() / 3), (int)((int)dArray[2]));
    }

    public void testGetNegativeValues() {
        this.A.assign(0.0);
        this.A.setQuick(this.A.rows() / 3, this.A.columns() / 3, -0.7);
        this.A.setQuick(this.A.rows() / 2, this.A.columns() / 2, -0.1);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        this.A.getNegativeValues(intArrayList, intArrayList2, doubleArrayList);
        DoubleMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
        DoubleMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
        DoubleMatrix2DTest.assertEquals((int)2, (int)doubleArrayList.size());
        DoubleMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 3));
        DoubleMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 2));
        DoubleMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 3));
        DoubleMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 2));
        DoubleMatrix2DTest.assertTrue((boolean)doubleArrayList.contains(-0.7));
        DoubleMatrix2DTest.assertTrue((boolean)doubleArrayList.contains(-0.1));
    }

    public void testGetNonZeros() {
        this.A.assign(0.0);
        this.A.setQuick(this.A.rows() / 3, this.A.columns() / 3, 0.7);
        this.A.setQuick(this.A.rows() / 2, this.A.columns() / 2, 0.1);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        this.A.getNonZeros(intArrayList, intArrayList2, doubleArrayList);
        DoubleMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
        DoubleMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
        DoubleMatrix2DTest.assertEquals((int)2, (int)doubleArrayList.size());
        DoubleMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 3));
        DoubleMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 2));
        DoubleMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 3));
        DoubleMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 2));
        DoubleMatrix2DTest.assertTrue((boolean)doubleArrayList.contains(0.7));
        DoubleMatrix2DTest.assertTrue((boolean)doubleArrayList.contains(0.1));
    }

    public void testGetPositiveValues() {
        this.A.assign(0.0);
        this.A.setQuick(this.A.rows() / 3, this.A.columns() / 3, 0.7);
        this.A.setQuick(this.A.rows() / 2, this.A.columns() / 2, 0.1);
        IntArrayList intArrayList = new IntArrayList();
        IntArrayList intArrayList2 = new IntArrayList();
        DoubleArrayList doubleArrayList = new DoubleArrayList();
        this.A.getPositiveValues(intArrayList, intArrayList2, doubleArrayList);
        DoubleMatrix2DTest.assertEquals((int)2, (int)intArrayList.size());
        DoubleMatrix2DTest.assertEquals((int)2, (int)intArrayList2.size());
        DoubleMatrix2DTest.assertEquals((int)2, (int)doubleArrayList.size());
        DoubleMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 3));
        DoubleMatrix2DTest.assertTrue((boolean)intArrayList.contains(this.A.rows() / 2));
        DoubleMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 3));
        DoubleMatrix2DTest.assertTrue((boolean)intArrayList2.contains(this.A.columns() / 2));
        DoubleMatrix2DTest.assertTrue((boolean)doubleArrayList.contains(0.7));
        DoubleMatrix2DTest.assertTrue((boolean)doubleArrayList.contains(0.1));
    }

    public void testToArray() {
        double[][] dArray = this.A.toArray();
        DoubleMatrix2DTest.assertTrue((this.A.rows() == dArray.length ? 1 : 0) != 0);
        for (int i = 0; i < this.A.rows(); ++i) {
            DoubleMatrix2DTest.assertTrue((this.A.columns() == dArray[i].length ? 1 : 0) != 0);
            for (int j = 0; j < this.A.columns(); ++j) {
                DoubleMatrix2DTest.assertEquals((double)0.0, (double)Math.abs(dArray[i][j] - this.A.getQuick(i, j)), (double)this.TOL);
            }
        }
    }

    public void testVectorize() {
        DoubleMatrix1D doubleMatrix1D = this.A.vectorize();
        int n = 0;
        for (int i = 0; i < this.A.columns(); ++i) {
            for (int j = 0; j < this.A.rows(); ++j) {
                DoubleMatrix2DTest.assertEquals((double)this.A.getQuick(j, i), (double)doubleMatrix1D.getQuick(n++), (double)this.TOL);
            }
        }
    }

    public void testViewColumn() {
        DoubleMatrix1D doubleMatrix1D = this.A.viewColumn(this.A.columns() / 2);
        DoubleMatrix2DTest.assertEquals((long)this.A.rows(), (long)doubleMatrix1D.size());
        for (int i = 0; i < this.A.rows(); ++i) {
            DoubleMatrix2DTest.assertEquals((double)this.A.getQuick(i, this.A.columns() / 2), (double)doubleMatrix1D.getQuick(i), (double)this.TOL);
        }
    }

    public void testViewColumnFlip() {
        DoubleMatrix2D doubleMatrix2D = this.A.viewColumnFlip();
        DoubleMatrix2DTest.assertEquals((long)this.A.size(), (long)doubleMatrix2D.size());
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DoubleMatrix2DTest.assertEquals((double)this.A.getQuick(i, this.A.columns() - 1 - j), (double)doubleMatrix2D.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testViewDice() {
        DoubleMatrix2D doubleMatrix2D = this.A.viewDice();
        DoubleMatrix2DTest.assertEquals((int)this.A.rows(), (int)doubleMatrix2D.columns());
        DoubleMatrix2DTest.assertEquals((int)this.A.columns(), (int)doubleMatrix2D.rows());
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DoubleMatrix2DTest.assertEquals((double)this.A.getQuick(i, j), (double)doubleMatrix2D.getQuick(j, i), (double)this.TOL);
            }
        }
    }

    public void testViewPart() {
        DoubleMatrix2D doubleMatrix2D = this.A.viewPart(this.A.rows() / 2, this.A.columns() / 2, this.A.rows() / 3, this.A.columns() / 3);
        DoubleMatrix2DTest.assertEquals((int)(this.A.rows() / 3), (int)doubleMatrix2D.rows());
        DoubleMatrix2DTest.assertEquals((int)(this.A.columns() / 3), (int)doubleMatrix2D.columns());
        for (int i = 0; i < this.A.rows() / 3; ++i) {
            for (int j = 0; j < this.A.columns() / 3; ++j) {
                DoubleMatrix2DTest.assertEquals((double)this.A.getQuick(this.A.rows() / 2 + i, this.A.columns() / 2 + j), (double)doubleMatrix2D.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testViewRow() {
        DoubleMatrix1D doubleMatrix1D = this.A.viewRow(this.A.rows() / 2);
        DoubleMatrix2DTest.assertEquals((long)this.A.columns(), (long)doubleMatrix1D.size());
        for (int i = 0; i < this.A.columns(); ++i) {
            DoubleMatrix2DTest.assertEquals((double)this.A.getQuick(this.A.rows() / 2, i), (double)doubleMatrix1D.getQuick(i), (double)this.TOL);
        }
    }

    public void testViewRowFlip() {
        DoubleMatrix2D doubleMatrix2D = this.A.viewRowFlip();
        DoubleMatrix2DTest.assertEquals((long)this.A.size(), (long)doubleMatrix2D.size());
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                DoubleMatrix2DTest.assertEquals((double)this.A.getQuick(this.A.rows() - 1 - i, j), (double)doubleMatrix2D.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testViewSelectionDoubleMatrix1DProcedure() {
        this.A.assign(0.0);
        this.A.setQuick(this.A.rows() / 4, 0, 2.0);
        this.A.setQuick(this.A.rows() / 2, 0, 2.0);
        DoubleMatrix2D doubleMatrix2D = this.A.viewSelection(new DoubleMatrix1DProcedure(){

            public boolean apply(DoubleMatrix1D doubleMatrix1D) {
                return Math.abs(doubleMatrix1D.getQuick(0) - 2.0) < DoubleMatrix2DTest.this.TOL;
            }
        });
        DoubleMatrix2DTest.assertEquals((int)2, (int)doubleMatrix2D.rows());
        DoubleMatrix2DTest.assertEquals((int)this.A.columns(), (int)doubleMatrix2D.columns());
        DoubleMatrix2DTest.assertEquals((double)this.A.getQuick(this.A.rows() / 4, 0), (double)doubleMatrix2D.getQuick(0, 0), (double)this.TOL);
        DoubleMatrix2DTest.assertEquals((double)this.A.getQuick(this.A.rows() / 2, 0), (double)doubleMatrix2D.getQuick(1, 0), (double)this.TOL);
    }

    public void testViewSelectionIntArrayIntArray() {
        int[] nArray = new int[]{this.A.rows() / 6, this.A.rows() / 5, this.A.rows() / 4, this.A.rows() / 3, this.A.rows() / 2};
        int[] nArray2 = new int[]{this.A.columns() / 6, this.A.columns() / 5, this.A.columns() / 4, this.A.columns() / 3, this.A.columns() / 2, this.A.columns() - 1};
        DoubleMatrix2D doubleMatrix2D = this.A.viewSelection(nArray, nArray2);
        DoubleMatrix2DTest.assertEquals((int)nArray.length, (int)doubleMatrix2D.rows());
        DoubleMatrix2DTest.assertEquals((int)nArray2.length, (int)doubleMatrix2D.columns());
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                DoubleMatrix2DTest.assertEquals((double)this.A.getQuick(nArray[i], nArray2[j]), (double)doubleMatrix2D.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testViewSorted() {
        DoubleMatrix2D doubleMatrix2D = this.A.viewSorted(1);
        for (int i = 0; i < this.A.rows() - 1; ++i) {
            DoubleMatrix2DTest.assertTrue((doubleMatrix2D.getQuick(i + 1, 1) >= doubleMatrix2D.getQuick(i, 1) ? 1 : 0) != 0);
        }
    }

    public void testViewStrides() {
        int n = 3;
        int n2 = 5;
        DoubleMatrix2D doubleMatrix2D = this.A.viewStrides(n, n2);
        for (int i = 0; i < doubleMatrix2D.rows(); ++i) {
            for (int j = 0; j < doubleMatrix2D.columns(); ++j) {
                DoubleMatrix2DTest.assertEquals((double)this.A.getQuick(i * n, j * n2), (double)doubleMatrix2D.getQuick(i, j), (double)this.TOL);
            }
        }
    }

    public void testZMultDoubleMatrix1DDoubleMatrix1DDoubleDoubleBoolean() {
        int n;
        double d;
        int n2;
        DenseDoubleMatrix1D denseDoubleMatrix1D = new DenseDoubleMatrix1D(this.A.columns());
        int n3 = 0;
        while ((long)n3 < denseDoubleMatrix1D.size()) {
            ((DoubleMatrix1D)denseDoubleMatrix1D).setQuick(n3, Math.random());
            ++n3;
        }
        double d2 = 3.0;
        double d3 = 5.0;
        DoubleMatrix1D doubleMatrix1D = DoubleFactory1D.dense.random(this.A.rows());
        double[] dArray = doubleMatrix1D.toArray();
        doubleMatrix1D = this.A.zMult(denseDoubleMatrix1D, doubleMatrix1D, d2, d3, false);
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            d = 0.0;
            for (n = 0; n < this.A.columns(); ++n) {
                d += this.A.getQuick(n2, n) * ((DoubleMatrix1D)denseDoubleMatrix1D).getQuick(n);
            }
            dArray[n2] = d * d2 + dArray[n2] * d3;
        }
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            DoubleMatrix2DTest.assertEquals((double)dArray[n2], (double)doubleMatrix1D.getQuick(n2), (double)this.TOL);
        }
        doubleMatrix1D = null;
        doubleMatrix1D = this.A.zMult(denseDoubleMatrix1D, doubleMatrix1D, d2, d3, false);
        dArray = new double[this.A.rows()];
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            d = 0.0;
            for (n = 0; n < this.A.columns(); ++n) {
                d += this.A.getQuick(n2, n) * ((DoubleMatrix1D)denseDoubleMatrix1D).getQuick(n);
            }
            dArray[n2] = d * d2;
        }
        for (n2 = 0; n2 < this.A.rows(); ++n2) {
            DoubleMatrix2DTest.assertEquals((double)dArray[n2], (double)doubleMatrix1D.getQuick(n2), (double)this.TOL);
        }
        denseDoubleMatrix1D = new DenseDoubleMatrix1D(this.A.rows());
        n2 = 0;
        while ((long)n2 < denseDoubleMatrix1D.size()) {
            ((DoubleMatrix1D)denseDoubleMatrix1D).setQuick(n2, Math.random());
            ++n2;
        }
        doubleMatrix1D = DoubleFactory1D.dense.random(this.A.columns());
        dArray = doubleMatrix1D.toArray();
        doubleMatrix1D = this.A.zMult(denseDoubleMatrix1D, doubleMatrix1D, d2, d3, true);
        for (n2 = 0; n2 < this.A.columns(); ++n2) {
            d = 0.0;
            for (n = 0; n < this.A.rows(); ++n) {
                d += this.A.getQuick(n, n2) * ((DoubleMatrix1D)denseDoubleMatrix1D).getQuick(n);
            }
            dArray[n2] = d * d2 + dArray[n2] * d3;
        }
        for (n2 = 0; n2 < this.A.columns(); ++n2) {
            DoubleMatrix2DTest.assertEquals((double)dArray[n2], (double)doubleMatrix1D.getQuick(n2), (double)this.TOL);
        }
        doubleMatrix1D = null;
        doubleMatrix1D = this.A.zMult(denseDoubleMatrix1D, doubleMatrix1D, d2, d3, true);
        dArray = new double[this.A.columns()];
        for (n2 = 0; n2 < this.A.columns(); ++n2) {
            d = 0.0;
            for (n = 0; n < this.A.rows(); ++n) {
                d += this.A.getQuick(n, n2) * ((DoubleMatrix1D)denseDoubleMatrix1D).getQuick(n);
            }
            dArray[n2] = d * d2;
        }
        for (n2 = 0; n2 < this.A.columns(); ++n2) {
            DoubleMatrix2DTest.assertEquals((double)dArray[n2], (double)doubleMatrix1D.getQuick(n2), (double)this.TOL);
        }
    }

    public void testZMultDoubleMatrix2DDoubleMatrix2DDoubleDoubleBooleanBoolean() {
        int n;
        double d;
        int n2;
        int n3;
        double d2 = 3.0;
        double d3 = 5.0;
        DoubleMatrix2D doubleMatrix2D = DoubleFactory2D.dense.random(this.A.rows(), this.A.rows());
        double[][] dArray = doubleMatrix2D.toArray();
        doubleMatrix2D = this.A.zMult(this.Bt, doubleMatrix2D, d2, d3, false, false);
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                d = 0.0;
                for (n = 0; n < this.A.columns(); ++n) {
                    d += this.A.getQuick(n2, n) * this.Bt.getQuick(n, n3);
                }
                dArray[n2][n3] = d * d2 + dArray[n2][n3] * d3;
            }
        }
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                DoubleMatrix2DTest.assertEquals((double)dArray[n3][n2], (double)doubleMatrix2D.getQuick(n3, n2), (double)this.TOL);
            }
        }
        doubleMatrix2D = null;
        doubleMatrix2D = this.A.zMult(this.Bt, doubleMatrix2D, d2, d3, false, false);
        dArray = new double[this.A.rows()][this.A.rows()];
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                d = 0.0;
                for (n = 0; n < this.A.columns(); ++n) {
                    d += this.A.getQuick(n2, n) * this.Bt.getQuick(n, n3);
                }
                dArray[n2][n3] = d * d2;
            }
        }
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                DoubleMatrix2DTest.assertEquals((double)dArray[n3][n2], (double)doubleMatrix2D.getQuick(n3, n2), (double)this.TOL);
            }
        }
        doubleMatrix2D = DoubleFactory2D.dense.random(this.A.columns(), this.A.columns());
        dArray = doubleMatrix2D.toArray();
        doubleMatrix2D = this.A.zMult(this.B, doubleMatrix2D, d2, d3, true, false);
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                d = 0.0;
                for (n = 0; n < this.A.rows(); ++n) {
                    d += this.A.getQuick(n, n2) * this.B.getQuick(n, n3);
                }
                dArray[n2][n3] = d * d2 + dArray[n2][n3] * d3;
            }
        }
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                DoubleMatrix2DTest.assertEquals((double)dArray[n3][n2], (double)doubleMatrix2D.getQuick(n3, n2), (double)this.TOL);
            }
        }
        doubleMatrix2D = null;
        doubleMatrix2D = this.A.zMult(this.B, doubleMatrix2D, d2, d3, true, false);
        dArray = new double[this.A.columns()][this.A.columns()];
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                d = 0.0;
                for (n = 0; n < this.A.rows(); ++n) {
                    d += this.A.getQuick(n, n2) * this.B.getQuick(n, n3);
                }
                dArray[n2][n3] = d * d2;
            }
        }
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                DoubleMatrix2DTest.assertEquals((double)dArray[n3][n2], (double)doubleMatrix2D.getQuick(n3, n2), (double)this.TOL);
            }
        }
        doubleMatrix2D = DoubleFactory2D.dense.random(this.A.rows(), this.A.rows());
        dArray = doubleMatrix2D.toArray();
        doubleMatrix2D = this.A.zMult(this.B, doubleMatrix2D, d2, d3, false, true);
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                d = 0.0;
                for (n = 0; n < this.A.columns(); ++n) {
                    d += this.A.getQuick(n2, n) * this.B.getQuick(n3, n);
                }
                dArray[n2][n3] = d * d2 + dArray[n2][n3] * d3;
            }
        }
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                DoubleMatrix2DTest.assertEquals((double)dArray[n3][n2], (double)doubleMatrix2D.getQuick(n3, n2), (double)this.TOL);
            }
        }
        doubleMatrix2D = null;
        doubleMatrix2D = this.A.zMult(this.B, doubleMatrix2D, d2, d3, false, true);
        dArray = new double[this.A.rows()][this.A.rows()];
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                d = 0.0;
                for (n = 0; n < this.A.columns(); ++n) {
                    d += this.A.getQuick(n2, n) * this.B.getQuick(n3, n);
                }
                dArray[n2][n3] = d * d2;
            }
        }
        for (n3 = 0; n3 < this.A.rows(); ++n3) {
            for (n2 = 0; n2 < this.A.rows(); ++n2) {
                DoubleMatrix2DTest.assertEquals((double)dArray[n3][n2], (double)doubleMatrix2D.getQuick(n3, n2), (double)this.TOL);
            }
        }
        doubleMatrix2D = DoubleFactory2D.dense.random(this.A.columns(), this.A.columns());
        dArray = doubleMatrix2D.toArray();
        doubleMatrix2D = this.A.zMult(this.Bt, doubleMatrix2D, d2, d3, true, true);
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                d = 0.0;
                for (n = 0; n < this.A.rows(); ++n) {
                    d += this.A.getQuick(n, n2) * this.Bt.getQuick(n3, n);
                }
                dArray[n2][n3] = d * d2 + dArray[n2][n3] * d3;
            }
        }
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                DoubleMatrix2DTest.assertEquals((double)dArray[n3][n2], (double)doubleMatrix2D.getQuick(n3, n2), (double)this.TOL);
            }
        }
        doubleMatrix2D = null;
        doubleMatrix2D = this.A.zMult(this.Bt, doubleMatrix2D, d2, d3, true, true);
        dArray = new double[this.A.columns()][this.A.columns()];
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                d = 0.0;
                for (n = 0; n < this.A.rows(); ++n) {
                    d += this.A.getQuick(n, n2) * this.Bt.getQuick(n3, n);
                }
                dArray[n2][n3] = d * d2;
            }
        }
        for (n3 = 0; n3 < this.A.columns(); ++n3) {
            for (n2 = 0; n2 < this.A.columns(); ++n2) {
                DoubleMatrix2DTest.assertEquals((double)dArray[n3][n2], (double)doubleMatrix2D.getQuick(n3, n2), (double)this.TOL);
            }
        }
    }

    public void testZSum() {
        double d = this.A.zSum();
        double d2 = 0.0;
        for (int i = 0; i < this.A.rows(); ++i) {
            for (int j = 0; j < this.A.columns(); ++j) {
                d2 += this.A.getQuick(i, j);
            }
        }
        DoubleMatrix2DTest.assertEquals((double)d2, (double)d, (double)this.TOL);
    }
}

