/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;

public class MatrixMatrixProduct
extends MatrixParameter
implements VariableListener {
    MatrixParameter left;
    MatrixParameter right;
    MatrixParameter inPlace;
    private final int leftDim;
    private final int rightDim;
    private final int midDim;
    Parameter columnMask;
    boolean[][] oldStoredValues;
    double[][] storedValues;
    boolean[][] areValuesStored;
    private Bounds bounds = null;

    public MatrixMatrixProduct(MatrixParameter[] matrixParameterArray, Parameter parameter) {
        super(null, matrixParameterArray);
        this.columnMask = parameter;
        this.left = matrixParameterArray[0];
        this.right = matrixParameterArray[1];
        if (matrixParameterArray.length == 3) {
            this.inPlace = matrixParameterArray[2];
            this.inPlace.addVariableListener(this);
        }
        this.storedValues = new double[this.left.getRowDimension()][this.right.getColumnDimension()];
        this.areValuesStored = new boolean[this.left.getRowDimension()][this.right.getColumnDimension()];
        this.oldStoredValues = new boolean[this.left.getRowDimension()][this.right.getColumnDimension()];
        for (int i = 0; i < this.left.getRowDimension(); ++i) {
            for (int j = 0; j < this.right.getColumnDimension(); ++j) {
                this.areValuesStored[i][j] = false;
            }
        }
        this.leftDim = this.left.getRowDimension();
        this.midDim = this.left.getColumnDimension();
        this.rightDim = this.right.getColumnDimension();
        this.left.addVariableListener(this);
        this.right.addVariableListener(this);
        this.inPlace.addVariableListener(this);
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        int n2;
        if (variable == this.right) {
            for (n2 = 0; n2 < this.getRowDimension(); ++n2) {
                this.areValuesStored[n2][n / this.right.getRowDimension()] = false;
            }
        }
        if (variable == this.left) {
            for (n2 = 0; n2 < this.getColumnDimension(); ++n2) {
                this.areValuesStored[n % this.left.getRowDimension()][n2] = false;
            }
        }
        this.fireParameterChangedEvent(n, changeType);
    }

    @Override
    public int getDimension() {
        return this.leftDim * this.rightDim;
    }

    @Override
    public void addBounds(Bounds bounds) {
        this.bounds = bounds;
    }

    @Override
    protected void storeValues() {
        System.arraycopy(this.areValuesStored, 0, this.oldStoredValues, 0, this.areValuesStored.length);
        this.left.storeParameterValues();
        this.right.storeParameterValues();
        this.inPlace.storeParameterValues();
    }

    @Override
    protected void restoreValues() {
        this.left.restoreParameterValues();
        this.right.restoreVariableValues();
        this.inPlace.restoreParameterValues();
        this.areValuesStored = this.oldStoredValues;
    }

    @Override
    public double getParameterValue(int n, int n2) {
        double d = 0.0;
        if (this.columnMask.getParameterValue(n2) != 0.0 && !this.areValuesStored[n][n2]) {
            for (int i = 0; i < this.midDim; ++i) {
                d += this.left.getParameterValue(n, i) * this.right.getParameterValue(i, n2);
            }
            this.inPlace.setParameterValue(n, n2, d);
            this.areValuesStored[n][n2] = true;
        } else {
            d = this.inPlace.getParameterValue(n, n2);
        }
        return d;
    }

    @Override
    public double[][] getParameterAsMatrix() {
        return super.getParameterAsMatrix();
    }

    @Override
    public Parameter getParameter(int n) {
        for (int i = 0; i < this.leftDim; ++i) {
            this.getParameterValue(i, n);
        }
        return this.inPlace.getParameter(n);
    }

    @Override
    public int getRowDimension() {
        return this.leftDim;
    }

    @Override
    public int getColumnDimension() {
        return this.rightDim;
    }

    @Override
    public double getParameterValue(int n) {
        return this.getParameterValue(n / this.getRowDimension(), n % this.rightDim);
    }

    private void throwError(String string) throws RuntimeException {
        throw new RuntimeException("Object " + this.getId() + " is a deterministic function. Calling " + string + " is not allowed");
    }

    @Override
    public void setParameterValue(int n, double d) {
        this.throwError("setParameterValue()");
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        this.throwError("setParameterValueQuietly()");
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, double d) {
        this.throwError("setParameterValueNotifyChangedAll()");
    }

    @Override
    public Bounds<Double> getBounds() {
        return this.bounds;
    }

    @Override
    public void addDimension(int n, double d) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double removeDimension(int n) {
        throw new RuntimeException("Not yet implemented.");
    }
}

