/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.lapack;

import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import lombok.Generated;

public final class TRSV {
    public static void Usolve(FastMatrix U, double[] px, int startx, int incx) {
        int n = U.getColumnsCount();
        int lda = U.getColumnIncrement();
        int start = U.getStartPosition();
        double[] pu = U.getStorage();
        if (incx == 1) {
            int xend;
            int jx = xend = startx + n - 1;
            int ju = start + (n - 1) * (lda + 1);
            while (jx >= startx) {
                double tmp = px[jx];
                if (tmp != 0.0) {
                    px[jx] = tmp /= pu[ju];
                    int ix = jx - 1;
                    int il = ju - 1;
                    while (ix >= startx) {
                        int n2 = ix--;
                        px[n2] = px[n2] - tmp * pu[il];
                        --il;
                    }
                }
                --jx;
                ju -= lda + 1;
            }
        } else {
            int xend;
            int jx = xend = startx + n * incx;
            int ju = start + (n - 1) * (lda + 1);
            while (jx != startx) {
                double tmp = px[jx -= incx];
                if (tmp != 0.0) {
                    px[jx] = tmp /= pu[ju];
                    int ix = jx;
                    int il = ju - 1;
                    while (ix != startx) {
                        int n3 = ix -= incx;
                        px[n3] = px[n3] - tmp * pu[il];
                        --il;
                    }
                }
                ju -= lda + 1;
            }
        }
    }

    public static void Lsolve(FastMatrix L, double[] px, int startx, int incx) {
        int n = L.getColumnsCount();
        int lda = L.getColumnIncrement();
        int start = L.getStartPosition();
        double[] pl = L.getStorage();
        if (incx == 1) {
            int xend = startx + n;
            int ix = startx;
            int il = start;
            while (ix < xend) {
                double tmp = px[ix];
                if (tmp != 0.0) {
                    px[ix] = tmp /= pl[il];
                    int jx = ix + 1;
                    int jl = il + 1;
                    while (jx < xend) {
                        int n2 = jx++;
                        px[n2] = px[n2] - tmp * pl[jl];
                        ++jl;
                    }
                }
                ++ix;
                il += lda + 1;
            }
        } else {
            int xend = startx + n * incx;
            int ix = startx;
            int il = start;
            while (ix < xend) {
                double tmp = px[ix];
                if (tmp != 0.0) {
                    px[ix] = tmp /= pl[il];
                    int jx = ix + incx;
                    int jl = il + 1;
                    while (jx < xend) {
                        int n3 = jx;
                        px[n3] = px[n3] - tmp * pl[jl];
                        jx += incx;
                        ++jl;
                    }
                }
                ix += incx;
                il += lda + 1;
            }
        }
    }

    public static void Utsolve(FastMatrix U, double[] px, int startx, int incx) {
        int n = U.getColumnsCount();
        int lda = U.getColumnIncrement();
        int start = U.getStartPosition();
        double[] pu = U.getStorage();
        if (incx == 1) {
            int xend = startx + n;
            int ix = startx;
            int il = start;
            while (ix < xend) {
                double tmp = px[ix];
                int jl = il;
                int jx = startx;
                while (jx < ix) {
                    tmp -= px[jx] * pu[jl];
                    ++jx;
                    ++jl;
                }
                px[ix] = tmp /= pu[jl];
                ++ix;
                il += lda;
            }
        } else {
            int xend = startx + n * incx;
            int ix = startx;
            int il = start;
            while (ix < xend) {
                double tmp = px[ix];
                int jl = il;
                int jx = startx;
                while (jx < ix) {
                    tmp -= px[jx] * pu[jl];
                    jx += incx;
                    ++jl;
                }
                px[ix] = tmp /= pu[jl];
                ix += incx;
                il += lda;
            }
        }
    }

    public static void Ltsolve(FastMatrix L, double[] px, int startx, int incx) {
        int n = L.getColumnsCount();
        int lda = L.getColumnIncrement();
        int start = L.getStartPosition();
        double[] pl = L.getStorage();
        if (incx == 1) {
            int xend = startx + n;
            int jx = startx + n - 1;
            int jl = start + (n - 1) * (lda + 1);
            while (jx >= startx) {
                double tmp = px[jx];
                int ix = jx + 1;
                int il = jl + 1;
                while (ix < xend) {
                    tmp -= pl[il] * px[ix];
                    ++ix;
                    ++il;
                }
                px[jx] = tmp /= pl[jl];
                --jx;
                jl -= lda + 1;
            }
        } else {
            int xend;
            int jx = xend = startx + n * incx;
            int jl = start + (n - 1) * (lda + 1);
            while (jx != startx) {
                double tmp = px[jx -= incx];
                int ix = jx + incx;
                int il = jl + 1;
                while (ix != xend) {
                    tmp -= pl[il] * px[ix];
                    ix += incx;
                    ++il;
                }
                px[jx] = tmp /= pl[jl];
                jl -= lda + 1;
            }
        }
    }

    @Generated
    private TRSV() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

