/*
 * Decompiled with CFR 0.152.
 */
package choco.cp.solver.constraints.integer;

import choco.cp.solver.constraints.integer.intlincomb.IntLinCombEQ;
import choco.cp.solver.constraints.integer.intlincomb.IntLinCombGEQ;
import choco.cp.solver.constraints.integer.intlincomb.IntLinCombLEQ;
import choco.cp.solver.constraints.integer.intlincomb.IntLinCombNEQ;
import choco.cp.solver.constraints.integer.intlincomb.IntLinCombOp;
import choco.kernel.common.util.iterators.DisposableIntIterator;
import choco.kernel.solver.ContradictionException;
import choco.kernel.solver.Solver;
import choco.kernel.solver.constraints.AbstractSConstraint;
import choco.kernel.solver.constraints.integer.AbstractLargeIntSConstraint;
import choco.kernel.solver.propagation.event.ConstraintEvent;
import choco.kernel.solver.variables.integer.IntDomainVar;

public final class IntLinComb
extends AbstractLargeIntSConstraint {
    public static final int EQ = 0;
    public static final int GEQ = 1;
    public static final int NEQ = 2;
    public static final int LEQ = 3;
    protected final int nbPosVars;
    protected final IntLinCombOp intlincomb;

    public IntLinComb(IntDomainVar[] lvars, int[] lcoeffs, int nbPositive, int c, int linOperator) {
        super(IntLinComb.priority(lvars.length), lvars);
        this.nbPosVars = nbPositive;
        switch (linOperator) {
            case 0: {
                this.intlincomb = new IntLinCombEQ(lcoeffs, nbPositive, c, lvars, this);
                break;
            }
            case 2: {
                this.intlincomb = new IntLinCombNEQ(lcoeffs, nbPositive, c, lvars, this);
                break;
            }
            case 1: {
                this.intlincomb = new IntLinCombGEQ(lcoeffs, nbPositive, c, lvars, this);
                break;
            }
            case 3: {
                this.intlincomb = new IntLinCombLEQ(lcoeffs, nbPositive, c, lvars, this);
                break;
            }
            default: {
                this.intlincomb = null;
            }
        }
    }

    private static int priority(int nbVars) {
        switch (nbVars) {
            case 0: 
            case 1: {
                return ConstraintEvent.UNARY;
            }
            case 2: {
                return ConstraintEvent.BINARY;
            }
            case 3: {
                return ConstraintEvent.TERNARY;
            }
        }
        return ConstraintEvent.LINEAR;
    }

    @Override
    public int getFilteredEventMask(int idx) {
        return 11;
    }

    @Override
    public void propagate() throws ContradictionException {
        this.intlincomb.filter(true, 2);
    }

    @Override
    public void awakeOnInf(int idx) throws ContradictionException {
        if (idx < this.nbPosVars) {
            this.intlincomb.filter(true, 1);
        } else {
            this.intlincomb.filter(false, 1);
        }
    }

    @Override
    public void awakeOnSup(int idx) throws ContradictionException {
        if (idx < this.nbPosVars) {
            this.intlincomb.filter(false, 1);
        } else {
            this.intlincomb.filter(true, 1);
        }
    }

    @Override
    public void awakeOnInst(int idx) throws ContradictionException {
        this.propagate();
    }

    @Override
    public void awakeOnRem(int idx, int x) throws ContradictionException {
    }

    @Override
    public void awakeOnRemovals(int idx, DisposableIntIterator deltaDomain) throws ContradictionException {
    }

    @Override
    public boolean isSatisfied(int[] tuple) {
        return this.intlincomb.isSatisfied(tuple);
    }

    @Override
    public AbstractSConstraint<IntDomainVar> opposite(Solver solver) {
        return this.intlincomb.opposite(solver);
    }

    @Override
    public String pretty() {
        return this.intlincomb.pretty();
    }
}

