## ----setup01, include=FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse   = TRUE,
  comment    = "#>",
  fig.path   = "fig/overview-", 
  fig.ext    = "png",
  fig.width  = 6,
  fig.height = 4,
  dpi        = 300,
  fig.retina = 2,
  fig.align  = "center",
  out.width  = "70%"
)

if (requireNamespace("cifmodeling", quietly = TRUE)) {
  library(cifmodeling)
} else {
  stop("Package 'cifmodeling' is not available during vignette build.")
}
library(nleqslv)
library(boot)
library(ggplot2)
library(ggsurvfit)
library(patchwork)
data("diabetes.complications", package = "cifmodeling")
set.seed(1)

## ----example01-1, fig.cap="Aalen-Johansen cumulative incidence curves from cifplot()", warning=FALSE, message=FALSE----
library(cifmodeling)
data(diabetes.complications)
cifplot(Event(t,epsilon)~fruitq, data=diabetes.complications, 
        outcome.type="competing-risk", panel.per.event=TRUE)

