## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ----MadLdrs------------------------------------------------------------------
library(MaddisonData)
MadLdrs <- MaddisonLeaders()
(MadLdrsSum <- summary(MadLdrs, 'yearBegin'))

## ----MadLdrs1349--------------------------------------------------------------
MadDat1349 <- subset(MaddisonData, (year > 1348) & 
                       !(ISO %in% c('QAT', 'KWT', 'ARE', 'NOR') ))
MadLdrs1349 <- MaddisonLeaders(data=MadDat1349)
(MadLdrsSum1349 <- summary(MadLdrs1349, 'yearBegin'))

## ----NLD----------------------------------------------------------------------
NLDdat <- subset(MaddisonData, ISO=='NLD')
head(NLDdat)

## ----MadLdrs1349a-------------------------------------------------------------
MadDat1349a <- subset(MaddisonData, (year > 1348) & 
                       !(ISO %in% c('QAT', 'KWT', 'ARE', 'NOR', 'LUX') ))
MadLdrs1349a <- MaddisonLeaders(data=MadDat1349a)
(MadLdrsSum1349a <- summary(MadLdrs1349a, 'yearBegin'))

## ----Napoleon-----------------------------------------------------------------
(NLD1808 <- subset(NLDdat, year %in% 1807:1808))
(dNLD1808 <- diff(log(NLD1808$gdppc)))
expm1(dNLD1808)

## ----NLD_SGP------------------------------------------------------------------
NLD_SGP <- subset(MadDat1349, ISO %in% c('NLD', 'GBR', 'USA', 'SGP'))
NLD_SGPsum <- MaddisonLeaders(data=NLD_SGP)
summary(NLD_SGPsum, 'yearBegin')
(NLD_SGP0 <- ggplotPath(y='gdppc', group='ISO', data=NLD_SGP, scaley=1000))

## ----NLDrefs------------------------------------------------------------------
NLDrefs <- getMaddisonSources('NLD')

## ----NLD_SGP1-----------------------------------------------------------------
x0 <- yr(c('1642-01-04', '1702-03-08', '1812-06-18', '1861-04-12', 
           '1914-07-28', '1929-03-04', '1933-03-04', '1939-09-01')) 
x1 <- yr(c('1651-09-03', '1714-08-01', '1815-02-17', '1865-05-26', 
           '1918-11-11', '1933-03-04', '1945-04-12', '1945-09-02'))
Vlines <- sort(unique(c(x0, x1)))
attr(Vlines, 'color') <- c(rep('grey', 10), 'red', 'green4', 'grey', 
                           'green4', 'grey')
Hlines = c(1, 3, 5, 10, 30, 50)
Lbls <- data.frame(x=c(1500, 1600, 1740, 1870, (x0+x1)/2, 1985), 
                   y=c(1.35,  5.7, 1.65,  3.5, 13, rep(15, 4), 36, 21, 64, 8), 
    label=c('UK', 'Holland', 'US', 'Netherlands', 'English civil war', 
            'Queen Ann', 'War of 1812', 'American Civil War', 'WW1', 'Hoover',
            'FDR', 'WW2', 'Singapore'), 
    srt=c(0, 0, 40, 50, rep(90, 8), 87), 
    col=c('red', 'orange', 'blue', 'orange', 'red', rep('grey', 4), 'red',
          'green4', 'grey', 'darkolivegreen4') )

(NLD_SGP1 <- ggplotPath(y='gdppc', group='ISO', data=NLD_SGP, scaley=1000, 
                        ylab='GDP per capita (2011 K$ PPP)', 
                        hlines=Hlines, vlines=Vlines, labels=Lbls, 
                        fontsize=20, 
                        color=c('red', 'orange', 'darkolivegreen4', 'blue'), 
                        linetype=c(1:2, 1, 1)))



## ----NLD_SGP1s, eval=FALSE----------------------------------------------------
# svg('NLD_SGP.svg')
# NLD_SGP1
# dev.off()

## ----NLDrefs2-----------------------------------------------------------------
(GBRrefs <- getMaddisonSources('GBR'))
(USArefs <- getMaddisonSources('USA'))
(SGPrefs <- getMaddisonSources('SGP'))

