/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tlong.impl;

import cern.colt.function.tlong.IntIntLongFunction;
import cern.colt.function.tlong.LongFunction;
import cern.colt.function.tlong.LongLongFunction;
import cern.colt.function.tlong.LongProcedure;
import cern.colt.list.tint.IntArrayList;
import cern.colt.list.tlong.LongArrayList;
import cern.colt.matrix.AbstractMatrix1D;
import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.MatrixVectorReader;
import cern.colt.matrix.tlong.LongMatrix1D;
import cern.colt.matrix.tlong.LongMatrix2D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix1D;
import cern.colt.matrix.tlong.impl.DenseLongMatrix2D;
import cern.colt.matrix.tlong.impl.SelectedDenseColumnLongMatrix2D;
import cern.jet.math.tlong.LongFunctions;
import cern.jet.math.tlong.LongMult;
import cern.jet.math.tlong.LongPlusMultFirst;
import cern.jet.math.tlong.LongPlusMultSecond;
import edu.emory.mathcs.utils.ConcurrencyUtils;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class DenseColumnLongMatrix2D
extends LongMatrix2D {
    static final long serialVersionUID = 1020177651L;
    protected long[] elements;

    public DenseColumnLongMatrix2D(long[][] lArray) {
        this(lArray.length, lArray.length == 0 ? 0 : lArray[0].length);
        this.assign(lArray);
    }

    public DenseColumnLongMatrix2D(int n, int n2) {
        this.setUp(n, n2, 0, 0, 1, n);
        this.elements = new long[n * n2];
    }

    public DenseColumnLongMatrix2D(int n, int n2, long[] lArray, int n3, int n4, int n5, int n6, boolean bl) {
        this.setUp(n, n2, n3, n4, n5, n6);
        this.elements = lArray;
        this.isNoView = !bl;
    }

    public DenseColumnLongMatrix2D(MatrixVectorReader matrixVectorReader) throws IOException {
        block7: {
            int n;
            long[] lArray;
            int[] nArray;
            int[] nArray2;
            int n2;
            MatrixInfo matrixInfo;
            block6: {
                matrixInfo = matrixVectorReader.hasInfo() ? matrixVectorReader.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                if (matrixInfo.isPattern()) {
                    throw new UnsupportedOperationException("Pattern matrices are not supported");
                }
                if (matrixInfo.isDense()) {
                    throw new UnsupportedOperationException("Dense matrices are not supported");
                }
                if (matrixInfo.isComplex()) {
                    throw new UnsupportedOperationException("Complex matrices are not supported");
                }
                MatrixSize matrixSize = matrixVectorReader.readMatrixSize(matrixInfo);
                this.setUp(matrixSize.numRows(), matrixSize.numColumns());
                this.elements = new long[this.rows * this.columns];
                n2 = matrixSize.numEntries();
                nArray2 = new int[n2];
                nArray = new int[n2];
                lArray = new long[n2];
                matrixVectorReader.readCoordinate(nArray, nArray2, lArray);
                for (n = 0; n < n2; ++n) {
                    this.setQuick(nArray[n], nArray2[n], lArray[n]);
                }
                if (!matrixInfo.isSymmetric()) break block6;
                for (n = 0; n < n2; ++n) {
                    if (nArray[n] == nArray2[n]) continue;
                    this.setQuick(nArray2[n], nArray[n], lArray[n]);
                }
                break block7;
            }
            if (!matrixInfo.isSkewSymmetric()) break block7;
            for (n = 0; n < n2; ++n) {
                if (nArray[n] == nArray2[n]) continue;
                this.setQuick(nArray2[n], nArray[n], -lArray[n]);
            }
        }
    }

    public long aggregate(final LongLongFunction longLongFunction, final LongFunction longFunction) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int n = (int)this.index(0, 0);
        long l = 0L;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = longFunction.apply(DenseColumnLongMatrix2D.this.elements[n + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (n4 - 1) * DenseColumnLongMatrix2D.this.columnStride]);
                        int n6 = 1;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n + n2 * DenseColumnLongMatrix2D.this.columnStride;
                            int n42 = DenseColumnLongMatrix2D.this.rows - n6;
                            while (--n42 >= 0) {
                                l = longLongFunction.apply(l, longFunction.apply(DenseColumnLongMatrix2D.this.elements[n42 * DenseColumnLongMatrix2D.this.rowStride + n3]));
                            }
                            n6 = 0;
                        }
                        return l;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            l = longFunction.apply(this.elements[n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride]);
            int n6 = 1;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n + n7 * this.columnStride;
                int n9 = this.rows - n6;
                while (--n9 >= 0) {
                    l = longLongFunction.apply(l, longFunction.apply(this.elements[n9 * this.rowStride + n8]));
                }
                n6 = 0;
            }
        }
        return l;
    }

    public long aggregate(final LongLongFunction longLongFunction, final LongFunction longFunction, final LongProcedure longProcedure) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int n = (int)this.index(0, 0);
        long l = 0L;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = DenseColumnLongMatrix2D.this.elements[n + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (n4 - 1) * DenseColumnLongMatrix2D.this.columnStride];
                        long l2 = 0L;
                        if (longProcedure.apply(l)) {
                            l2 = longFunction.apply(l);
                        }
                        int n6 = 1;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n + n2 * DenseColumnLongMatrix2D.this.columnStride;
                            int n42 = DenseColumnLongMatrix2D.this.rows - n6;
                            while (--n42 >= 0) {
                                l = DenseColumnLongMatrix2D.this.elements[n42 * DenseColumnLongMatrix2D.this.rowStride + n3];
                                if (!longProcedure.apply(l)) continue;
                                l2 = longLongFunction.apply(l2, longFunction.apply(l));
                            }
                            n6 = 0;
                        }
                        return l2;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            long l2 = this.elements[n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            if (longProcedure.apply(l2)) {
                l = longFunction.apply(l2);
            }
            int n6 = 1;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n + n7 * this.columnStride;
                int n9 = this.rows - n6;
                while (--n9 >= 0) {
                    l2 = this.elements[n9 * this.rowStride + n8];
                    if (!longProcedure.apply(l2)) continue;
                    l = longLongFunction.apply(l, longFunction.apply(l2));
                }
                n6 = 0;
            }
        }
        return l;
    }

    public long aggregate(final LongLongFunction longLongFunction, final LongFunction longFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int n = (int)this.index(0, 0);
        int n2 = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        long l = 0L;
        int n3 = ConcurrencyUtils.getNumberOfThreads();
        if (n3 > 1 && n2 >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n3 = Math.min(n3, this.columns);
            Future[] futureArray = new Future[n3];
            int n4 = n2 / n3;
            for (int i = 0; i < n3; ++i) {
                final int n5 = n2 - i * n4;
                final int n6 = i == n3 - 1 ? 0 : n5 - n4;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = longFunction.apply(DenseColumnLongMatrix2D.this.elements[n + nArray[n5 - 1] * DenseColumnLongMatrix2D.this.rowStride + nArray2[n5 - 1] * DenseColumnLongMatrix2D.this.columnStride]);
                        int n2 = n5 - 1;
                        while (--n2 >= n6) {
                            l = longLongFunction.apply(l, longFunction.apply(DenseColumnLongMatrix2D.this.elements[n + nArray[n2] * DenseColumnLongMatrix2D.this.rowStride + nArray2[n2] * DenseColumnLongMatrix2D.this.columnStride]));
                        }
                        return l;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            l = longFunction.apply(this.elements[n + nArray[n2 - 1] * this.rowStride + nArray2[n2 - 1] * this.columnStride]);
            int n7 = n2 - 1;
            while (--n7 >= 0) {
                l = longLongFunction.apply(l, longFunction.apply(this.elements[n + nArray[n7] * this.rowStride + nArray2[n7] * this.columnStride]));
            }
        }
        return l;
    }

    public long aggregate(LongMatrix2D longMatrix2D, final LongLongFunction longLongFunction, final LongLongFunction longLongFunction2) {
        if (!(longMatrix2D instanceof DenseColumnLongMatrix2D)) {
            return super.aggregate(longMatrix2D, longLongFunction, longLongFunction2);
        }
        this.checkShape(longMatrix2D);
        if (this.size() == 0L) {
            throw new IllegalArgumentException("size() = 0");
        }
        final int n = (int)this.index(0, 0);
        final int n2 = (int)longMatrix2D.index(0, 0);
        final int n3 = longMatrix2D.rowStride();
        final int n4 = longMatrix2D.columnStride();
        final long[] lArray = (long[])longMatrix2D.elements();
        long l = 0L;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = this.columns - i * n6;
                final int n8 = i == n5 - 1 ? 0 : n7 - n6;
                futureArray[i] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = longLongFunction2.apply(DenseColumnLongMatrix2D.this.elements[n + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (n7 - 1) * DenseColumnLongMatrix2D.this.columnStride], lArray[n2 + (DenseColumnLongMatrix2D.this.rows - 1) * n3 + (n7 - 1) * n4]);
                        int n6 = 1;
                        int n22 = n7;
                        while (--n22 >= n8) {
                            int n32 = n + n22 * DenseColumnLongMatrix2D.this.columnStride;
                            int n42 = n2 + n22 * n4;
                            int n5 = DenseColumnLongMatrix2D.this.rows - n6;
                            while (--n5 >= 0) {
                                l = longLongFunction.apply(l, longLongFunction2.apply(DenseColumnLongMatrix2D.this.elements[n5 * DenseColumnLongMatrix2D.this.rowStride + n32], lArray[n5 * n3 + n42]));
                            }
                            n6 = 0;
                        }
                        return l;
                    }
                });
            }
            l = ConcurrencyUtils.waitForCompletion(futureArray, longLongFunction);
        } else {
            int n9 = 1;
            l = longLongFunction2.apply(this.elements[n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride], lArray[n2 + (this.rows - 1) * n3 + (this.columns - 1) * n4]);
            int n10 = this.columns;
            while (--n10 >= 0) {
                int n11 = n + n10 * this.columnStride;
                int n12 = n2 + n10 * n4;
                int n13 = this.rows - n9;
                while (--n13 >= 0) {
                    l = longLongFunction.apply(l, longLongFunction2.apply(this.elements[n13 * this.rowStride + n11], lArray[n13 * n3 + n12]));
                }
                n9 = 0;
            }
        }
        return l;
    }

    public LongMatrix2D assign(final LongFunction longFunction) {
        if (longFunction instanceof LongMult) {
            long l = ((LongMult)longFunction).multiplicator;
            if (l == 1L) {
                return this;
            }
            if (l == 0L) {
                return this.assign(0L);
            }
        }
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n9 = n + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (n4 - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        if (longFunction instanceof LongMult) {
                            long l = ((LongMult)longFunction).multiplicator;
                            int n2 = n4;
                            while (--n2 >= n5) {
                                int n3 = n9;
                                int n42 = DenseColumnLongMatrix2D.this.rows;
                                while (--n42 >= 0) {
                                    int n52 = n3;
                                    DenseColumnLongMatrix2D.this.elements[n52] = DenseColumnLongMatrix2D.this.elements[n52] * l;
                                    n3 -= DenseColumnLongMatrix2D.this.rowStride;
                                }
                                n9 -= DenseColumnLongMatrix2D.this.columnStride;
                            }
                        } else {
                            int n6 = n4;
                            while (--n6 >= n5) {
                                int n7 = n9;
                                int n8 = DenseColumnLongMatrix2D.this.rows;
                                while (--n8 >= 0) {
                                    DenseColumnLongMatrix2D.this.elements[n7] = longFunction.apply(DenseColumnLongMatrix2D.this.elements[n7]);
                                    n7 -= DenseColumnLongMatrix2D.this.rowStride;
                                }
                                n9 -= DenseColumnLongMatrix2D.this.columnStride;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            if (longFunction instanceof LongMult) {
                long l = ((LongMult)longFunction).multiplicator;
                int n7 = this.columns;
                while (--n7 >= 0) {
                    int n8 = n6;
                    int n9 = this.rows;
                    while (--n9 >= 0) {
                        int n10 = n8;
                        this.elements[n10] = this.elements[n10] * l;
                        n8 -= this.rowStride;
                    }
                    n6 -= this.columnStride;
                }
            } else {
                int n11 = this.columns;
                while (--n11 >= 0) {
                    int n12 = n6;
                    int n13 = this.rows;
                    while (--n13 >= 0) {
                        this.elements[n12] = longFunction.apply(this.elements[n12]);
                        n12 -= this.rowStride;
                    }
                    n6 -= this.columnStride;
                }
            }
        }
        return this;
    }

    public LongMatrix2D assign(final LongProcedure longProcedure, final LongFunction longFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (n4 - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n6;
                            int n42 = DenseColumnLongMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                long l = DenseColumnLongMatrix2D.this.elements[n3];
                                if (longProcedure.apply(l)) {
                                    DenseColumnLongMatrix2D.this.elements[n3] = longFunction.apply(l);
                                }
                                n3 -= DenseColumnLongMatrix2D.this.rowStride;
                            }
                            n6 -= DenseColumnLongMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    long l = this.elements[n8];
                    if (longProcedure.apply(l)) {
                        this.elements[n8] = longFunction.apply(l);
                    }
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return this;
    }

    public LongMatrix2D assign(final LongProcedure longProcedure, final long l) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (n4 - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n6;
                            int n42 = DenseColumnLongMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                long l2 = DenseColumnLongMatrix2D.this.elements[n3];
                                if (longProcedure.apply(l2)) {
                                    DenseColumnLongMatrix2D.this.elements[n3] = l;
                                }
                                n3 -= DenseColumnLongMatrix2D.this.rowStride;
                            }
                            n6 -= DenseColumnLongMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    long l2 = this.elements[n8];
                    if (longProcedure.apply(l2)) {
                        this.elements[n8] = l;
                    }
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return this;
    }

    public LongMatrix2D assign(final long l) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (n4 - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n6;
                            int n42 = DenseColumnLongMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                DenseColumnLongMatrix2D.this.elements[n3] = l;
                                n3 -= DenseColumnLongMatrix2D.this.rowStride;
                            }
                            n6 -= DenseColumnLongMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    this.elements[n8] = l;
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return this;
    }

    public LongMatrix2D assign(final long[] lArray) {
        if ((long)lArray.length != this.size()) {
            throw new IllegalArgumentException("Must have same length: length=" + lArray.length + " rows()*columns()=" + this.rows() * this.columns());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView) {
            System.arraycopy(lArray, 0, this.elements, 0, lArray.length);
        } else {
            final int n2 = (int)this.index(0, 0);
            if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
                n = Math.min(n, this.columns);
                Future[] futureArray = new Future[n];
                int n3 = this.columns / n;
                for (int i = 0; i < n; ++i) {
                    final int n4 = this.columns - i * n3;
                    final int n5 = i == n - 1 ? 0 : n4 - n3;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n2 + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (n4 - 1) * DenseColumnLongMatrix2D.this.columnStride;
                            int n22 = DenseColumnLongMatrix2D.this.rows - 1 + (n4 - 1) * DenseColumnLongMatrix2D.this.rows;
                            int n3 = n4;
                            while (--n3 >= n5) {
                                int n42 = n;
                                int n52 = DenseColumnLongMatrix2D.this.rows;
                                while (--n52 >= 0) {
                                    DenseColumnLongMatrix2D.this.elements[n42] = lArray[n22--];
                                    n42 -= DenseColumnLongMatrix2D.this.rowStride;
                                }
                                n -= DenseColumnLongMatrix2D.this.columnStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n6 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
                int n7 = lArray.length - 1;
                int n8 = this.columns;
                while (--n8 >= 0) {
                    int n9 = n6;
                    int n10 = this.rows;
                    while (--n10 >= 0) {
                        this.elements[n9] = lArray[n7--];
                        n9 -= this.rowStride;
                    }
                    n6 -= this.columnStride;
                }
            }
        }
        return this;
    }

    public LongMatrix2D assign(final long[][] lArray) {
        if (lArray.length != this.rows) {
            throw new IllegalArgumentException("Must have same number of rows: rows=" + lArray.length + "columns()=" + this.rows());
        }
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0);
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n3 = this.rows / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = this.rows - i * n3;
                final int n5 = i == n - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n2 + (n4 - 1) * DenseColumnLongMatrix2D.this.rowStride + (DenseColumnLongMatrix2D.this.columns - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        int n22 = n4;
                        while (--n22 >= n5) {
                            long[] lArray2 = lArray[n22];
                            if (lArray2.length != DenseColumnLongMatrix2D.this.columns) {
                                throw new IllegalArgumentException("Must have same number of columns in every row: column=" + lArray2.length + "columns()=" + DenseColumnLongMatrix2D.this.columns());
                            }
                            int n3 = n;
                            int n42 = DenseColumnLongMatrix2D.this.columns;
                            while (--n42 >= 0) {
                                DenseColumnLongMatrix2D.this.elements[n3] = lArray2[n42];
                                n3 -= DenseColumnLongMatrix2D.this.columnStride;
                            }
                            n -= DenseColumnLongMatrix2D.this.rowStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.rows;
            while (--n7 >= 0) {
                long[] lArray2 = lArray[n7];
                if (lArray2.length != this.columns) {
                    throw new IllegalArgumentException("Must have same number of columns in every row: column=" + lArray2.length + "columns()=" + this.columns());
                }
                int n8 = n6;
                int n9 = this.columns;
                while (--n9 >= 0) {
                    this.elements[n8] = lArray2[n9];
                    n8 -= this.columnStride;
                }
                n6 -= this.rowStride;
            }
        }
        return this;
    }

    public LongMatrix2D assign(LongMatrix2D longMatrix2D) {
        if (!(longMatrix2D instanceof DenseColumnLongMatrix2D)) {
            super.assign(longMatrix2D);
            return this;
        }
        DenseColumnLongMatrix2D denseColumnLongMatrix2D = (DenseColumnLongMatrix2D)longMatrix2D;
        if (denseColumnLongMatrix2D == this) {
            return this;
        }
        this.checkShape(denseColumnLongMatrix2D);
        int n = ConcurrencyUtils.getNumberOfThreads();
        if (this.isNoView && denseColumnLongMatrix2D.isNoView) {
            System.arraycopy(denseColumnLongMatrix2D.elements, 0, this.elements, 0, this.elements.length);
            return this;
        }
        if (this.haveSharedCells(denseColumnLongMatrix2D)) {
            LongMatrix2D longMatrix2D2 = denseColumnLongMatrix2D.copy();
            if (!(longMatrix2D2 instanceof DenseColumnLongMatrix2D)) {
                super.assign(denseColumnLongMatrix2D);
                return this;
            }
            denseColumnLongMatrix2D = (DenseColumnLongMatrix2D)longMatrix2D2;
        }
        final int n2 = (int)denseColumnLongMatrix2D.index(0, 0);
        final int n3 = (int)this.index(0, 0);
        final int n4 = denseColumnLongMatrix2D.columnStride;
        final int n5 = denseColumnLongMatrix2D.rowStride;
        final long[] lArray = denseColumnLongMatrix2D.elements;
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n6 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n7 = this.columns - i * n6;
                final int n8 = i == n - 1 ? 0 : n7 - n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n3 + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (n7 - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        int n22 = n2 + (DenseColumnLongMatrix2D.this.rows - 1) * n5 + (n7 - 1) * n4;
                        int n32 = n7;
                        while (--n32 >= n8) {
                            int n42 = n;
                            int n52 = n22;
                            int n6 = DenseColumnLongMatrix2D.this.rows;
                            while (--n6 >= 0) {
                                DenseColumnLongMatrix2D.this.elements[n42] = lArray[n52];
                                n42 -= DenseColumnLongMatrix2D.this.rowStride;
                                n52 -= n5;
                            }
                            n -= DenseColumnLongMatrix2D.this.columnStride;
                            n22 -= n4;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n3 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n10 = n2 + (this.rows - 1) * n5 + (this.columns - 1) * n4;
            int n11 = this.columns;
            while (--n11 >= 0) {
                int n12 = n9;
                int n13 = n10;
                int n14 = this.rows;
                while (--n14 >= 0) {
                    this.elements[n12] = lArray[n13];
                    n12 -= this.rowStride;
                    n13 -= n5;
                }
                n9 -= this.columnStride;
                n10 -= n4;
            }
        }
        return this;
    }

    public LongMatrix2D assign(LongMatrix2D longMatrix2D, final LongLongFunction longLongFunction) {
        long l;
        if (longLongFunction instanceof LongPlusMultSecond && (l = ((LongPlusMultSecond)longLongFunction).multiplicator) == 0L) {
            return this;
        }
        if (longLongFunction instanceof LongPlusMultFirst && (l = ((LongPlusMultFirst)longLongFunction).multiplicator) == 0L) {
            return this.assign(longMatrix2D);
        }
        if (!(longMatrix2D instanceof DenseColumnLongMatrix2D)) {
            super.assign(longMatrix2D, longLongFunction);
            return this;
        }
        DenseColumnLongMatrix2D denseColumnLongMatrix2D = (DenseColumnLongMatrix2D)longMatrix2D;
        this.checkShape(longMatrix2D);
        final long[] lArray = denseColumnLongMatrix2D.elements;
        final int n = (int)denseColumnLongMatrix2D.index(0, 0);
        final int n2 = (int)this.index(0, 0);
        final int n3 = denseColumnLongMatrix2D.columnStride;
        final int n4 = denseColumnLongMatrix2D.rowStride;
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = this.columns - i * n6;
                final int n8 = i == n5 - 1 ? 0 : n7 - n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n45 = n2 + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (n7 - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        int n210 = n + (DenseColumnLongMatrix2D.this.rows - 1) * n4 + (n7 - 1) * n3;
                        if (longLongFunction == LongFunctions.mult) {
                            int n310 = n7;
                            while (--n310 >= n8) {
                                int n46 = n45;
                                int n5 = n210;
                                int n6 = DenseColumnLongMatrix2D.this.rows;
                                while (--n6 >= 0) {
                                    int n72 = n46;
                                    DenseColumnLongMatrix2D.this.elements[n72] = DenseColumnLongMatrix2D.this.elements[n72] * lArray[n5];
                                    n46 -= DenseColumnLongMatrix2D.this.rowStride;
                                    n5 -= n4;
                                }
                                n45 -= DenseColumnLongMatrix2D.this.columnStride;
                                n210 -= n3;
                            }
                        } else if (longLongFunction == LongFunctions.div) {
                            int n82 = n7;
                            while (--n82 >= n8) {
                                int n9 = n45;
                                int n10 = n210;
                                int n11 = DenseColumnLongMatrix2D.this.rows;
                                while (--n11 >= 0) {
                                    int n12 = n9;
                                    DenseColumnLongMatrix2D.this.elements[n12] = DenseColumnLongMatrix2D.this.elements[n12] / lArray[n10];
                                    n9 -= DenseColumnLongMatrix2D.this.rowStride;
                                    n10 -= n4;
                                }
                                n45 -= DenseColumnLongMatrix2D.this.columnStride;
                                n210 -= n3;
                            }
                        } else if (longLongFunction instanceof LongPlusMultSecond) {
                            long l = ((LongPlusMultSecond)longLongFunction).multiplicator;
                            if (l == 1L) {
                                int n13 = n7;
                                while (--n13 >= n8) {
                                    int n14 = n45;
                                    int n15 = n210;
                                    int n16 = DenseColumnLongMatrix2D.this.rows;
                                    while (--n16 >= 0) {
                                        int n17 = n14;
                                        DenseColumnLongMatrix2D.this.elements[n17] = DenseColumnLongMatrix2D.this.elements[n17] + lArray[n15];
                                        n14 -= DenseColumnLongMatrix2D.this.rowStride;
                                        n15 -= n4;
                                    }
                                    n45 -= DenseColumnLongMatrix2D.this.columnStride;
                                    n210 -= n3;
                                }
                            } else if (l == -1L) {
                                int n18 = n7;
                                while (--n18 >= n8) {
                                    int n19 = n45;
                                    int n20 = n210;
                                    int n21 = DenseColumnLongMatrix2D.this.rows;
                                    while (--n21 >= 0) {
                                        int n22 = n19;
                                        DenseColumnLongMatrix2D.this.elements[n22] = DenseColumnLongMatrix2D.this.elements[n22] - lArray[n20];
                                        n19 -= DenseColumnLongMatrix2D.this.rowStride;
                                        n20 -= n4;
                                    }
                                    n45 -= DenseColumnLongMatrix2D.this.columnStride;
                                    n210 -= n3;
                                }
                            } else {
                                int n23 = n7;
                                while (--n23 >= n8) {
                                    int n24 = n45;
                                    int n25 = n210;
                                    int n26 = DenseColumnLongMatrix2D.this.rows;
                                    while (--n26 >= 0) {
                                        int n27 = n24;
                                        DenseColumnLongMatrix2D.this.elements[n27] = DenseColumnLongMatrix2D.this.elements[n27] + l * lArray[n25];
                                        n24 -= DenseColumnLongMatrix2D.this.rowStride;
                                        n25 -= n4;
                                    }
                                    n45 -= DenseColumnLongMatrix2D.this.columnStride;
                                    n210 -= n3;
                                }
                            }
                        } else if (longLongFunction instanceof LongPlusMultFirst) {
                            long l = ((LongPlusMultFirst)longLongFunction).multiplicator;
                            if (l == 1L) {
                                int n28 = n7;
                                while (--n28 >= n8) {
                                    int n29 = n45;
                                    int n30 = n210;
                                    int n31 = DenseColumnLongMatrix2D.this.rows;
                                    while (--n31 >= 0) {
                                        int n32 = n29;
                                        DenseColumnLongMatrix2D.this.elements[n32] = DenseColumnLongMatrix2D.this.elements[n32] + lArray[n30];
                                        n29 -= DenseColumnLongMatrix2D.this.rowStride;
                                        n30 -= n4;
                                    }
                                    n45 -= DenseColumnLongMatrix2D.this.columnStride;
                                    n210 -= n3;
                                }
                            } else if (l == -1L) {
                                int n33 = n7;
                                while (--n33 >= n8) {
                                    int n34 = n45;
                                    int n35 = n210;
                                    int n36 = DenseColumnLongMatrix2D.this.rows;
                                    while (--n36 >= 0) {
                                        DenseColumnLongMatrix2D.this.elements[n34] = lArray[n35] - DenseColumnLongMatrix2D.this.elements[n34];
                                        n34 -= DenseColumnLongMatrix2D.this.rowStride;
                                        n35 -= n4;
                                    }
                                    n45 -= DenseColumnLongMatrix2D.this.columnStride;
                                    n210 -= n3;
                                }
                            } else {
                                int n37 = n7;
                                while (--n37 >= n8) {
                                    int n38 = n45;
                                    int n39 = n210;
                                    int n40 = DenseColumnLongMatrix2D.this.rows;
                                    while (--n40 >= 0) {
                                        DenseColumnLongMatrix2D.this.elements[n38] = l * DenseColumnLongMatrix2D.this.elements[n38] + lArray[n39];
                                        n38 -= DenseColumnLongMatrix2D.this.rowStride;
                                        n39 -= n4;
                                    }
                                    n45 -= DenseColumnLongMatrix2D.this.columnStride;
                                    n210 -= n3;
                                }
                            }
                        } else {
                            int n41 = n7;
                            while (--n41 >= n8) {
                                int n42 = n45;
                                int n43 = n210;
                                int n44 = DenseColumnLongMatrix2D.this.rows;
                                while (--n44 >= 0) {
                                    DenseColumnLongMatrix2D.this.elements[n42] = longLongFunction.apply(DenseColumnLongMatrix2D.this.elements[n42], lArray[n43]);
                                    n42 -= DenseColumnLongMatrix2D.this.rowStride;
                                    n43 -= n4;
                                }
                                n45 -= DenseColumnLongMatrix2D.this.columnStride;
                                n210 -= n3;
                            }
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n10 = n + (this.rows - 1) * n4 + (this.columns - 1) * n3;
            if (longLongFunction == LongFunctions.mult) {
                int n11 = this.columns;
                while (--n11 >= 0) {
                    int n12 = n9;
                    int n13 = n10;
                    int n14 = this.rows;
                    while (--n14 >= 0) {
                        int n15 = n12;
                        this.elements[n15] = this.elements[n15] * lArray[n13];
                        n12 -= this.rowStride;
                        n13 -= n4;
                    }
                    n9 -= this.columnStride;
                    n10 -= n3;
                }
            } else if (longLongFunction == LongFunctions.div) {
                int n16 = this.columns;
                while (--n16 >= 0) {
                    int n17 = n9;
                    int n18 = n10;
                    int n19 = this.rows;
                    while (--n19 >= 0) {
                        int n20 = n17;
                        this.elements[n20] = this.elements[n20] / lArray[n18];
                        n17 -= this.rowStride;
                        n18 -= n4;
                    }
                    n9 -= this.columnStride;
                    n10 -= n3;
                }
            } else if (longLongFunction instanceof LongPlusMultSecond) {
                long l2 = ((LongPlusMultSecond)longLongFunction).multiplicator;
                if (l2 == 1L) {
                    int n21 = this.columns;
                    while (--n21 >= 0) {
                        int n22 = n9;
                        int n23 = n10;
                        int n24 = this.rows;
                        while (--n24 >= 0) {
                            int n25 = n22;
                            this.elements[n25] = this.elements[n25] + lArray[n23];
                            n22 -= this.rowStride;
                            n23 -= n4;
                        }
                        n9 -= this.columnStride;
                        n10 -= n3;
                    }
                } else if (l2 == -1L) {
                    int n26 = this.columns;
                    while (--n26 >= 0) {
                        int n27 = n9;
                        int n28 = n10;
                        int n29 = this.rows;
                        while (--n29 >= 0) {
                            int n30 = n27;
                            this.elements[n30] = this.elements[n30] - lArray[n28];
                            n27 -= this.rowStride;
                            n28 -= n4;
                        }
                        n9 -= this.columnStride;
                        n10 -= n3;
                    }
                } else {
                    int n31 = this.columns;
                    while (--n31 >= 0) {
                        int n32 = n9;
                        int n33 = n10;
                        int n34 = this.rows;
                        while (--n34 >= 0) {
                            int n35 = n32;
                            this.elements[n35] = this.elements[n35] + l2 * lArray[n33];
                            n32 -= this.rowStride;
                            n33 -= n4;
                        }
                        n9 -= this.columnStride;
                        n10 -= n3;
                    }
                }
            } else if (longLongFunction instanceof LongPlusMultFirst) {
                long l3 = ((LongPlusMultFirst)longLongFunction).multiplicator;
                if (l3 == 1L) {
                    int n36 = this.columns;
                    while (--n36 >= 0) {
                        int n37 = n9;
                        int n38 = n10;
                        int n39 = this.rows;
                        while (--n39 >= 0) {
                            int n40 = n37;
                            this.elements[n40] = this.elements[n40] + lArray[n38];
                            n37 -= this.rowStride;
                            n38 -= n4;
                        }
                        n9 -= this.columnStride;
                        n10 -= n3;
                    }
                } else if (l3 == -1L) {
                    int n41 = this.columns;
                    while (--n41 >= 0) {
                        int n42 = n9;
                        int n43 = n10;
                        int n44 = this.rows;
                        while (--n44 >= 0) {
                            this.elements[n42] = lArray[n43] - this.elements[n42];
                            n42 -= this.rowStride;
                            n43 -= n4;
                        }
                        n9 -= this.columnStride;
                        n10 -= n3;
                    }
                } else {
                    int n45 = this.columns;
                    while (--n45 >= 0) {
                        int n46 = n9;
                        int n47 = n10;
                        int n48 = this.rows;
                        while (--n48 >= 0) {
                            this.elements[n46] = l3 * this.elements[n46] + lArray[n47];
                            n46 -= this.rowStride;
                            n47 -= n4;
                        }
                        n9 -= this.columnStride;
                        n10 -= n3;
                    }
                }
            } else {
                int n49 = this.columns;
                while (--n49 >= 0) {
                    int n50 = n9;
                    int n51 = n10;
                    int n52 = this.rows;
                    while (--n52 >= 0) {
                        this.elements[n50] = longLongFunction.apply(this.elements[n50], lArray[n51]);
                        n50 -= this.rowStride;
                        n51 -= n4;
                    }
                    n9 -= this.columnStride;
                    n10 -= n3;
                }
            }
        }
        return this;
    }

    public LongMatrix2D assign(LongMatrix2D longMatrix2D, final LongLongFunction longLongFunction, IntArrayList intArrayList, IntArrayList intArrayList2) {
        this.checkShape(longMatrix2D);
        if (!(longMatrix2D instanceof DenseColumnLongMatrix2D)) {
            super.assign(longMatrix2D, longLongFunction);
            return this;
        }
        DenseColumnLongMatrix2D denseColumnLongMatrix2D = (DenseColumnLongMatrix2D)longMatrix2D;
        int n = intArrayList.size();
        final int[] nArray = intArrayList.elements();
        final int[] nArray2 = intArrayList2.elements();
        final long[] lArray = denseColumnLongMatrix2D.elements();
        final int n2 = (int)denseColumnLongMatrix2D.index(0, 0);
        final int n3 = (int)this.index(0, 0);
        final int n4 = denseColumnLongMatrix2D.columnStride();
        final int n5 = denseColumnLongMatrix2D.rowStride();
        int n6 = ConcurrencyUtils.getNumberOfThreads();
        if (n6 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
            n6 = Math.min(n6, this.columns);
            Future[] futureArray = new Future[n6];
            int n7 = n / n6;
            for (int i = 0; i < n6; ++i) {
                final int n8 = n - i * n7;
                final int n9 = i == n6 - 1 ? 0 : n8 - n7;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n8;
                        while (--n >= n9) {
                            int n22 = n3 + nArray[n] * DenseColumnLongMatrix2D.this.rowStride + nArray2[n] * DenseColumnLongMatrix2D.this.columnStride;
                            int n32 = n2 + nArray[n] * n5 + nArray2[n] * n4;
                            DenseColumnLongMatrix2D.this.elements[n22] = longLongFunction.apply(DenseColumnLongMatrix2D.this.elements[n22], lArray[n32]);
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n10 = n;
            while (--n10 >= 0) {
                int n11 = n3 + nArray[n10] * this.rowStride + nArray2[n10] * this.columnStride;
                int n12 = n2 + nArray[n10] * n5 + nArray2[n10] * n4;
                this.elements[n11] = longLongFunction.apply(this.elements[n11], lArray[n12]);
            }
        }
        return this;
    }

    public int cardinality() {
        int n = 0;
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        final int n3 = (int)this.index(0, 0);
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n4;
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            Integer[] integerArray = new Integer[n2];
            int n5 = this.columns / n2;
            for (n4 = 0; n4 < n2; ++n4) {
                final int n6 = this.columns - n4 * n5;
                final int n7 = n4 == n2 - 1 ? 0 : n6 - n5;
                futureArray[n4] = ConcurrencyUtils.submit(new Callable<Integer>(){

                    @Override
                    public Integer call() throws Exception {
                        int n = 0;
                        int n2 = n3 + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (n6 - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        int n32 = n6;
                        while (--n32 >= n7) {
                            int n4 = n2;
                            int n5 = DenseColumnLongMatrix2D.this.rows;
                            while (--n5 >= 0) {
                                if (DenseColumnLongMatrix2D.this.elements[n4] != 0L) {
                                    ++n;
                                }
                                n4 -= DenseColumnLongMatrix2D.this.rowStride;
                            }
                            n2 -= DenseColumnLongMatrix2D.this.columnStride;
                        }
                        return n;
                    }
                });
            }
            try {
                for (n4 = 0; n4 < n2; ++n4) {
                    integerArray[n4] = (Integer)futureArray[n4].get();
                }
                n = integerArray[0];
                for (n4 = 1; n4 < n2; ++n4) {
                    n += integerArray[n4].intValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n8 = n3 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n9 = this.columns;
            while (--n9 >= 0) {
                int n10 = n8;
                int n11 = this.rows;
                while (--n11 >= 0) {
                    if (this.elements[n10] != 0L) {
                        ++n;
                    }
                    n10 -= this.rowStride;
                }
                n8 -= this.columnStride;
            }
        }
        return n;
    }

    public long[] elements() {
        return this.elements;
    }

    public LongMatrix2D forEachNonZero(final IntIntLongFunction intIntLongFunction) {
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n3 = this.columns / n2;
            for (int i = 0; i < n2; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n2 - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n6 = n + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (n4 - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        int n2 = n4;
                        while (--n2 >= n5) {
                            int n3 = n6;
                            int n42 = DenseColumnLongMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                long l = DenseColumnLongMatrix2D.this.elements[n3];
                                if (l != 0L) {
                                    DenseColumnLongMatrix2D.this.elements[n3] = intIntLongFunction.apply(n42, n2, l);
                                }
                                n3 -= DenseColumnLongMatrix2D.this.rowStride;
                            }
                            n6 -= DenseColumnLongMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    long l = this.elements[n8];
                    if (l != 0L) {
                        this.elements[n8] = intIntLongFunction.apply(n9, n7, l);
                    }
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return this;
    }

    public DenseLongMatrix2D getRowMajor() {
        DenseLongMatrix2D denseLongMatrix2D = new DenseLongMatrix2D(this.rows, this.columns);
        final int n = (int)denseLongMatrix2D.index(0, 0);
        final int n2 = denseLongMatrix2D.rowStride();
        final int n3 = denseLongMatrix2D.columnStride();
        final long[] lArray = denseLongMatrix2D.elements();
        final int n4 = (int)this.index(0, 0);
        int n5 = ConcurrencyUtils.getNumberOfThreads();
        if (n5 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n5 = Math.min(n5, this.columns);
            Future[] futureArray = new Future[n5];
            int n6 = this.columns / n5;
            for (int i = 0; i < n5; ++i) {
                final int n7 = this.columns - i * n6;
                final int n8 = i == n5 - 1 ? 0 : n7 - n6;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n9 = n4 + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (n7 - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        int n22 = n + (DenseColumnLongMatrix2D.this.rows - 1) * n2 + (n7 - 1) * n3;
                        int n32 = n7;
                        while (--n32 >= n8) {
                            int n42 = n9;
                            int n5 = n22;
                            int n6 = DenseColumnLongMatrix2D.this.rows;
                            while (--n6 >= 0) {
                                lArray[n5] = DenseColumnLongMatrix2D.this.elements[n42];
                                n42 -= DenseColumnLongMatrix2D.this.rowStride;
                                n5 -= n2;
                            }
                            n9 -= DenseColumnLongMatrix2D.this.columnStride;
                            n22 -= n3;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n9 = n4 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n10 = n + (this.rows - 1) * n2 + (this.columns - 1) * n3;
            int n11 = this.columns;
            while (--n11 >= 0) {
                int n12 = n9;
                int n13 = n10;
                int n14 = this.rows;
                while (--n14 >= 0) {
                    lArray[n13] = this.elements[n12];
                    n12 -= this.rowStride;
                    n13 -= n2;
                }
                n9 -= this.columnStride;
                n10 -= n3;
            }
        }
        return denseLongMatrix2D;
    }

    public void getNegativeValues(IntArrayList intArrayList, IntArrayList intArrayList2, LongArrayList longArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        longArrayList.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.columns; ++i) {
            int n2 = n;
            for (int j = 0; j < this.rows; ++j) {
                long l = this.elements[n2];
                if (l < 0L) {
                    intArrayList.add(j);
                    intArrayList2.add(i);
                    longArrayList.add(l);
                }
                n2 += this.rowStride;
            }
            n += this.columnStride;
        }
    }

    public void getNonZeros(IntArrayList intArrayList, IntArrayList intArrayList2, LongArrayList longArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        longArrayList.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.columns; ++i) {
            int n2 = n;
            for (int j = 0; j < this.rows; ++j) {
                long l = this.elements[n2];
                if (l != 0L) {
                    intArrayList.add(j);
                    intArrayList2.add(i);
                    longArrayList.add(l);
                }
                n2 += this.rowStride;
            }
            n += this.columnStride;
        }
    }

    public void getPositiveValues(IntArrayList intArrayList, IntArrayList intArrayList2, LongArrayList longArrayList) {
        intArrayList.clear();
        intArrayList2.clear();
        longArrayList.clear();
        int n = (int)this.index(0, 0);
        for (int i = 0; i < this.columns; ++i) {
            int n2 = n;
            for (int j = 0; j < this.rows; ++j) {
                long l = this.elements[n2];
                if (l > 0L) {
                    intArrayList.add(j);
                    intArrayList2.add(i);
                    longArrayList.add(l);
                }
                n2 += this.rowStride;
            }
            n += this.columnStride;
        }
    }

    public long getQuick(int n, int n2) {
        return this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride];
    }

    public long index(int n, int n2) {
        return this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride;
    }

    public LongMatrix2D like(int n, int n2) {
        return new DenseColumnLongMatrix2D(n, n2);
    }

    public LongMatrix1D like1D(int n) {
        return new DenseLongMatrix1D(n);
    }

    public long[] getMaxLocation() {
        int n = 0;
        int n2 = 0;
        final int n3 = (int)this.index(0, 0);
        long l = 0L;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n5;
            n4 = Math.min(n4, this.columns);
            Future[] futureArray = new Future[n4];
            long[][] lArray = new long[n4][3];
            int n6 = this.columns / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = this.columns - n5 * n6;
                final int n8 = n5 == n4 - 1 ? 0 : n7 - n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        long l = DenseColumnLongMatrix2D.this.elements[n3 + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (n7 - 1) * DenseColumnLongMatrix2D.this.columnStride];
                        int n = DenseColumnLongMatrix2D.this.rows - 1;
                        int n2 = n7 - 1;
                        int n32 = 1;
                        int n4 = n7;
                        while (--n4 >= n8) {
                            int n5 = n3 + n4 * DenseColumnLongMatrix2D.this.columnStride;
                            int n6 = DenseColumnLongMatrix2D.this.rows - n32;
                            while (--n6 >= 0) {
                                long l2 = DenseColumnLongMatrix2D.this.elements[n6 * DenseColumnLongMatrix2D.this.rowStride + n5];
                                if (l >= l2) continue;
                                l = l2;
                                n = n6;
                                n2 = n4;
                            }
                            n32 = 0;
                        }
                        return new long[]{l, n, n2};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    lArray[n5] = (long[])futureArray[n5].get();
                }
                l = lArray[0][0];
                n = (int)lArray[0][1];
                n2 = (int)lArray[0][2];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (l >= lArray[n5][0]) continue;
                    l = lArray[n5][0];
                    n = (int)lArray[n5][1];
                    n2 = (int)lArray[n5][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            l = this.elements[n3 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            n = this.rows - 1;
            n2 = this.columns - 1;
            int n9 = 1;
            int n10 = this.columns;
            while (--n10 >= 0) {
                int n11 = n3 + n10 * this.columnStride;
                int n12 = this.rows - n9;
                while (--n12 >= 0) {
                    long l2 = this.elements[n12 * this.rowStride + n11];
                    if (l >= l2) continue;
                    l = l2;
                    n = n12;
                    n2 = n10;
                }
                n9 = 0;
            }
        }
        return new long[]{l, n, n2};
    }

    public long[] getMinLocation() {
        int n = 0;
        int n2 = 0;
        final int n3 = (int)this.index(0, 0);
        long l = 0L;
        int n4 = ConcurrencyUtils.getNumberOfThreads();
        if (n4 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n5;
            n4 = Math.min(n4, this.columns);
            Future[] futureArray = new Future[n4];
            long[][] lArray = new long[n4][3];
            int n6 = this.columns / n4;
            for (n5 = 0; n5 < n4; ++n5) {
                final int n7 = this.columns - n5 * n6;
                final int n8 = n5 == n4 - 1 ? 0 : n7 - n6;
                futureArray[n5] = ConcurrencyUtils.submit(new Callable<long[]>(){

                    @Override
                    public long[] call() throws Exception {
                        long l = DenseColumnLongMatrix2D.this.elements[n3 + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (n7 - 1) * DenseColumnLongMatrix2D.this.columnStride];
                        int n = DenseColumnLongMatrix2D.this.rows - 1;
                        int n2 = n7 - 1;
                        int n32 = 1;
                        int n4 = n7;
                        while (--n4 >= n8) {
                            int n5 = n3 + n4 * DenseColumnLongMatrix2D.this.columnStride;
                            int n6 = DenseColumnLongMatrix2D.this.rows - n32;
                            while (--n6 >= 0) {
                                long l2 = DenseColumnLongMatrix2D.this.elements[n6 * DenseColumnLongMatrix2D.this.rowStride + n5];
                                if (l <= l2) continue;
                                l = l2;
                                n = n6;
                                n2 = n4;
                            }
                            n32 = 0;
                        }
                        return new long[]{l, n, n2};
                    }
                });
            }
            try {
                for (n5 = 0; n5 < n4; ++n5) {
                    lArray[n5] = (long[])futureArray[n5].get();
                }
                l = lArray[0][0];
                n = (int)lArray[0][1];
                n2 = (int)lArray[0][2];
                for (n5 = 1; n5 < n4; ++n5) {
                    if (l <= lArray[n5][0]) continue;
                    l = lArray[n5][0];
                    n = (int)lArray[n5][1];
                    n2 = (int)lArray[n5][2];
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            l = this.elements[n3 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride];
            n = this.rows - 1;
            n2 = this.columns - 1;
            int n9 = 1;
            int n10 = this.columns;
            while (--n10 >= 0) {
                int n11 = n3 + n10 * this.columnStride;
                int n12 = this.rows - n9;
                while (--n12 >= 0) {
                    long l2 = this.elements[n12 * this.rowStride + n11];
                    if (l <= l2) continue;
                    l = l2;
                    n = n12;
                    n2 = n10;
                }
                n9 = 0;
            }
        }
        return new long[]{l, n, n2};
    }

    public void setQuick(int n, int n2, long l) {
        this.elements[this.rowZero + n * this.rowStride + this.columnZero + n2 * this.columnStride] = l;
    }

    public long[][] toArray() {
        final long[][] lArray = new long[this.rows][this.columns];
        int n = ConcurrencyUtils.getNumberOfThreads();
        final int n2 = (int)this.index(0, 0);
        if (n > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            n = Math.min(n, this.columns);
            Future[] futureArray = new Future[n];
            int n3 = this.columns / n;
            for (int i = 0; i < n; ++i) {
                final int n4 = this.columns - i * n3;
                final int n5 = i == n - 1 ? 0 : n4 - n3;
                futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                    public void run() {
                        int n = n2 + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (n4 - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        int n22 = n4;
                        while (--n22 >= n5) {
                            int n3 = n;
                            int n42 = DenseColumnLongMatrix2D.this.rows;
                            while (--n42 >= 0) {
                                lArray[n42][n22] = DenseColumnLongMatrix2D.this.elements[n3];
                                n3 -= DenseColumnLongMatrix2D.this.rowStride;
                            }
                            n -= DenseColumnLongMatrix2D.this.columnStride;
                        }
                    }
                });
            }
            ConcurrencyUtils.waitForCompletion(futureArray);
        } else {
            int n6 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n7 = this.columns;
            while (--n7 >= 0) {
                int n8 = n6;
                int n9 = this.rows;
                while (--n9 >= 0) {
                    lArray[n9][n7] = this.elements[n8];
                    n8 -= this.rowStride;
                }
                n6 -= this.columnStride;
            }
        }
        return lArray;
    }

    public LongMatrix1D vectorize() {
        int n = (int)this.size();
        DenseLongMatrix1D denseLongMatrix1D = new DenseLongMatrix1D(n);
        if (this.isNoView) {
            System.arraycopy(this.elements, 0, ((LongMatrix1D)denseLongMatrix1D).elements(), 0, n);
        } else {
            final int n2 = (int)this.index(0, 0);
            final int n3 = (int)((AbstractMatrix1D)denseLongMatrix1D).index(0);
            final int n4 = denseLongMatrix1D.stride();
            final long[] lArray = (long[])((LongMatrix1D)denseLongMatrix1D).elements();
            int n5 = ConcurrencyUtils.getNumberOfThreads();
            if (n5 > 1 && n >= ConcurrencyUtils.getThreadsBeginN_2D()) {
                n5 = Math.min(n5, this.columns);
                Future[] futureArray = new Future[n5];
                int n6 = this.columns / n5;
                for (int i = 0; i < n5; ++i) {
                    final int n7 = this.columns - i * n6;
                    final int n8 = i == n5 - 1 ? 0 : n7 - n6;
                    final int n9 = n - i * n6 * this.rows;
                    futureArray[i] = ConcurrencyUtils.submit(new Runnable(){

                        public void run() {
                            int n = n2 + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (n7 - 1) * DenseColumnLongMatrix2D.this.columnStride;
                            int n22 = n3 + (n9 - 1) * n4;
                            int n32 = n7;
                            while (--n32 >= n8) {
                                int n42 = n;
                                int n5 = DenseColumnLongMatrix2D.this.rows;
                                while (--n5 >= 0) {
                                    lArray[n22] = DenseColumnLongMatrix2D.this.elements[n42];
                                    n42 -= DenseColumnLongMatrix2D.this.rowStride;
                                    n22 -= n4;
                                }
                                n -= DenseColumnLongMatrix2D.this.columnStride;
                            }
                        }
                    });
                }
                ConcurrencyUtils.waitForCompletion(futureArray);
            } else {
                int n10 = n2 + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
                int n11 = n3 + n - 1;
                int n12 = this.columns;
                while (--n12 >= 0) {
                    int n13 = n10;
                    int n14 = this.rows;
                    while (--n14 >= 0) {
                        lArray[n11] = this.elements[n13];
                        n13 -= this.rowStride;
                        --n11;
                    }
                    n10 -= this.columnStride;
                }
            }
        }
        return denseLongMatrix1D;
    }

    public long zSum() {
        long l = 0L;
        if (this.elements == null) {
            throw new InternalError();
        }
        final int n = (int)this.index(0, 0);
        int n2 = ConcurrencyUtils.getNumberOfThreads();
        if (n2 > 1 && this.size() >= (long)ConcurrencyUtils.getThreadsBeginN_2D()) {
            int n3;
            n2 = Math.min(n2, this.columns);
            Future[] futureArray = new Future[n2];
            int n4 = this.columns / n2;
            for (n3 = 0; n3 < n2; ++n3) {
                final int n5 = this.columns - n3 * n4;
                final int n6 = n3 == n2 - 1 ? 0 : n5 - n4;
                futureArray[n3] = ConcurrencyUtils.submit(new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        long l = 0L;
                        int n7 = n + (DenseColumnLongMatrix2D.this.rows - 1) * DenseColumnLongMatrix2D.this.rowStride + (n5 - 1) * DenseColumnLongMatrix2D.this.columnStride;
                        int n2 = n5;
                        while (--n2 >= n6) {
                            int n3 = n7;
                            int n4 = DenseColumnLongMatrix2D.this.rows;
                            while (--n4 >= 0) {
                                l += DenseColumnLongMatrix2D.this.elements[n3];
                                n3 -= DenseColumnLongMatrix2D.this.rowStride;
                            }
                            n7 -= DenseColumnLongMatrix2D.this.columnStride;
                        }
                        return l;
                    }
                });
            }
            try {
                for (n3 = 0; n3 < n2; ++n3) {
                    l += ((Long)futureArray[n3].get()).longValue();
                }
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } else {
            int n7 = n + (this.rows - 1) * this.rowStride + (this.columns - 1) * this.columnStride;
            int n8 = this.columns;
            while (--n8 >= 0) {
                int n9 = n7;
                int n10 = this.rows;
                while (--n10 >= 0) {
                    l += this.elements[n9];
                    n9 -= this.rowStride;
                }
                n7 -= this.columnStride;
            }
        }
        return l;
    }

    protected boolean haveSharedCellsRaw(LongMatrix2D longMatrix2D) {
        if (longMatrix2D instanceof SelectedDenseColumnLongMatrix2D) {
            SelectedDenseColumnLongMatrix2D selectedDenseColumnLongMatrix2D = (SelectedDenseColumnLongMatrix2D)longMatrix2D;
            return this.elements == selectedDenseColumnLongMatrix2D.elements;
        }
        if (longMatrix2D instanceof DenseColumnLongMatrix2D) {
            DenseColumnLongMatrix2D denseColumnLongMatrix2D = (DenseColumnLongMatrix2D)longMatrix2D;
            return this.elements == denseColumnLongMatrix2D.elements;
        }
        return false;
    }

    protected LongMatrix1D like1D(int n, int n2, int n3) {
        return new DenseLongMatrix1D(n, this.elements, n2, n3, true);
    }

    protected LongMatrix2D viewSelectionLike(int[] nArray, int[] nArray2) {
        return new SelectedDenseColumnLongMatrix2D(this.elements, nArray, nArray2, 0);
    }
}

