/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Parameter;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;

public class BitSwapOperator
extends SimpleMCMCOperator {
    private final Parameter data;
    private final Parameter indicators;
    private final boolean impliedOne;
    private final int radius;

    public BitSwapOperator(Parameter parameter, Parameter parameter2, int n, double d) {
        this.data = parameter;
        this.indicators = parameter2;
        this.radius = n;
        this.setWeight(d);
        int n2 = parameter2.getDimension();
        int n3 = parameter.getDimension();
        if (n2 == n3 - 1) {
            this.impliedOne = true;
        } else if (n2 == n3) {
            this.impliedOne = false;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public String getPerformanceSuggestion() {
        return "";
    }

    @Override
    public String getOperatorName() {
        return "bitSwap(" + this.data.getParameterName() + ")";
    }

    @Override
    public double doOperation() {
        int n;
        int n2;
        int n3;
        double d;
        int n4 = this.indicators.getDimension();
        if (n4 < 2) {
            throw new RuntimeException("no swaps possible");
        }
        int n5 = 0;
        int[] nArray = new int[2 * n4];
        int n6 = 0;
        if (this.radius > 0) {
            int n7;
            for (n7 = 0; n7 < n4; ++n7) {
                double d2 = this.indicators.getStatisticValue(n7);
                if (!(d2 > 0.0)) continue;
                ++n6;
                nArray[n5] = n7;
                ++n5;
            }
            if (n6 == 0 || n6 == n4) {
                throw new RuntimeException("no swaps possible");
            }
            d = 0.0;
            n7 = MathUtils.nextInt(n5);
            n3 = nArray[n7];
            for (int i = (n2 -= this.radius - ((n2 = MathUtils.nextInt(2 * this.radius)) < this.radius ? 0 : 1)) > 0 ? n3 + 1 : n3 + n2; i < (n2 > 0 ? n3 + n2 + 1 : n3); ++i) {
                if (i >= 0 && i < n4 && !(this.indicators.getStatisticValue(i) > 0.0)) continue;
                throw new RuntimeException("swap faild");
            }
        } else {
            int n8;
            double d3 = -1.0;
            for (n8 = 0; n8 < n4; ++n8) {
                double d4 = this.indicators.getStatisticValue(n8);
                if (d4 > 0.0) {
                    ++n6;
                    if (n8 > 0 && d3 == 0.0) {
                        nArray[n5] = -(n8 + 1);
                        ++n5;
                    }
                    if (n8 < n4 - 1 && this.indicators.getStatisticValue(n8 + 1) == 0.0) {
                        nArray[n5] = n8 + 1;
                        ++n5;
                    }
                }
                d3 = d4;
            }
            if (n6 == 0 || n6 == n4) {
                return 0.0;
            }
            if (n5 <= 0) assert (false) : this.indicators;
            n8 = MathUtils.nextInt(n5);
            n3 = nArray[n8];
            n2 = n3 < 0 ? -1 : 1;
            n3 = (n3 < 0 ? -n3 : n3) - 1;
            n = 2 * n6;
            d = n == n5 ? 0.0 : Math.log((double)n5 / (double)n);
        }
        int n9 = n3 + n2;
        double d5 = this.indicators.getStatisticValue(n9);
        this.indicators.setParameterValue(n9, this.indicators.getParameterValue(n3));
        this.indicators.setParameterValue(n3, d5);
        n = this.impliedOne ? 1 : 0;
        int n10 = n9 + n;
        int n11 = n3 + n;
        d5 = this.data.getStatisticValue(n10);
        this.data.setParameterValue(n10, this.data.getParameterValue(n11));
        this.data.setParameterValue(n11, d5);
        return d;
    }
}

