/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.evolution.datatype.DataType;
import dr.geo.math.SphericalPolarCoordinates;
import dr.inference.model.DesignMatrix;
import dr.inference.model.Parameter;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;
import java.util.List;

public class OriginDestinationDesignMatrix
extends DesignMatrix {
    public static final String DESIGN_MATRIX = "originDestinationDesignMatrix";
    public static final String LAT_TRAIT = "latitudeTrait";
    public static final String LONG_TRAIT = "longitudeTrait";
    public static final String DYNAMIC_STANDARDIZATION = "dynamicStandardization";
    private final DesignMatrix baseMatrix;
    final DataType dataType;
    final int[] originIndex;
    final int[] destinationIndex;
    private final List<Covariate> covariates = new ArrayList<Covariate>();
    final int rowDimension;
    public static XMLObjectParser PARSER = new AbstractXMLObjectParser(){
        private final XMLSyntaxRule[] rules = new XMLSyntaxRule[]{new ElementRule(DesignMatrix.class), new ElementRule(DataType.class), AttributeRule.newStringRule("latitudeTrait", true), AttributeRule.newStringRule("longitudeTrait", true)};

        private Parameter getMatchingParameter(DesignMatrix designMatrix, String string) {
            for (int i = 0; i < designMatrix.getUniqueParameterCount(); ++i) {
                Parameter parameter = designMatrix.getUniqueParameter(i);
                if (parameter.getId().compareTo(string) != 0) continue;
                return parameter;
            }
            return null;
        }

        @Override
        public String getParserName() {
            return OriginDestinationDesignMatrix.DESIGN_MATRIX;
        }

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Object object;
            boolean bl = xMLObject.getAttribute(OriginDestinationDesignMatrix.DYNAMIC_STANDARDIZATION, false);
            String string = xMLObject.hasId() ? xMLObject.getId() : OriginDestinationDesignMatrix.DESIGN_MATRIX;
            DataType dataType = (DataType)xMLObject.getChild(DataType.class);
            DesignMatrix designMatrix = (DesignMatrix)xMLObject.getChild(DesignMatrix.class);
            Parameter parameter = null;
            Parameter parameter2 = null;
            if (xMLObject.hasAttribute(OriginDestinationDesignMatrix.LAT_TRAIT)) {
                if (xMLObject.hasAttribute(OriginDestinationDesignMatrix.LONG_TRAIT)) {
                    object = xMLObject.getStringAttribute(OriginDestinationDesignMatrix.LAT_TRAIT);
                    String string2 = xMLObject.getStringAttribute(OriginDestinationDesignMatrix.LONG_TRAIT);
                    parameter = this.getMatchingParameter(designMatrix, (String)object);
                    parameter2 = this.getMatchingParameter(designMatrix, string2);
                    if (parameter == null) {
                        throw new XMLParseException("Unable to find trait named `" + (String)object + "`");
                    }
                    if (parameter2 == null) {
                        throw new XMLParseException("Unable to find trait named `" + string2 + "`");
                    }
                } else {
                    throw new XMLParseException("Must provide both latitude and longitude trait names");
                }
            }
            object = new OriginDestinationDesignMatrix(string, designMatrix, dataType, bl, parameter, parameter2);
            return object;
        }

        @Override
        public String getParserDescription() {
            return "A matrix parameter constructed from its component parameters.";
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return this.rules;
        }

        @Override
        public Class getReturnType() {
            return OriginDestinationDesignMatrix.class;
        }
    };

    public OriginDestinationDesignMatrix(String string, DesignMatrix designMatrix, DataType dataType, boolean bl, Parameter parameter, Parameter parameter2) {
        super(string, bl);
        int n;
        int n2;
        int n3;
        this.dataType = dataType;
        this.baseMatrix = designMatrix;
        System.err.println("Iterating over " + designMatrix.getParameters().size() + " parameters");
        System.err.println("unique count: " + designMatrix.getUniqueParameterCount());
        for (n3 = 0; n3 < designMatrix.getUniqueParameterCount(); ++n3) {
            Parameter parameter3 = designMatrix.getUniqueParameter(n3);
            super.addParameter(parameter3);
            if (parameter3 == parameter || parameter3 == parameter2) continue;
            this.covariates.add(new Origin(parameter3));
            this.covariates.add(new Destination(parameter3));
        }
        if (parameter != null && parameter2 != null) {
            this.covariates.add(new Distance(parameter, parameter2));
        }
        this.rowDimension = dataType.getStateCount() * (dataType.getStateCount() - 1);
        this.originIndex = new int[this.rowDimension];
        this.destinationIndex = new int[this.rowDimension];
        n3 = 0;
        for (n2 = 0; n2 < dataType.getStateCount(); ++n2) {
            n = n2 + 1;
            while (n < dataType.getStateCount()) {
                this.originIndex[n3] = n2;
                this.destinationIndex[n3] = n++;
                ++n3;
            }
        }
        for (n2 = 0; n2 < dataType.getStateCount(); ++n2) {
            n = n2 + 1;
            while (n < dataType.getStateCount()) {
                this.originIndex[n3] = n++;
                this.destinationIndex[n3] = n2;
                ++n3;
            }
        }
        System.err.println("#row = " + designMatrix.getRowDimension());
        System.err.println("#col = " + designMatrix.getColumnDimension());
        System.err.println("#row = " + this.getRowDimension());
        System.err.println("#col = " + this.getColumnDimension());
        System.exit(-1);
    }

    @Override
    public int getColumnDimension() {
        return this.covariates.size();
    }

    @Override
    public int getRowDimension() {
        return this.rowDimension;
    }

    @Override
    public void addParameter(Parameter parameter) {
        throw new RuntimeException("Should not be called");
    }

    @Override
    public void removeParameter(Parameter parameter) {
        throw new RuntimeException("Should not be called");
    }

    @Override
    protected double getRawParameterValue(int n, int n2) {
        double d = this.covariates.get(n2).getValue(n);
        return d;
    }

    class Origin
    extends Covariate {
        protected Origin(Parameter parameter) {
            super(parameter);
        }

        @Override
        double getValue(int n) {
            return this.parameter.getParameterValue(OriginDestinationDesignMatrix.this.originIndex[n]);
        }
    }

    class Destination
    extends Covariate {
        protected Destination(Parameter parameter) {
            super(parameter);
        }

        @Override
        double getValue(int n) {
            return this.parameter.getParameterValue(OriginDestinationDesignMatrix.this.destinationIndex[n]);
        }
    }

    class Distance
    extends Covariate {
        private final Parameter latParameter;
        private final Parameter longParameter;

        protected Distance(Parameter parameter, Parameter parameter2) {
            super(parameter);
            this.latParameter = parameter;
            this.longParameter = parameter2;
        }

        @Override
        double getValue(int n) {
            double d = this.latParameter.getParameterValue(OriginDestinationDesignMatrix.this.originIndex[n]);
            double d2 = this.longParameter.getParameterValue(OriginDestinationDesignMatrix.this.originIndex[n]);
            double d3 = this.latParameter.getParameterValue(OriginDestinationDesignMatrix.this.destinationIndex[n]);
            double d4 = this.longParameter.getParameterValue(OriginDestinationDesignMatrix.this.destinationIndex[n]);
            SphericalPolarCoordinates sphericalPolarCoordinates = new SphericalPolarCoordinates(d, d2);
            SphericalPolarCoordinates sphericalPolarCoordinates2 = new SphericalPolarCoordinates(d3, d4);
            return sphericalPolarCoordinates.distance(sphericalPolarCoordinates2);
        }
    }

    abstract class Covariate {
        protected final Parameter parameter;

        protected Covariate(Parameter parameter) {
            this.parameter = parameter;
        }

        abstract double getValue(int var1);
    }
}

