/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.MatrixParameterInterface;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.matrixAlgebra.CholeskyDecomposition;
import dr.math.matrixAlgebra.IllegalDimension;
import java.util.Vector;

public class DeterminentalPointProcessPrior
extends AbstractModelLikelihood {
    double theta;
    MatrixParameterInterface data;
    boolean likelihoodKnown = false;
    boolean storedLikelihoodKnown;
    double logLikelihood;
    double storedLogLikelihood;
    double[][] relationshipList;
    double[][] storedRelationshipList;
    boolean[] notZero;
    boolean[] storedNotZero;
    int size;
    int storedSize;
    Vector<Integer> changedList;
    Vector<Integer> storedChangedList;
    Parameter normalizingConstants;
    boolean pathSampling;
    int sum;
    int storedSum;

    public DeterminentalPointProcessPrior(String string, double d, MatrixParameterInterface matrixParameterInterface, Parameter parameter, boolean bl, boolean bl2, boolean bl3) {
        super(string);
        this.normalizingConstants = parameter;
        this.theta = d;
        this.data = matrixParameterInterface;
        this.addVariable(matrixParameterInterface);
        this.relationshipList = new double[matrixParameterInterface.getColumnDimension()][matrixParameterInterface.getColumnDimension()];
        this.storedRelationshipList = new double[matrixParameterInterface.getColumnDimension()][matrixParameterInterface.getColumnDimension()];
        this.size = matrixParameterInterface.getColumnDimension();
        if (bl3) {
            for (int i = 0; i < matrixParameterInterface.getRowDimension(); ++i) {
                for (int j = 0; j < matrixParameterInterface.getColumnDimension(); ++j) {
                    if (i % (j + 1) != 0) continue;
                    matrixParameterInterface.setParameterValueQuietly(i, j, 0.0);
                }
            }
        }
        if (bl) {
            this.notZero = new boolean[matrixParameterInterface.getColumnDimension()];
            this.storedNotZero = new boolean[matrixParameterInterface.getColumnDimension()];
        }
        this.reset();
        this.pathSampling = bl2;
        this.changedList = new Vector();
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
    }

    @Override
    protected void storeState() {
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
        this.storedSize = this.size;
        this.storedChangedList = (Vector)this.changedList.clone();
        this.storedSum = this.sum;
    }

    @Override
    protected void restoreState() {
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
        double[][] dArray = this.relationshipList;
        this.relationshipList = this.storedRelationshipList;
        this.storedRelationshipList = dArray;
        this.size = this.storedSize;
        Vector<Integer> vector = this.changedList;
        this.changedList = this.storedChangedList;
        this.storedChangedList = vector;
        this.sum = this.storedSum;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.likelihoodKnown = false;
        if (n == -1) {
            this.reset();
        }
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        this.makeDirty();
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.computeLogLikelihood();
            if (this.normalizingConstants != null) {
                this.logLikelihood = this.sum != 0 ? (this.logLikelihood += this.normalizingConstants.getParameterValue(this.sum - 1)) : (this.logLikelihood += this.normalizingConstants.getParameterValue(0));
            }
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    public double computeLogLikelihood() {
        if (this.pathSampling && this.notZero != null && this.sum != this.data.getColumnDimension()) {
            return Double.NEGATIVE_INFINITY;
        }
        CholeskyDecomposition choleskyDecomposition = null;
        try {
            choleskyDecomposition = new CholeskyDecomposition(this.relationshipList);
        }
        catch (IllegalDimension illegalDimension) {
            illegalDimension.printStackTrace();
        }
        double d = 0.0;
        for (int i = 0; i < this.relationshipList.length; ++i) {
            d += Math.log(choleskyDecomposition.getL()[i][i]);
        }
        return d *= 2.0;
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
        this.changedList = new Vector();
        this.reset();
    }

    private void findZeros() {
        this.sum = 0;
        this.notZero = new boolean[this.data.getColumnDimension()];
        block0: for (int i = 0; i < this.data.getColumnDimension(); ++i) {
            for (int j = 0; j < this.data.getRowDimension(); ++j) {
                if (this.data.getParameterValue(j, i) != 1.0) continue;
                this.notZero[i] = true;
                ++this.sum;
                continue block0;
            }
        }
    }

    public int getSum() {
        this.findZeros();
        return this.sum;
    }

    public void reset() {
        int n;
        if (this.notZero != null) {
            this.findZeros();
            if (this.relationshipList.length != this.sum && this.sum != 0) {
                this.relationshipList = new double[this.sum][this.sum];
            } else if (this.sum == 0) {
                this.relationshipList = new double[1][1];
            }
        } else if (this.relationshipList.length != this.data.getColumnDimension() || this.relationshipList == null) {
            this.relationshipList = new double[this.data.getColumnDimension()][this.data.getColumnDimension()];
        }
        int n2 = 0;
        for (n = 0; n < this.relationshipList.length; ++n) {
            int n3 = 0;
            if (this.notZero != null && this.notZero[n] || this.notZero == null) {
                for (int i = 0; i < n; ++i) {
                    if (this.notZero != null && this.notZero[i] || this.notZero == null) {
                        int n4 = 0;
                        for (int j = 0; j < this.data.getRowDimension(); ++j) {
                            n4 = (int)((double)n4 + Math.abs(this.data.getParameterValue(j, n) - this.data.getParameterValue(j, i)));
                        }
                        this.relationshipList[n + n2][i + n3] = Math.exp((double)(-n4) / (this.theta * this.theta));
                        this.relationshipList[i + n3][n + n2] = this.relationshipList[n + n2][i + n3];
                        continue;
                    }
                    --n3;
                }
                continue;
            }
            --n2;
        }
        for (n = 0; n < this.relationshipList.length; ++n) {
            this.relationshipList[n][n] = 1.0;
        }
    }
}

