/*
 * Decompiled with CFR 0.152.
 */
package jdplus.x13.base.core.x11;

import java.util.Arrays;
import jdplus.sa.base.api.DecompositionMode;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoublesMath;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.linearfilters.FiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.IFiniteFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.x13.base.api.x11.BiasCorrection;
import jdplus.x13.base.api.x11.X11Exception;
import jdplus.x13.base.api.x11.X11Spec;
import jdplus.x13.base.core.x11.X11BStep;
import jdplus.x13.base.core.x11.X11CStep;
import jdplus.x13.base.core.x11.X11Context;
import jdplus.x13.base.core.x11.X11DStep;
import jdplus.x13.base.core.x11.X11Results;
import jdplus.x13.base.core.x11.filter.MusgraveFilterFactory;
import jdplus.x13.base.core.x11.filter.X11TrendCycleFilterFactory;
import jdplus.x13.base.core.x11.filter.endpoints.AsymmetricEndPoints;
import jdplus.x13.base.core.x11.filter.endpoints.CopyEndPoints;
import jdplus.x13.base.core.x11.pseudoadd.X11BStepPseudoAdd;
import jdplus.x13.base.core.x11.pseudoadd.X11CStepPseudoAdd;
import jdplus.x13.base.core.x11.pseudoadd.X11DStepPseudoAdd;
import lombok.Generated;
import lombok.NonNull;

public class X11Kernel {
    private X11BStep bstep;
    private X11CStep cstep;
    private X11DStep dstep;
    private TsData input;
    private X11Context context;

    public static double[] table(int n, double value) {
        double[] x = new double[n];
        Arrays.fill(x, value);
        return x;
    }

    public X11Results process(@NonNull TsData timeSeries, @NonNull X11Spec spec) {
        if (timeSeries == null) {
            throw new NullPointerException("timeSeries is marked non-null but is null");
        }
        if (spec == null) {
            throw new NullPointerException("spec is marked non-null but is null");
        }
        this.clear();
        this.check(timeSeries, spec);
        this.input = timeSeries;
        DoubleSeq data = this.input.getValues();
        this.context = X11Context.of(spec, this.input);
        if (this.context.isPseudoAdd()) {
            this.bstep = new X11BStepPseudoAdd();
            this.bstep.process(data, this.context);
            this.cstep = new X11CStepPseudoAdd(this.bstep.getB7(), this.bstep.getB13());
            this.cstep.process(data, this.bstep.getB20(), this.context);
            this.dstep = new X11DStepPseudoAdd(this.cstep.getC7(), this.cstep.getC13(), this.cstep.getC20());
            this.dstep.process(data, this.cstep.getC20(), this.context);
        } else {
            if (this.context.isLogAdd()) {
                data = data.log();
            }
            this.bstep = new X11BStep();
            this.bstep.process(data, this.context);
            this.cstep = new X11CStep();
            this.cstep.process(data, this.bstep.getB20(), this.context);
            this.dstep = new X11DStep();
            this.dstep.process(data, this.cstep.getC20(), this.context);
        }
        return this.buildResults(timeSeries.getStart(), spec);
    }

    private void check(TsData timeSeries, X11Spec spec) throws X11Exception, IllegalArgumentException {
        int frequency = timeSeries.getAnnualFrequency();
        if (frequency == -1) {
            throw new IllegalArgumentException("Frequency of the time series must be compatible with years");
        }
        if (timeSeries.getValues().length() < 3 * frequency) {
            throw new X11Exception("Not enough observations");
        }
        if (!timeSeries.getValues().allMatch(Double::isFinite)) {
            throw new X11Exception("Missing values are not allowed");
        }
        if ((spec.getMode() == DecompositionMode.Multiplicative || spec.getMode() == DecompositionMode.LogAdditive) && timeSeries.getValues().anyMatch(x -> x <= 0.0)) {
            throw new X11Exception("Multiplicative decomposition of non positive series");
        }
    }

    private void clear() {
        this.bstep = null;
        this.cstep = null;
        this.dstep = null;
        this.input = null;
        this.context = null;
    }

    private X11Results buildResults(TsPeriod start, X11Spec spec) {
        int nb = spec.getBackcastHorizon() >= 0 ? spec.getBackcastHorizon() : -spec.getBackcastHorizon() * start.annualFrequency();
        int nf = spec.getForecastHorizon() >= 0 ? spec.getForecastHorizon() : -spec.getForecastHorizon() * start.annualFrequency();
        X11Results.Builder builder = X11Results.builder().nbackcasts(nb).nforecasts(nf).b1(this.input).b2(TsData.of((TsPeriod)start.plus((long)this.bstep.getB2drop()), (DoubleSeq)this.prepare(this.bstep.getB2()))).b3(TsData.of((TsPeriod)start.plus((long)this.bstep.getB2drop()), (DoubleSeq)this.prepare(this.bstep.getB3()))).b4(TsData.of((TsPeriod)start.plus((long)this.bstep.getB2drop()), (DoubleSeq)this.prepare(this.bstep.getB4()))).b5(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.bstep.getB5()))).b6(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.bstep.getB6()))).b7(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.bstep.getB7()))).b8(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.bstep.getB8()))).b9(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.bstep.getB9()))).b10(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.bstep.getB10()))).b11(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.bstep.getB11()))).b13(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.bstep.getB13()))).b17(TsData.of((TsPeriod)start, (DoubleSeq)this.bstep.getB17())).b20(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.bstep.getB20()))).c1(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.cstep.getC1()))).c2(TsData.of((TsPeriod)start.plus((long)this.cstep.getC2drop()), (DoubleSeq)this.prepare(this.cstep.getC2()))).c4(TsData.of((TsPeriod)start.plus((long)this.cstep.getC2drop()), (DoubleSeq)this.prepare(this.cstep.getC4()))).c5(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.cstep.getC5()))).c6(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.cstep.getC6()))).c7(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.cstep.getC7()))).c9(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.cstep.getC9()))).c10(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.cstep.getC10()))).c11(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.cstep.getC11()))).c13(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.cstep.getC13()))).c17(TsData.of((TsPeriod)start, (DoubleSeq)this.cstep.getC17())).c20(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.cstep.getC20()))).d1(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.dstep.getD1()))).d2(TsData.of((TsPeriod)start.plus((long)this.dstep.getD2drop()), (DoubleSeq)this.prepare(this.dstep.getD2()))).d4(TsData.of((TsPeriod)start.plus((long)this.dstep.getD2drop()), (DoubleSeq)this.prepare(this.dstep.getD4()))).d5(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.dstep.getD5()))).d6(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.dstep.getD6()))).d7(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.dstep.getD7()))).d8(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.dstep.getD8()))).d9(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.dstep.getD9()))).d9Msr(this.dstep.getD9msr()).d9default(this.dstep.isD9default()).d9filter(this.dstep.getD9filter()).iCRatio(this.dstep.getICRatio()).finalHendersonFilterLength(this.dstep.getFinalHendersonFilterLength()).finalSeasonalFilter(this.dstep.getSeasFilter()).mode(spec.getMode());
        return this.finalResults(builder, start, spec).build();
    }

    private X11Results.Builder finalResults(X11Results.Builder builder, TsPeriod start, X11Spec spec) {
        if (spec.getMode() != DecompositionMode.LogAdditive || !spec.isSeasonal() || spec.getBias() == BiasCorrection.None) {
            builder.d10(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.dstep.getD10()))).d11(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.dstep.getD11()))).d12(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.dstep.getD12()))).d13(TsData.of((TsPeriod)start, (DoubleSeq)this.prepare(this.dstep.getD13())));
        } else {
            this.biasCorrection(builder, start);
        }
        return builder;
    }

    private DoubleSeq prepare(DoubleSeq in) {
        return this.context.isLogAdd() ? in.exp() : in;
    }

    private void biasCorrection(X11Results.Builder builder, TsPeriod start) {
        switch (this.context.getBias()) {
            case Legacy: {
                this.legacyBiasCorrection(builder, start);
                break;
            }
            case Smooth: {
                this.smoothBiasCorrection(builder, start);
                break;
            }
            case Ratio: {
                this.ratioBiasCorrection(builder, start);
            }
        }
    }

    private void fill(X11Results.Builder builder, TsPeriod start, DoubleSeq d10, DoubleSeq d12) {
        d12 = X11Context.makePositivity(d12);
        DoubleSeq d11 = DoublesMath.divide((DoubleSeq)this.input.getValues(), (DoubleSeq)d10);
        DoubleSeq d13 = DoublesMath.divide((DoubleSeq)d11, (DoubleSeq)d12);
        builder.d10(TsData.of((TsPeriod)start, (DoubleSeq)d10)).d11(TsData.of((TsPeriod)start, (DoubleSeq)d11)).d12(TsData.of((TsPeriod)start, (DoubleSeq)d12)).d13(TsData.of((TsPeriod)start, (DoubleSeq)d13));
    }

    private void smoothBiasCorrection(X11Results.Builder builder, TsPeriod start) {
        DoubleSeq d13 = this.dstep.getD13();
        DoubleSeq d10 = this.dstep.getD10();
        DoubleSeq d12 = this.dstep.getD12();
        double issq = d13.ssq();
        double sig = Math.exp(issq / (double)(2 * d13.length()));
        int ifreq = this.context.getPeriod();
        SymmetricFilter filter = X11TrendCycleFilterFactory.makeTrendFilter(ifreq);
        int ndrop = filter.length() / 2;
        double[] x = new double[d10.length()];
        DataBlock out = DataBlock.of((double[])x, (int)ndrop, (int)(x.length - ndrop));
        d10 = d10.exp();
        filter.apply(d10, (DoubleSeq.Mutable)out);
        CopyEndPoints cp = new CopyEndPoints(ndrop);
        DataBlock X = DataBlock.of((double[])x);
        cp.process(d10, X);
        d12 = d12.fn((DoubleSeq)X, (a, b) -> Math.exp(a) * b * sig).commit();
        this.fill(builder, start, d10, d12);
    }

    private void ratioBiasCorrection(X11Results.Builder builder, TsPeriod start) {
        DoubleSeq d10 = this.dstep.getD10().exp();
        DoubleSeq d12 = this.dstep.getD12().exp();
        DoubleSeq d13 = this.dstep.getD13().exp();
        int ifreq = this.context.getPeriod();
        int s0 = start.annualPosition();
        int ny = (d10.length() - s0) / ifreq;
        double sbias = d10.range(s0, s0 + ny * ifreq).average();
        double ibias = d13.average();
        d10 = d10.fn(x -> x / sbias);
        double tbias = sbias * ibias;
        d12 = d12.fn(x -> x * tbias);
        this.fill(builder, start, d10, d12);
    }

    private void legacyBiasCorrection(X11Results.Builder builder, TsPeriod start) {
        DoubleSeq d13 = this.cstep.getC13();
        DoubleSeq d10 = this.dstep.getD10();
        DoubleSeq d12 = this.dstep.getD12();
        double issq = d13.ssq();
        double sig = Math.exp(issq / (double)(2 * d13.length()));
        int ifreq = this.context.getPeriod();
        int length = ifreq == 2 ? 5 : 2 * ifreq - 1;
        double[] x = X11Kernel.table(d10.length(), Double.NaN);
        int ndrop = length / 2;
        DataBlock out = DataBlock.of((double[])x, (int)ndrop, (int)(x.length - ndrop));
        d10 = d10.exp();
        SymmetricFilter smoother = this.context.trendFilter(length);
        smoother.apply(d10, (DoubleSeq.Mutable)out);
        FiniteFilter[] musgraveFilters = MusgraveFilterFactory.makeFilters((IFiniteFilter)smoother, 4.5);
        AsymmetricEndPoints aepFilter = new AsymmetricEndPoints((IFiniteFilter[])musgraveFilters, 0);
        DataBlock hs = out.extend(ndrop, ndrop);
        aepFilter.process(d10, hs);
        d12 = d12.fn((DoubleSeq)hs, (a, b) -> Math.exp(a) * b * sig).commit();
        this.fill(builder, start, d10, d12);
    }

    @Generated
    public X11BStep getBstep() {
        return this.bstep;
    }

    @Generated
    public X11CStep getCstep() {
        return this.cstep;
    }

    @Generated
    public X11DStep getDstep() {
        return this.dstep;
    }

    @Generated
    public TsData getInput() {
        return this.input;
    }

    @Generated
    public X11Context getContext() {
        return this.context;
    }
}

