/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.seats;

import jdplus.toolkit.base.api.processing.ProcessingLog;
import jdplus.toolkit.base.core.ucarima.UcarimaModel;
import jdplus.tramoseats.base.api.seats.SeatsException;
import jdplus.tramoseats.base.api.seats.SeatsModelSpec;
import jdplus.tramoseats.base.core.seats.IBiasCorrector;
import jdplus.tramoseats.base.core.seats.IComponentsEstimator;
import jdplus.tramoseats.base.core.seats.IModelApproximator;
import jdplus.tramoseats.base.core.seats.IModelDecomposer;
import jdplus.tramoseats.base.core.seats.IModelValidator;
import jdplus.tramoseats.base.core.seats.SeatsModel;
import jdplus.tramoseats.base.core.seats.SeatsResults;
import jdplus.tramoseats.base.core.seats.SeatsToolkit;
import lombok.NonNull;

public class SeatsKernel {
    public static final String SEATS = "seats";
    public static final String MODEL = "modelling";
    public static final String VALIDATION = "validation";
    public static final String DECOMPOSITION = "decomposition";
    public static final String ESTIMATION = "estimation";
    public static final String BIAS = "bias correction";
    private final SeatsToolkit toolkit;
    private final String NON_DECOMPOSABLE = "non decomposable model";
    private final String CUT_OFF = "arima parameters cut off";
    private final String APPROXIMATION = "model replaced by an approximation";
    private final String NOISY = "noisy model used";
    private final String SEATS_FAILED = "canonical decomposition failed";

    public SeatsToolkit getToolkit() {
        return this.toolkit;
    }

    public SeatsKernel(@NonNull SeatsToolkit toolkit) {
        if (toolkit == null) {
            throw new NullPointerException("toolkit is marked non-null but is null");
        }
        this.toolkit = toolkit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SeatsResults process(SeatsModelSpec modelSpec, ProcessingLog log) {
        log.push(SEATS);
        try {
            SeatsModel model = this.buildModel(modelSpec, log);
            this.validate(model, log);
            this.decomposeModel(model, log);
            this.estimateComponents(model, log);
            this.biasCorrection(model, log);
            SeatsResults seatsResults = this.results(model);
            return seatsResults;
        }
        finally {
            log.pop();
        }
    }

    private SeatsModel buildModel(SeatsModelSpec modelSpec, ProcessingLog log) {
        SeatsModel model = SeatsModel.of(modelSpec);
        model.setCurrentModel(model.getOriginalModel());
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate(SeatsModel model, ProcessingLog log) {
        log.push(VALIDATION);
        try {
            IModelValidator validator = this.toolkit.getModelValidator();
            if (!validator.validate(model.getCurrentModel())) {
                model.setCurrentModel(validator.getNewModel());
                model.setParametersCutOff(true);
                log.remark("arima parameters cut off");
            }
        }
        finally {
            log.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decomposeModel(SeatsModel model, ProcessingLog log) {
        log.push(DECOMPOSITION);
        try {
            IModelApproximator approximator = this.toolkit.getModelApproximator();
            IModelDecomposer decomposer = this.toolkit.getModelDecomposer();
            UcarimaModel ucm = null;
            int nround = 0;
            while (++nround <= 10) {
                ucm = decomposer.decompose(model.getCurrentModel());
                if (ucm == null && nround == 1) {
                    log.warning("non decomposable model");
                }
                if (ucm != null || approximator == null || !approximator.approximate(model)) break;
                model.setModelChanged(true);
                log.remark("model replaced by an approximation", (Object)model.getCurrentModel().orders());
            }
            if (ucm == null) {
                log.error("canonical decomposition failed");
                throw new SeatsException("Invalid decomposition");
            }
            if (!ucm.getModel().equals((Object)model.getCurrentModel())) {
                model.setModelChanged(true);
                log.warning("noisy model used");
            }
            model.setUcarimaModel(ucm);
        }
        finally {
            log.pop();
        }
    }

    private void estimateComponents(SeatsModel model, ProcessingLog log) {
        IComponentsEstimator componentsEstimator = this.toolkit.getComponentsEstimator();
        model.setInitialComponents(componentsEstimator.decompose(model));
    }

    private void biasCorrection(SeatsModel model, ProcessingLog log) {
        IBiasCorrector bias = this.toolkit.getBiasCorrector();
        if (bias != null) {
            bias.correctBias(model);
        }
    }

    private SeatsResults results(SeatsModel model) {
        return SeatsResults.builder().originalModel(model.getOriginalModel()).finalModel(model.getCurrentModel()).meanCorrection(model.isMeanCorrection()).innovationVariance(model.getInnovationVariance()).parametersCutOff(model.isParametersCutOff()).modelChanged(model.isModelChanged()).ucarimaModel(model.getUcarimaModel()).compactUcarimaModel(model.compactUcarimaModel(false, false)).initialComponents(model.getInitialComponents()).finalComponents(model.getFinalComponents()).build();
    }
}

