/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.functions.ssq;

import internal.toolkit.base.core.math.functions.gsl.derivation.GslDerivation;
import java.util.function.DoubleFunction;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoublesMath;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.functions.IFunction;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunction;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunctionDerivatives;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunctionPoint;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;

public class RobustSsqNumericalDerivatives
implements ISsqFunctionDerivatives {
    private static final int NTHREADS = Runtime.getRuntime().availableProcessors();
    private DoubleSeq[] m_de;
    private double[] m_grad;
    private FastMatrix m_h;
    private final ISsqFunction fn;
    private DoubleSeq m_pt;
    private DoubleSeq m_ecur;
    private final boolean m_sym;
    private final boolean m_mt;
    private static int g_nsteps = 2;

    public RobustSsqNumericalDerivatives(ISsqFunctionPoint point) {
        this(point, true, true);
    }

    public RobustSsqNumericalDerivatives(ISsqFunctionPoint point, boolean sym, boolean mt) {
        this.m_sym = sym;
        this.m_mt = mt;
        this.fn = point.getSsqFunction();
        this.m_ecur = point.getE();
        this.m_pt = point.getParameters();
    }

    public RobustSsqNumericalDerivatives(ISsqFunctionPoint point, boolean sym) {
        this(point, sym, false);
    }

    private void calcgrad() {
        int n = this.m_pt.length();
        this.m_grad = new double[n];
        this.m_de = new DoubleSeq[n];
        int ne = this.m_ecur.length();
        for (int i = 0; i < n; ++i) {
            double eps = this.fn.getDomain().epsilon(this.m_pt, i);
            DoubleSeq de = this.dfndi(i, eps);
            this.m_grad[i] = 2.0 * this.m_ecur.dot(de);
            this.m_de[i] = de;
        }
    }

    private DoubleFunction<DoubleSeq> fni(int idx) {
        return x -> {
            if (x == this.m_pt.get(idx)) {
                return this.m_ecur;
            }
            DataBlock pcur = DataBlock.of(this.m_pt);
            pcur.set(idx, x);
            ISsqFunctionPoint fn = this.fn.ssqEvaluate((DoubleSeq)pcur);
            return fn.getE();
        };
    }

    private DoubleSeq dfndi(int idx, double h) {
        DoubleFunction<DoubleSeq> fni = this.fni(idx);
        DoubleSeq fp = fni.apply(this.m_pt.get(idx) + h);
        DoubleSeq del = DoublesMath.subtract((DoubleSeq)fp, (DoubleSeq)this.m_ecur);
        if (del.ssq() * 10.0 >= (double)del.length() * h * h) {
            return del.times(1.0 / h);
        }
        try {
            return GslDerivation.centralDerivation(this.fni(idx), this.m_pt.get(idx), h);
        }
        catch (Exception exception) {
            try {
                return GslDerivation.forwardDerivation(this.fni(idx), this.m_pt.get(idx), h);
            }
            catch (Exception exception2) {
                try {
                    return GslDerivation.backwardDerivation(this.fni(idx), this.m_pt.get(idx), h);
                }
                catch (Exception err) {
                    return DoubleSeq.onMapping((int)this.m_ecur.length(), i -> 0.0);
                }
            }
        }
    }

    private void calch() {
        int i;
        if (this.m_grad == null) {
            this.calcgrad();
        }
        int n = this.m_grad.length;
        this.m_h = FastMatrix.square(n);
        for (i = 0; i < n; ++i) {
            DoubleSeq de = this.m_de[i];
            this.m_h.set(i, i, 2.0 * de.ssq());
        }
        for (i = 0; i < n; ++i) {
            for (int j = 0; j < i; ++j) {
                DoubleSeq dei = this.m_de[i];
                DoubleSeq dej = this.m_de[j];
                double z = 2.0 * dei.dot(dej);
                this.m_h.set(i, j, z);
                this.m_h.set(j, i, z);
            }
        }
    }

    @Override
    public IFunction getFunction() {
        return this.fn.asFunction();
    }

    @Override
    public DoubleSeq dEdX(int idx) {
        if (this.m_de == null) {
            this.calcgrad();
        }
        return this.m_de[idx];
    }

    private DoubleSeq err(int i, double dx) {
        try {
            if (dx == 0.0) {
                return this.m_ecur;
            }
            DataBlock pcur = DataBlock.of(this.m_pt);
            pcur.add(i, dx);
            ISsqFunctionPoint fn = this.fn.ssqEvaluate((DoubleSeq)pcur);
            return fn.getE();
        }
        catch (Exception err) {
            return this.m_ecur;
        }
    }

    @Override
    public DoubleSeq gradient() {
        if (this.m_grad == null) {
            this.calcgrad();
        }
        return DataBlock.of(this.m_grad);
    }

    @Override
    public void jacobian(FastMatrix m) {
        if (this.m_de == null) {
            this.calcgrad();
        }
        for (int i = 0; i < this.m_de.length; ++i) {
            m.column(i).copy(this.m_de[i]);
        }
    }

    @Override
    public void hessian(FastMatrix h) {
        if (this.m_h == null) {
            this.calch();
        }
        h.copy(this.m_h);
    }
}

