/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.io;

import cern.colt.matrix.io.MatrixInfo;
import cern.colt.matrix.io.MatrixSize;
import cern.colt.matrix.io.VectorInfo;
import cern.colt.matrix.io.VectorSize;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;

public class MatrixVectorWriter
extends PrintWriter {
    public MatrixVectorWriter(OutputStream outputStream) {
        super(outputStream);
    }

    public MatrixVectorWriter(OutputStream outputStream, boolean bl) {
        super(outputStream, bl);
    }

    public MatrixVectorWriter(Writer writer) {
        super(writer);
    }

    public MatrixVectorWriter(Writer writer, boolean bl) {
        super(writer, bl);
    }

    public void add(int n, int[] nArray) {
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = n2++;
            nArray[n3] = nArray[n3] + n;
        }
    }

    public void printMatrixInfo(MatrixInfo matrixInfo) {
        this.print(matrixInfo.toString());
    }

    public void printVectorInfo(VectorInfo vectorInfo) {
        this.print(vectorInfo.toString());
    }

    public void printMatrixSize(MatrixSize matrixSize, MatrixInfo matrixInfo) {
        this.format("%10d %10d", matrixSize.numRows(), matrixSize.numColumns());
        if (matrixInfo.isCoordinate()) {
            this.format(" %19d", matrixSize.numEntries());
        }
        this.println();
    }

    public void printMatrixSize(MatrixSize matrixSize) {
        this.format("%10d %10d %19d\n", matrixSize.numRows(), matrixSize.numColumns(), matrixSize.numEntries());
    }

    public void printVectorSize(VectorSize vectorSize, VectorInfo vectorInfo) {
        this.format("%10d", vectorSize.size());
        if (vectorInfo.isCoordinate()) {
            this.format(" %19d", vectorSize.numEntries());
        }
        this.println();
    }

    public void printVectorSize(VectorSize vectorSize) {
        this.format("%10d %19d\n", vectorSize.size(), vectorSize.numEntries());
    }

    public void printArray(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            this.format("% .12e\n", Float.valueOf(fArray[i]));
        }
    }

    public void printArray(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            this.format("% .12e\n", dArray[i]);
        }
    }

    public void printArray(float[] fArray, float[] fArray2) {
        int n = fArray.length;
        if (n != fArray2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n; ++i) {
            this.format("% .12e % .12e\n", Float.valueOf(fArray[i]), Float.valueOf(fArray2[i]));
        }
    }

    public void printArray(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n; ++i) {
            this.format("% .12e % .12e\n", dArray[i], dArray2[i]);
        }
    }

    public void printArray(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.format("%10d\n", nArray[i]);
        }
    }

    public void printArray(long[] lArray) {
        for (int i = 0; i < lArray.length; ++i) {
            this.format("%10d\n", lArray[i]);
        }
    }

    public void printCoordinate(int[] nArray, float[] fArray, int n) {
        int n2 = nArray.length;
        if (n2 != fArray.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n2; ++i) {
            this.format("%10d % .12e\n", nArray[i] + n, Float.valueOf(fArray[i]));
        }
    }

    public void printCoordinate(int[] nArray, double[] dArray, int n) {
        int n2 = nArray.length;
        if (n2 != dArray.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n2; ++i) {
            this.format("%10d % .12e\n", nArray[i] + n, dArray[i]);
        }
    }

    public void printCoordinate(int[] nArray, int[] nArray2, int n) {
        int n2 = nArray.length;
        if (n2 != nArray2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n2; ++i) {
            this.format("%10d %10d\n", nArray[i] + n, nArray2[i]);
        }
    }

    public void printCoordinate(int[] nArray, long[] lArray, int n) {
        int n2 = nArray.length;
        if (n2 != lArray.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n2; ++i) {
            this.format("%10d %10d\n", nArray[i] + n, lArray[i]);
        }
    }

    public void printCoordinate(int[] nArray, int[] nArray2, float[] fArray, int n) {
        int n2 = nArray.length;
        if (n2 != nArray2.length || n2 != fArray.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n2; ++i) {
            this.format("%10d %10d % .12e\n", nArray[i] + n, nArray2[i] + n, Float.valueOf(fArray[i]));
        }
    }

    public void printCoordinate(int[] nArray, int[] nArray2, double[] dArray, int n) {
        int n2 = nArray.length;
        if (n2 != nArray2.length || n2 != dArray.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n2; ++i) {
            this.format("%10d %10d % .12e\n", nArray[i] + n, nArray2[i] + n, dArray[i]);
        }
    }

    public void printCoordinate(int[] nArray, float[] fArray, float[] fArray2, int n) {
        int n2 = nArray.length;
        if (n2 != fArray.length || n2 != fArray2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n2; ++i) {
            this.format("%10d % .12e % .12e\n", nArray[i] + n, Float.valueOf(fArray[i]), Float.valueOf(fArray2[i]));
        }
    }

    public void printCoordinate(int[] nArray, double[] dArray, double[] dArray2, int n) {
        int n2 = nArray.length;
        if (n2 != dArray.length || n2 != dArray2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n2; ++i) {
            this.format("%10d % .12e % .12e\n", nArray[i] + n, dArray[i], dArray2[i]);
        }
    }

    public void printCoordinate(int[] nArray, int[] nArray2, float[] fArray, float[] fArray2, int n) {
        int n2 = nArray.length;
        if (n2 != nArray2.length || n2 != fArray.length || n2 != fArray2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n2; ++i) {
            this.format("%10d %10d % .12e % .12e\n", nArray[i] + n, nArray2[i] + n, Float.valueOf(fArray[i]), Float.valueOf(fArray2[i]));
        }
    }

    public void printCoordinate(int[] nArray, int[] nArray2, double[] dArray, double[] dArray2, int n) {
        int n2 = nArray.length;
        if (n2 != nArray2.length || n2 != dArray.length || n2 != dArray2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n2; ++i) {
            this.format("%10d %10d % .12e % .12e\n", nArray[i] + n, nArray2[i] + n, dArray[i], dArray2[i]);
        }
    }

    public void printCoordinate(int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2 = nArray.length;
        if (n2 != nArray2.length || n2 != nArray3.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n2; ++i) {
            this.format("%10d %10d %19d\n", nArray[i] + n, nArray2[i] + n, nArray3[i]);
        }
    }

    public void printCoordinate(int[] nArray, int[] nArray2, long[] lArray, int n) {
        int n2 = nArray.length;
        if (n2 != nArray2.length || n2 != lArray.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n2; ++i) {
            this.format("%10d %10d %19d\n", nArray[i] + n, nArray2[i] + n, lArray[i]);
        }
    }

    public void printPattern(int[] nArray, int[] nArray2, int n) {
        int n2 = nArray.length;
        if (n2 != nArray2.length) {
            throw new IllegalArgumentException("All arrays must be of the same size");
        }
        for (int i = 0; i < n2; ++i) {
            this.format("%10d %10d\n", nArray[i] + n, nArray2[i] + n);
        }
    }

    public void printPattern(int[] nArray, int n) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            this.format("%10d\n", nArray[i] + n);
        }
    }

    public void printCoordinate(int[] nArray, int[] nArray2, float[] fArray) {
        this.printCoordinate(nArray, nArray2, fArray, 0);
    }

    public void printCoordinate(int[] nArray, int[] nArray2, double[] dArray) {
        this.printCoordinate(nArray, nArray2, dArray, 0);
    }

    public void printCoordinate(int[] nArray, int[] nArray2, float[] fArray, float[] fArray2) {
        this.printCoordinate(nArray, nArray2, fArray, fArray2, 0);
    }

    public void printCoordinate(int[] nArray, int[] nArray2, double[] dArray, double[] dArray2) {
        this.printCoordinate(nArray, nArray2, dArray, dArray2, 0);
    }

    public void printCoordinate(int[] nArray, int[] nArray2, int[] nArray3) {
        this.printCoordinate(nArray, nArray2, nArray3, 0);
    }

    public void printCoordinate(int[] nArray, int[] nArray2, long[] lArray) {
        this.printCoordinate(nArray, nArray2, lArray, 0);
    }

    public void printPattern(int[] nArray, int[] nArray2) {
        this.printPattern(nArray, nArray2, 0);
    }

    public void printCoordinate(int[] nArray, float[] fArray) {
        this.printCoordinate(nArray, fArray, 0);
    }

    public void printCoordinate(int[] nArray, double[] dArray) {
        this.printCoordinate(nArray, dArray, 0);
    }

    public void printCoordinate(int[] nArray, float[] fArray, float[] fArray2) {
        this.printCoordinate(nArray, fArray, fArray2, 0);
    }

    public void printCoordinate(int[] nArray, double[] dArray, double[] dArray2) {
        this.printCoordinate(nArray, dArray, dArray2, 0);
    }

    public void printCoordinate(int[] nArray, int[] nArray2) {
        this.printCoordinate(nArray, nArray2, 0);
    }

    public void printCoordinate(int[] nArray, long[] lArray) {
        this.printCoordinate(nArray, lArray, 0);
    }

    public void printPattern(int[] nArray) {
        this.printPattern(nArray, 0);
    }

    public void printComments(String[] stringArray) {
        for (String string : stringArray) {
            this.println("%" + string);
        }
    }
}

