/*
 * Decompiled with CFR 0.152.
 */
package dr.xml;

import dr.app.beast.BeastParser;
import dr.app.tools.BeastParserDoc;
import dr.xml.AttributeRule;
import dr.xml.ClassComparator;
import dr.xml.ElementRule;
import dr.xml.OrRule;
import dr.xml.XMLObjectParser;
import dr.xml.XMLSyntaxRule;
import dr.xml.XORRule;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;

public class XMLDocumentationHandler {
    protected Set<Class> requiredTypes = new TreeSet<Class>(ClassComparator.INSTANCE);
    protected BeastParser parser = null;
    private final Random random = new Random();
    private static final int SPACES = 2;

    public XMLDocumentationHandler(BeastParser beastParser) {
        this.parser = beastParser;
        Iterator iterator = beastParser.getParsers();
        while (iterator.hasNext()) {
            XMLObjectParser xMLObjectParser = (XMLObjectParser)iterator.next();
            XMLSyntaxRule[] xMLSyntaxRuleArray = xMLObjectParser.getSyntaxRules();
            if (xMLSyntaxRuleArray == null) continue;
            for (XMLSyntaxRule xMLSyntaxRule : xMLSyntaxRuleArray) {
                Set<Class> set = xMLSyntaxRule.getRequiredTypes();
                this.requiredTypes.addAll(set);
            }
        }
    }

    private void printDocXMLTitle(PrintWriter printWriter, String string) {
        printWriter.println("<head>");
        printWriter.println("  <link rel=\"stylesheet\" href=\"../beast.css\">");
        printWriter.println("  <title>" + string + "</title>");
        printWriter.println("</head>");
        printWriter.println("<h1>" + BeastParserDoc.TITLE + "</h1>");
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("'updated on' d MMMM yyyy zzz");
        if (this.parser.parsers != null) {
            if (this.parser.parsers.equalsIgnoreCase("release")) {
                printWriter.println("<p>Release Version (" + simpleDateFormat.format(calendar.getTime()) + ")</p>");
                System.out.println("Release Version");
            } else if (this.parser.parsers.equalsIgnoreCase("development")) {
                printWriter.println("<p>Development Version (" + simpleDateFormat.format(calendar.getTime()) + ")</p>");
                System.out.println("Development Version");
            }
        }
        printWriter.println("<!-- Alexei Drummond, Marc A Suchard & Andrew Rambaut -->");
        printWriter.println("<!-- http://beast.community/ -->");
        printWriter.println("<!-- http://github.com/beast-dev/beast-mcmc/ -->");
    }

    public void outputElements(PrintWriter printWriter) {
        printWriter.println("<html>");
        this.printDocXMLTitle(printWriter, BeastParserDoc.DETAIL_HTML);
        printWriter.println("<p>");
        printWriter.println("The following is a list of valid elements in a beast file.<br>");
        printWriter.println("<span class=\"required\">&nbsp;&nbsp;&nbsp;&nbsp;</span> required<br>");
        printWriter.println("<span class=\"optional\">&nbsp;&nbsp;&nbsp;&nbsp;</span> optional<br>");
        printWriter.println("</p>");
        printWriter.println("\n");
        Iterator iterator = this.parser.getParsers();
        while (iterator.hasNext()) {
            XMLObjectParser xMLObjectParser = (XMLObjectParser)iterator.next();
            printWriter.println(xMLObjectParser.toHTML(this));
            System.out.println("  outputting HTML for element " + xMLObjectParser.getParserName());
        }
        printWriter.println("</body>");
        printWriter.println("</html>");
    }

    public void outputHTMLExampleXML(PrintWriter printWriter, XMLObjectParser xMLObjectParser) {
        printWriter.println("<pre>");
        if (xMLObjectParser.hasExample()) {
            this.outputHTMLSafeText(printWriter, xMLObjectParser.getExample());
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            this.createExampleXML(stringBuilder, xMLObjectParser, 0);
            this.outputHTMLSafeText(printWriter, stringBuilder.toString());
        }
        printWriter.println("</pre>");
    }

    public void outputMarkdownExampleXML(PrintWriter printWriter, XMLObjectParser xMLObjectParser) {
        printWriter.println("```html");
        if (xMLObjectParser.hasExample()) {
            printWriter.print(xMLObjectParser.getExample());
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            this.createExampleXML(stringBuilder, xMLObjectParser, 0);
            printWriter.print(stringBuilder.toString());
        }
        printWriter.println("```\n");
    }

    public void outputHTMLSafeText(PrintWriter printWriter, String string) {
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    printWriter.print("&lt;");
                    continue block5;
                }
                case '>': {
                    printWriter.print("&gt;");
                    continue block5;
                }
                case '&': {
                    printWriter.print("&amp;");
                    continue block5;
                }
                default: {
                    printWriter.print(c);
                }
            }
        }
    }

    public void createExampleXML(StringBuilder stringBuilder, XMLObjectParser xMLObjectParser, int n) {
        this.createElementRules(stringBuilder, xMLObjectParser.getParserName(), xMLObjectParser.getSyntaxRules(), n);
    }

    public void stochasticCollectRules(XMLSyntaxRule[] xMLSyntaxRuleArray, ArrayList<XMLSyntaxRule> arrayList, ArrayList<ElementRule> arrayList2) {
        if (xMLSyntaxRuleArray != null) {
            for (XMLSyntaxRule xMLSyntaxRule : xMLSyntaxRuleArray) {
                int n;
                if (xMLSyntaxRule instanceof AttributeRule) {
                    arrayList.add(xMLSyntaxRule);
                    continue;
                }
                if (xMLSyntaxRule instanceof ElementRule) {
                    int n2 = ((ElementRule)xMLSyntaxRule).getMin();
                    int n3 = Math.max(n2, Math.min(5, ((ElementRule)xMLSyntaxRule).getMax()));
                    n = n2;
                    if (n3 != n2) {
                        n = this.random.nextInt(n3 - n2) + n2;
                    }
                    for (int i = 0; i < n; ++i) {
                        arrayList2.add((ElementRule)xMLSyntaxRule);
                    }
                    continue;
                }
                if (xMLSyntaxRule instanceof XORRule) {
                    XORRule xORRule = (XORRule)xMLSyntaxRule;
                    XMLSyntaxRule[] xMLSyntaxRuleArray2 = xORRule.getRules();
                    n = this.random.nextInt(xMLSyntaxRuleArray2.length);
                    this.stochasticCollectRules(new XMLSyntaxRule[]{xMLSyntaxRuleArray2[n]}, arrayList, arrayList2);
                    continue;
                }
                if (!(xMLSyntaxRule instanceof OrRule)) continue;
                OrRule orRule = (OrRule)xMLSyntaxRule;
                XMLSyntaxRule[] xMLSyntaxRuleArray3 = orRule.getRules();
                n = this.random.nextInt(xMLSyntaxRuleArray3.length);
                this.stochasticCollectRules(new XMLSyntaxRule[]{xMLSyntaxRuleArray3[n]}, arrayList, arrayList2);
            }
        }
    }

    public void createExampleXML(StringBuilder stringBuilder, AttributeRule attributeRule) {
        stringBuilder.append(" " + attributeRule.getName() + "=\"");
        if (attributeRule.hasExample()) {
            stringBuilder.append(attributeRule.getExample());
        } else {
            this.createAttributeValue(stringBuilder, attributeRule.getAttributeClass());
        }
        stringBuilder.append("\"");
    }

    public void createExampleXML(StringBuilder stringBuilder, ElementRule elementRule, int n) {
        if (elementRule.getElementClass() == null) {
            if (elementRule.getName() == null) {
                System.err.println(elementRule + " has a null name");
            }
            this.createElementRules(stringBuilder, elementRule.getName(), elementRule.getRules(), n);
        } else if (elementRule.hasExample()) {
            stringBuilder.append(this.spaces(n + 1) + elementRule.getExample()).append("\n");
        } else {
            this.createExampleXML(stringBuilder, elementRule.getElementClass(), n);
        }
    }

    public void createElementRules(StringBuilder stringBuilder, String string, XMLSyntaxRule[] xMLSyntaxRuleArray, int n) {
        ArrayList<XMLSyntaxRule> arrayList = new ArrayList<XMLSyntaxRule>();
        ArrayList<ElementRule> arrayList2 = new ArrayList<ElementRule>();
        this.stochasticCollectRules(xMLSyntaxRuleArray, arrayList, arrayList2);
        stringBuilder.append(this.spaces(n) + "<" + string);
        for (XMLSyntaxRule xMLSyntaxRule : arrayList) {
            this.createExampleXML(stringBuilder, (AttributeRule)xMLSyntaxRule);
        }
        if (arrayList2.size() > 0) {
            stringBuilder.append(">").append("\n");
            for (ElementRule elementRule : arrayList2) {
                this.createExampleXML(stringBuilder, elementRule, n + 1);
            }
            stringBuilder.append(this.spaces(n) + "</" + string + ">").append("\n");
        } else {
            stringBuilder.append("/>").append("\n");
        }
    }

    public void createExampleXML(StringBuilder stringBuilder, Class clazz, int n) {
        if (clazz == String.class) {
            stringBuilder.append(this.spaces(n) + "foo").append("\n");
        } else if (clazz == Double.class) {
            stringBuilder.append(this.spaces(n) + "1.0").append("\n");
        } else if (clazz == Integer.class || clazz == Long.class) {
            stringBuilder.append(this.spaces(n) + "1").append("\n");
        } else if (clazz == Boolean.class) {
            stringBuilder.append(this.spaces(n) + "true").append("\n");
        } else if (clazz == Double[].class) {
            stringBuilder.append(this.spaces(n) + "0.5 1.0").append("\n");
        } else if (clazz == String[].class) {
            stringBuilder.append(this.spaces(n) + "foo bar").append("\n");
        } else {
            if (clazz == null) {
                throw new RuntimeException("Class is null");
            }
            XMLObjectParser xMLObjectParser = this.getRandomParser(clazz);
            if (xMLObjectParser == null) {
                stringBuilder.append(this.spaces(n) + "ERROR!").append("\n");
            } else if (n > 1) {
                stringBuilder.append(this.spaces(n) + "<" + xMLObjectParser.getParserName() + " idref=\"" + xMLObjectParser.getParserName() + (this.random.nextInt(10) + 1) + "\">");
                stringBuilder.append("\n");
            } else {
                this.createExampleXML(stringBuilder, xMLObjectParser, n);
            }
        }
    }

    public void createAttributeValue(StringBuilder stringBuilder, Class clazz) {
        if (clazz == String.class) {
            stringBuilder.append("foo");
        } else if (clazz == Double.class) {
            stringBuilder.append("1.0");
        } else if (clazz == Integer.class || clazz == Long.class) {
            stringBuilder.append("1");
        } else if (clazz == Boolean.class) {
            stringBuilder.append("true");
        } else if (clazz == Double[].class) {
            stringBuilder.append("0.5 1.0");
        } else if (clazz == Integer[].class) {
            stringBuilder.append("1 2 4 8");
        } else if (clazz == String[].class) {
            stringBuilder.append("foo bar");
        } else {
            throw new RuntimeException("Class " + clazz + " not allowed as attribute value");
        }
    }

    private String spaces(int n) {
        StringBuffer stringBuffer = new StringBuffer("");
        for (int i = 0; i < n * 2; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public XMLObjectParser getRandomParser(Class clazz) {
        ArrayList<XMLObjectParser> arrayList = this.getMatchingParsers(clazz);
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.get(this.random.nextInt(arrayList.size()));
    }

    public final ArrayList<XMLObjectParser> getMatchingParsers(Class clazz) {
        ArrayList<XMLObjectParser> arrayList = new ArrayList<XMLObjectParser>();
        Iterator iterator = this.parser.getParsers();
        while (iterator.hasNext()) {
            XMLObjectParser xMLObjectParser = (XMLObjectParser)iterator.next();
            Class clazz2 = xMLObjectParser.getReturnType();
            if (clazz2 == null || !clazz.isAssignableFrom(clazz2)) continue;
            arrayList.add(xMLObjectParser);
        }
        return arrayList;
    }

    public void outputIndex(PrintWriter printWriter) {
        printWriter.println("<html>");
        this.printDocXMLTitle(printWriter, BeastParserDoc.INDEX_HTML);
        printWriter.println("<p>");
        printWriter.println("The following is a list of generic types that elements represent in a beast file.<br>");
        printWriter.println("</p>");
        for (Class clazz : this.requiredTypes) {
            if (clazz == Object.class) continue;
            String string = ClassComparator.getName(clazz);
            System.out.println("  outputting HTML for generic type " + string);
            ArrayList<String> arrayList = new ArrayList<String>();
            Iterator iterator = this.parser.getParsers();
            while (iterator.hasNext()) {
                XMLObjectParser xMLObjectParser = (XMLObjectParser)iterator.next();
                Class clazz2 = xMLObjectParser.getReturnType();
                if (clazz2 == null) {
                    System.out.println("find null Class for parser : " + xMLObjectParser.getParserName());
                    continue;
                }
                if (!clazz.isAssignableFrom(clazz2)) continue;
                if (arrayList.size() == 0) {
                    printWriter.println("<div id=\"" + string + "\"><h2>" + string + "</h2>");
                    printWriter.println("<p>");
                    printWriter.println("Elements of this type include:");
                    printWriter.println("</p>");
                }
                if (arrayList.contains(xMLObjectParser.getParserName())) continue;
                arrayList.add(xMLObjectParser.getParserName());
                printWriter.println("<div id=\"" + xMLObjectParser.getParserName() + "\" class=\"element\">");
                printWriter.println("    <span class=\"elementname\"><a href=\"" + BeastParserDoc.DETAIL_HTML + "#" + xMLObjectParser.getParserName() + "\"> <h3>&lt;" + xMLObjectParser.getParserName() + "&gt;</h3></a></span>");
                printWriter.println("    <div class=\"description\"><b>Description:</b><br>");
                printWriter.println(xMLObjectParser.getParserDescription());
                printWriter.println("    </div>");
                printWriter.println("  </div>");
                printWriter.println("<p/>");
            }
            if (arrayList.size() > 0) {
                printWriter.println("</div>");
            }
            printWriter.println("<p/>");
        }
        printWriter.println("</body>");
        printWriter.println("</html>");
    }

    public void outputTypes(PrintWriter printWriter) {
    }

    public String getHTMLForClass(Class clazz) {
        String string = ClassComparator.getName(clazz);
        return "<A HREF=\"" + BeastParserDoc.INDEX_HTML + "#" + string + "\">" + string + "</A>";
    }
}

