/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators;

import dr.inference.model.Bounds;
import dr.inference.model.Parameter;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import java.util.List;

public class SwapParameterOperator
extends SimpleMCMCOperator {
    private final List<Parameter> parameterList;
    private String parameterNames = null;

    public SwapParameterOperator(List<Parameter> list, double d) {
        this.parameterList = list;
        if (list.size() < 2) {
            throw new IllegalArgumentException("More than 1 parameter is needed");
        }
        int n = list.get(0).getDimension();
        for (int i = 1; i < list.size(); ++i) {
            if (n == list.get(i).getDimension()) continue;
            throw new IllegalArgumentException("All parameters most be the same size");
        }
        this.setWeight(d);
    }

    @Override
    public final double doOperation() {
        int n;
        int n2 = n = MathUtils.nextInt(this.parameterList.size());
        while (n2 == n) {
            n2 = MathUtils.nextInt(this.parameterList.size());
        }
        Parameter parameter = this.parameterList.get(n);
        Parameter parameter2 = this.parameterList.get(n2);
        Bounds<Double> bounds = parameter.getBounds();
        Bounds<Double> bounds2 = parameter2.getBounds();
        for (int i = 0; i < parameter.getDimension(); ++i) {
            double d = parameter.getParameterValue(i);
            double d2 = parameter2.getParameterValue(i);
            if (this.isOutside(bounds, d2, i) || this.isOutside(bounds2, d, i)) {
                return Double.NEGATIVE_INFINITY;
            }
            parameter.setParameterValueQuietly(i, d2);
            parameter2.setParameterValueQuietly(i, d);
        }
        parameter.fireParameterChangedEvent();
        parameter2.fireParameterChangedEvent();
        return 0.0;
    }

    private boolean isOutside(Bounds<Double> bounds, double d, int n) {
        return d < bounds.getLowerLimit(n) || d > bounds.getUpperLimit(n);
    }

    private String getParameterNames() {
        if (this.parameterNames == null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Parameter parameter : this.parameterList) {
                stringBuilder.append(parameter.getParameterName()).append(".");
            }
            this.parameterNames = stringBuilder.toString();
        }
        return this.parameterNames;
    }

    @Override
    public String getOperatorName() {
        return "swapOperator(" + this.getParameterNames() + "swap)";
    }

    public String getPerformanceSuggestion() {
        return "No suggestions";
    }
}

