/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.model;

import dr.inference.model.Bounds;
import dr.inference.model.CompoundParameter;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.inference.model.VariableListener;

public class DifferenceMatrixParameter
extends MatrixParameter
implements VariableListener {
    private Parameter parameter1;
    private Parameter parameter2;
    private Bounds bounds = null;

    public DifferenceMatrixParameter(Parameter parameter, Parameter parameter2) {
        super(null);
        this.parameter1 = parameter;
        this.parameter2 = parameter2;
        this.parameter1.addVariableListener(this);
        this.parameter2.addVariableListener(this);
    }

    @Override
    public double getParameterValue(int n) {
        double d = 0.0;
        if (n < Math.max(this.parameter1.getDimension(), this.parameter2.getDimension())) {
            d = this.parameter1.getDimension() == this.parameter2.getDimension() ? this.parameter1.getParameterValue(n) - this.parameter2.getParameterValue(n) : (this.parameter1.getDimension() < this.parameter2.getDimension() ? this.parameter1.getParameterValue(n % this.parameter1.getDimension()) - this.parameter2.getParameterValue(n) : this.parameter1.getParameterValue(n) - this.parameter2.getParameterValue(n % this.parameter2.getDimension()));
        } else {
            System.out.println(n);
            throw new RuntimeException("Index out of bounds.");
        }
        return d;
    }

    @Override
    public double getParameterValue(int n, int n2) {
        double d = this.parameter1 instanceof MatrixParameter ? ((MatrixParameter)this.parameter1).getParameterValue(n, n2) : this.getParameterValue(n);
        double d2 = this.parameter2 instanceof MatrixParameter ? ((MatrixParameter)this.parameter2).getParameterValue(n, n2) : this.getParameterValue(n);
        return d - d2;
    }

    @Override
    public int getParameterCount() {
        int n = 1;
        int n2 = 1;
        if (this.parameter1 instanceof MatrixParameter) {
            n = ((MatrixParameter)this.parameter1).getParameterCount();
        }
        if (this.parameter2 instanceof MatrixParameter) {
            n2 = ((MatrixParameter)this.parameter2).getParameterCount();
        }
        return Math.max(n, n2);
    }

    @Override
    public Parameter getParameter(int n) {
        Parameter parameter = this.parameter1 instanceof CompoundParameter ? ((CompoundParameter)this.parameter1).getParameter(n) : this.parameter1;
        Parameter parameter2 = this.parameter2 instanceof CompoundParameter ? ((CompoundParameter)this.parameter2).getParameter(n) : this.parameter2;
        return new DifferenceMatrixParameter(parameter, parameter2);
    }

    @Override
    public void setParameterValue(int n, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setParameterValueQuietly(int n, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void setParameterValueNotifyChangedAll(int n, double d) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public int getDimension() {
        return Math.max(this.parameter1.getDimension(), this.parameter2.getDimension());
    }

    @Override
    public void addBounds(Bounds<Double> bounds) {
        this.bounds = bounds;
    }

    @Override
    public Bounds<Double> getBounds() {
        return this.bounds;
    }

    @Override
    public void addDimension(int n, double d) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public double removeDimension(int n) {
        throw new RuntimeException("Not yet implemented.");
    }

    @Override
    public void variableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        this.fireParameterChangedEvent(n, changeType);
    }

    @Override
    protected void storeValues() {
        this.parameter1.storeParameterValues();
        this.parameter2.storeParameterValues();
    }

    @Override
    protected void restoreValues() {
        this.parameter1.restoreParameterValues();
        this.parameter2.restoreParameterValues();
    }

    @Override
    public int getRowDimension() {
        boolean bl = this.parameter1 instanceof MatrixParameter;
        boolean bl2 = this.parameter2 instanceof MatrixParameter;
        System.out.println("row");
        if (bl & bl2) {
            if (((MatrixParameter)this.parameter1).getRowDimension() == ((MatrixParameter)this.parameter2).getRowDimension()) {
                return ((MatrixParameter)this.parameter1).getRowDimension();
            }
            throw new RuntimeException("parameters not of the same length");
        }
        if (bl) {
            return ((MatrixParameter)this.parameter1).getRowDimension();
        }
        if (bl2) {
            return ((MatrixParameter)this.parameter2).getRowDimension();
        }
        return this.parameter1.getDimension();
    }

    @Override
    public int getColumnDimension() {
        System.out.println("column");
        boolean bl = this.parameter1 instanceof MatrixParameter;
        boolean bl2 = this.parameter2 instanceof MatrixParameter;
        if (bl & bl2) {
            if (((MatrixParameter)this.parameter1).getColumnDimension() == ((MatrixParameter)this.parameter2).getColumnDimension()) {
                return ((MatrixParameter)this.parameter1).getColumnDimension();
            }
            throw new RuntimeException("parameters not of the same length");
        }
        if (bl) {
            return ((MatrixParameter)this.parameter1).getColumnDimension();
        }
        if (bl2) {
            return ((MatrixParameter)this.parameter2).getColumnDimension();
        }
        return 1;
    }
}

