/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeTrait;
import dr.evolution.tree.TreeTraitProvider;
import dr.util.Transform;

public class TransformedTreeTraitProvider
implements TreeTraitProvider {
    private TreeTraitProvider.Helper transformedTreeTraits = new TreeTraitProvider.Helper();

    public TransformedTreeTraitProvider(TreeTraitProvider treeTraitProvider, Transform transform) {
        for (TreeTrait treeTrait : treeTraitProvider.getTreeTraits()) {
            if (treeTrait.getTraitClass() == Double.class) {
                this.transformedTreeTraits.addTrait(this.createD(treeTrait, transform));
                continue;
            }
            if (treeTrait.getTraitClass() == double[].class) {
                this.transformedTreeTraits.addTrait(this.createDA(treeTrait, transform));
                continue;
            }
            throw new IllegalArgumentException("Not transformable trait: " + treeTrait.getTraitName());
        }
    }

    @Override
    public TreeTrait[] getTreeTraits() {
        return this.transformedTreeTraits.getTreeTraits();
    }

    @Override
    public TreeTrait getTreeTrait(String string) {
        return this.transformedTreeTraits.getTreeTrait(string);
    }

    private TreeTrait.D createD(final TreeTrait treeTrait, final Transform transform) {
        return new TreeTrait.D(){

            @Override
            public String getTraitName() {
                return transform.getTransformName() + "." + treeTrait.getTraitName();
            }

            @Override
            public TreeTrait.Intent getIntent() {
                return treeTrait.getIntent();
            }

            @Override
            public Double getTrait(Tree tree, NodeRef nodeRef) {
                return transform.transform((Double)treeTrait.getTrait(tree, nodeRef));
            }

            @Override
            public boolean getLoggable() {
                return true;
            }
        };
    }

    private TreeTrait.DA createDA(final TreeTrait treeTrait, final Transform transform) {
        return new TreeTrait.DA(){

            @Override
            public String getTraitName() {
                return transform.getTransformName() + "." + treeTrait.getTraitName();
            }

            @Override
            public TreeTrait.Intent getIntent() {
                return treeTrait.getIntent();
            }

            @Override
            public double[] getTrait(Tree tree, NodeRef nodeRef) {
                double[] dArray = (double[])treeTrait.getTrait(tree, nodeRef);
                return transform.transform(dArray, 0, dArray.length);
            }

            @Override
            public boolean getLoggable() {
                return true;
            }
        };
    }
}

