/*
 * Decompiled with CFR 0.152.
 */
package dr.evolution.continuous;

import dr.evolution.continuous.Contrastable;
import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.math.ConjugateDirectionSearch;
import dr.math.MultivariateFunction;
import dr.math.MultivariateMinimum;
import dr.math.UnivariateFunction;
import dr.math.UnivariateMinimum;

public class DiffusionLikelihood
implements UnivariateFunction,
MultivariateFunction {
    Tree tree;
    String traitName;

    public DiffusionLikelihood(Tree tree, String string) {
        this.tree = tree;
        this.traitName = string;
    }

    public double optimize(double[] dArray) {
        if (dArray.length > 1) {
            dArray[0] = 1.0;
            dArray[1] = 0.01;
            ConjugateDirectionSearch conjugateDirectionSearch = new ConjugateDirectionSearch();
            ((MultivariateMinimum)conjugateDirectionSearch).optimize(this, dArray, 1.0E-6, 1.0E-6);
            return -this.evaluate(dArray);
        }
        if (dArray.length == 1) {
            UnivariateMinimum univariateMinimum = new UnivariateMinimum();
            dArray[0] = univariateMinimum.optimize(this, 1.0E-6);
            return -this.evaluate(dArray[0]);
        }
        throw new IllegalArgumentException("");
    }

    public double getLogLikelihood(double d, double d2, double d3, double d4) {
        double d5 = d3 * d2;
        double d6 = d - d4 * d2;
        return -Math.log(Math.sqrt(d5 * 2.0 * Math.PI)) - d6 * d6 / (2.0 * d5);
    }

    @Override
    public double evaluate(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = 0.0;
        for (int i = 0; i < this.tree.getNodeCount(); ++i) {
            NodeRef nodeRef = this.tree.getNode(i);
            if (this.tree.isRoot(nodeRef)) continue;
            NodeRef nodeRef2 = this.tree.getParent(nodeRef);
            Contrastable contrastable = (Contrastable)this.tree.getNodeAttribute(nodeRef2, this.traitName);
            Contrastable contrastable2 = (Contrastable)this.tree.getNodeAttribute(nodeRef, this.traitName);
            double d4 = contrastable.getDifference(contrastable2);
            d3 += this.getLogLikelihood(d4, this.tree.getBranchLength(nodeRef), d, d2);
        }
        return -d3;
    }

    @Override
    public int getNumArguments() {
        return 2;
    }

    @Override
    public double getLowerBound(int n) {
        if (n == 0) {
            return 1.0E-12;
        }
        return -1.7976931348623157E308;
    }

    @Override
    public double getUpperBound(int n) {
        return 2000.0;
    }

    @Override
    public double evaluate(double d) {
        return this.evaluate(new double[]{d, 0.0});
    }

    @Override
    public double getLowerBound() {
        return this.getLowerBound(0);
    }

    @Override
    public double getUpperBound() {
        return this.getUpperBound(0);
    }
}

