/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.math.matrices.lapack;

import jdplus.toolkit.base.core.math.matrices.CPointer;
import jdplus.toolkit.base.core.math.matrices.DataPointer;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.RPointer;
import lombok.Generated;

public final class SYRK {
    public static void lapply(boolean AAt, double alpha, FastMatrix A, double beta, FastMatrix C) {
        int n = C.getRowsCount();
        int k = A.getRowsCount();
        if (n == 0 || (alpha == 0.0 || k == 0) && beta == 1.0) {
            return;
        }
        SYRK.lmul(C, beta);
        if (alpha == 0.0) {
            return;
        }
        if (AAt) {
            SYRK.laddaAAt(alpha, A, C);
        } else {
            SYRK.laddaAtA(alpha, A, C);
        }
    }

    public static void laddaXXt(double a, DataPointer x, FastMatrix S) {
        if (a == 0.0) {
            return;
        }
        double[] sx = S.getStorage();
        int n = S.getRowsCount();
        int sstart = S.getStartPosition();
        int slda = S.getColumnIncrement();
        int dinc = slda + 1;
        int xinc = x.inc();
        double[] xp = x.p();
        int spos = sstart;
        int ypos = x.pos();
        int c = 0;
        while (c < n) {
            double yc = xp[ypos];
            if (yc != 0.0) {
                yc *= a;
                if (xinc == 1) {
                    xmax = x.pos() + n;
                    jpos = spos;
                    for (xpos = ypos; xpos < xmax; ++xpos) {
                        int n2 = jpos++;
                        sx[n2] = sx[n2] + yc * xp[xpos];
                    }
                } else {
                    xmax = x.pos() + n * xinc;
                    jpos = spos;
                    for (xpos = ypos; xpos != xmax; xpos += xinc) {
                        int n3 = jpos++;
                        sx[n3] = sx[n3] + yc * xp[xpos];
                    }
                }
            }
            ypos += xinc;
            ++c;
            spos += dinc;
        }
    }

    public static void uaddaXXt(double a, DataPointer x, FastMatrix S) {
        if (a == 0.0) {
            return;
        }
        double[] sx = S.getStorage();
        int n = S.getRowsCount();
        int sstart = S.getStartPosition();
        int slda = S.getColumnIncrement();
        int xinc = x.inc();
        double[] xp = x.p();
        int spos = sstart;
        int ypos = x.pos();
        int c = 1;
        while (c <= n) {
            double yc = xp[ypos];
            if (yc != 0.0) {
                yc *= a;
                if (xinc == 1) {
                    jmax = spos + c;
                    xpos = x.pos();
                    jpos = spos;
                    while (jpos < jmax) {
                        int n2 = jpos++;
                        sx[n2] = sx[n2] + yc * xp[xpos];
                        ++xpos;
                    }
                } else {
                    jmax = spos + c;
                    xpos = x.pos();
                    jpos = spos;
                    while (jpos < jmax) {
                        int n3 = jpos++;
                        sx[n3] = sx[n3] + yc * xp[xpos];
                        xpos += xinc;
                    }
                }
            }
            ypos += xinc;
            ++c;
            spos += slda;
        }
    }

    public static void laddaAAt(double a, FastMatrix A, FastMatrix S) {
        if (a == 0.0) {
            return;
        }
        CPointer col = new CPointer(A.getStorage(), A.getStartPosition());
        int n = A.getColumnsCount();
        int lda = A.getColumnIncrement();
        for (int c = 0; c < n; ++c) {
            SYRK.laddaXXt(a, col, S);
            col.move(lda);
        }
    }

    public static void uaddaAAt(double a, FastMatrix A, FastMatrix S) {
        if (a == 0.0) {
            return;
        }
        CPointer col = new CPointer(A.getStorage(), A.getStartPosition());
        int n = A.getColumnsCount();
        int lda = A.getColumnIncrement();
        for (int c = 0; c < n; ++c) {
            SYRK.uaddaXXt(a, col, S);
            col.move(lda);
        }
    }

    public static void laddaAtA(double a, FastMatrix A, FastMatrix S) {
        if (a == 0.0) {
            return;
        }
        int m = A.getRowsCount();
        int lda = A.getColumnIncrement();
        RPointer row = new RPointer(A.getStorage(), A.getStartPosition(), lda);
        for (int r = 0; r < m; ++r) {
            SYRK.laddaXXt(a, row, S);
            row.next();
        }
    }

    public static void uaddaAtA(double a, FastMatrix A, FastMatrix S) {
        if (a == 0.0) {
            return;
        }
        int m = A.getRowsCount();
        int lda = A.getColumnIncrement();
        RPointer row = new RPointer(A.getStorage(), A.getStartPosition(), lda);
        for (int r = 0; r < m; ++r) {
            SYRK.uaddaXXt(a, row, S);
            row.next();
        }
    }

    private static void lmul(FastMatrix C, double beta) {
        if (beta == 1.0) {
            return;
        }
        int start = C.getStartPosition();
        int lda = C.getColumnIncrement();
        int n = C.getRowsCount();
        double[] pc = C.getStorage();
        if (beta == 0.0) {
            int c = 0;
            int ic = start;
            while (c < n) {
                int jmax = ic + n;
                for (int jc = ic + c; jc < jmax; ++jc) {
                    pc[jc] = 0.0;
                }
                ++c;
                ic += lda;
            }
        } else {
            int c = 0;
            int ic = start;
            while (c < n) {
                int jmax = ic + n;
                int jc = ic + c;
                while (jc < jmax) {
                    int n2 = jc++;
                    pc[n2] = pc[n2] * beta;
                }
                ++c;
                ic += lda;
            }
        }
    }

    private static void umul(FastMatrix C, double beta) {
        if (beta == 1.0) {
            return;
        }
        int start = C.getStartPosition();
        int lda = C.getColumnIncrement();
        int n = C.getRowsCount();
        double[] pc = C.getStorage();
        if (beta == 0.0) {
            int c = 1;
            int ic = start;
            while (c <= n) {
                int jmax = ic + c;
                for (int jc = ic; jc < jmax; ++jc) {
                    pc[jc] = 0.0;
                }
                ++c;
                ic += lda;
            }
        } else {
            int c = 1;
            int ic = start;
            while (c <= n) {
                int jmax = ic + c;
                int jc = ic;
                while (jc < jmax) {
                    int n2 = jc++;
                    pc[n2] = pc[n2] * beta;
                }
                ++c;
                ic += lda;
            }
        }
    }

    @Generated
    private SYRK() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

