## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 4,
  fig.height = 2,
  dpi = 150
)
library(ezTrack)

## -----------------------------------------------------------------------------
data(godwit_tracks)
head(godwit_tracks)

tracks <- ez_track(
  data = godwit_tracks
)

## -----------------------------------------------------------------------------
tracks_manual <- ez_track(
  data = godwit_tracks,
  id = 'individual.local.identifier',
  timestamp = 'timestamp',
  x = 'location.long',
  y = 'location.lat',
)

## -----------------------------------------------------------------------------
tracks_subsampled <- ez_track(
  data = godwit_tracks,
  subsample = "2 per hour"
)

## -----------------------------------------------------------------------------
summary_table <- ez_summary(tracks)
summary_table

## -----------------------------------------------------------------------------
ez_latitude_plot(tracks)

## -----------------------------------------------------------------------------
ez_latitude_plot(
  tracks,
  facet = TRUE,
  start_date = "2025-01-01",
  end_date = "2025-04-28",
  date_breaks = "2 months",
  date_format = "%b"
)

## -----------------------------------------------------------------------------
ez_fix_rate_plot(tracks)

## -----------------------------------------------------------------------------
ez_map(tracks)

## -----------------------------------------------------------------------------
ez_map(tracks,
  start_date = "2025-04-10",
  end_date = "2025-04-28",
  point_color = "timestamp",
  point_size = 2,
  path_opacity = 0.3)


## -----------------------------------------------------------------------------
home_ranges_mcp <- ez_home_range(tracks, method = 'mcp', level = 95, start_date = '2025-04-12')


## -----------------------------------------------------------------------------
ez_map(home_ranges = home_ranges_mcp)

## -----------------------------------------------------------------------------
ez_map(tracks, home_ranges = home_ranges_mcp, start_date = '2025-04-12')

