/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.metaAnalysis;

import dr.evomodel.operators.PrecisionMatrixGibbsOperator;
import dr.inference.distribution.DistributionLikelihood;
import dr.inference.distribution.MultivariateDistributionLikelihood;
import dr.inference.distribution.MultivariateNormalDistributionModel;
import dr.inference.model.Bounds;
import dr.inference.model.CompoundLikelihood;
import dr.inference.model.Likelihood;
import dr.inference.model.MatrixParameter;
import dr.inference.model.Parameter;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.MCMCOperator;
import dr.inference.operators.MultivariateNormalGibbsOperator;
import dr.math.distributions.Distribution;
import dr.math.distributions.MultivariateDistribution;
import dr.math.distributions.MultivariateNormalDistribution;
import dr.math.distributions.NormalDistribution;
import dr.math.distributions.WishartDistribution;
import dr.math.distributions.WishartStatistics;
import dr.math.matrixAlgebra.IllegalDimension;
import dr.util.Attribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.ohdsi.metaAnalysis.DataModel;
import org.ohdsi.metaAnalysis.MultivariableHierarchicalMetaAnalysis;

public interface MultivariatePrior {
    public List<Parameter> getParameters();

    public Likelihood getPrior();

    public Likelihood getLikelihood(int var1);

    public List<MCMCOperator> getOperators(double var1, AdaptationMode var3);

    public static abstract class Base
    implements MultivariatePrior {
        final List<Parameter> betas;
        final List<Parameter> parameters;
        final List<MCMCOperator> operators;
        final List<Likelihood> distributions;
        Likelihood prior;

        private List<Parameter> getAllBetas(List<DataModel> dataModels) {
            ArrayList<Parameter> betas = new ArrayList<Parameter>();
            for (DataModel dataModel : dataModels) {
                betas.add(dataModel.getCompoundParameter());
            }
            return betas;
        }

        protected Base(List<DataModel> dataModels) {
            this.betas = this.getAllBetas(dataModels);
            this.parameters = new ArrayList<Parameter>();
            this.operators = new ArrayList<MCMCOperator>();
            this.distributions = new ArrayList<Likelihood>();
        }

        @Override
        public List<Parameter> getParameters() {
            return this.parameters;
        }

        @Override
        public Likelihood getPrior() {
            if (this.prior == null) {
                this.prior = new CompoundLikelihood(this.distributions);
            }
            return this.prior;
        }

        @Override
        public Likelihood getLikelihood(int dim) {
            return this.distributions.get(dim);
        }
    }

    public static class IndependentNormal
    extends Base {
        public IndependentNormal(List<DataModel> dataModels, MultivariableHierarchicalMetaAnalysis.HierarchicalMetaAnalysisConfiguration cg) {
            super(dataModels);
            double mean = cg.muMean;
            double sd = cg.muSd;
            DistributionLikelihood likelihood = new DistributionLikelihood((Distribution)new NormalDistribution(mean, sd));
            for (Parameter p : this.betas) {
                likelihood.addData((Attribute)p);
            }
            this.distributions.add(likelihood);
        }

        @Override
        public List<MCMCOperator> getOperators(double weight, AdaptationMode mode) {
            return this.operators;
        }
    }

    public static class MultivariateNormal
    extends Base {
        public MultivariateNormal(List<DataModel> dataModels, MultivariableHierarchicalMetaAnalysis.HierarchicalMetaAnalysisConfiguration cg) {
            super(dataModels);
            int analysisDim = ((Parameter)this.betas.get(0)).getDimension();
            Parameter.Default mu = new Parameter.Default("mean", analysisDim, cg.startingMu);
            mu.addBounds((Bounds)new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, analysisDim));
            MatrixParameter tau2 = MultivariableHierarchicalMetaAnalysis.diagonalMatrixParameter("tau", analysisDim, cg.startingTau);
            MultivariateDistributionLikelihood hierarchy = new MultivariateDistributionLikelihood((MultivariateDistribution)new MultivariateNormalDistributionModel((Parameter)mu, tau2));
            for (Parameter beta : this.betas) {
                hierarchy.addData(beta);
            }
            double[] muPriorMean = new double[analysisDim];
            Arrays.fill(muPriorMean, cg.muMean);
            double muPriorPrecision = 1.0 / (cg.muSd * cg.muSd);
            MultivariateDistributionLikelihood meanPrior = new MultivariateDistributionLikelihood((MultivariateDistribution)new MultivariateNormalDistribution(muPriorMean, muPriorPrecision));
            meanPrior.addData((Parameter)mu);
            MultivariateDistributionLikelihood tau2Prior = new MultivariateDistributionLikelihood((MultivariateDistribution)new WishartDistribution(cg.tauDf, MultivariableHierarchicalMetaAnalysis.diagonalScaleMatrix(analysisDim, cg.tauScale)));
            tau2Prior.addData((Parameter)tau2);
            this.distributions.add(hierarchy);
            this.distributions.add(meanPrior);
            this.distributions.add(tau2Prior);
            this.parameters.add(mu);
            this.parameters.add(tau2);
            MultivariateNormalGibbsOperator meanOperator = null;
            try {
                meanOperator = new MultivariateNormalGibbsOperator(hierarchy, meanPrior, Double.valueOf(1.0));
            }
            catch (IllegalDimension e) {
                e.printStackTrace();
            }
            PrecisionMatrixGibbsOperator tau2Operator = new PrecisionMatrixGibbsOperator(hierarchy, (WishartStatistics)tau2Prior.getDistribution(), 1.0);
            this.operators.add(meanOperator);
            this.operators.add(tau2Operator);
        }

        @Override
        public List<MCMCOperator> getOperators(double weight, AdaptationMode mode) {
            return this.operators;
        }
    }
}

