/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.substmodel;

import dr.inference.model.Parameter;
import dr.inference.model.Statistic;
import dr.inference.model.Variable;
import dr.oldevomodel.substmodel.AbstractNucleotideModel;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodel.substmodel.NucModelType;
import dr.util.Author;
import dr.util.Citable;
import dr.util.Citation;
import java.util.Collections;
import java.util.List;

public class HKY
extends AbstractNucleotideModel
implements Citable {
    private double tsTv;
    private Variable<Double> kappaParameter = null;
    private boolean updateIntermediates = true;
    private double beta;
    private double A_R;
    private double A_Y;
    private double tab1A;
    private double tab2A;
    private double tab3A;
    private double tab1C;
    private double tab2C;
    private double tab3C;
    private double tab1G;
    private double tab2G;
    private double tab3G;
    private double tab1T;
    private double tab2T;
    private double tab3T;
    private final Statistic tsTvStatistic = new Statistic.Abstract(){

        @Override
        public String getStatisticName() {
            return "tsTv";
        }

        @Override
        public int getDimension() {
            return 1;
        }

        @Override
        public double getStatisticValue(int n) {
            return HKY.this.getTsTv();
        }
    };
    public static Citation CITATION = new Citation(new Author[]{new Author("M", "Hasegawa"), new Author("H", "Kishino"), new Author("T", "Yano")}, "Dating the human-ape splitting by a molecular clock of mitochondrial DNA", 1985, "Journal of Molecular Evolution", 22, 160, 174, Citation.Status.PUBLISHED);

    public HKY(double d, FrequencyModel frequencyModel) {
        this(new Parameter.Default(d), frequencyModel);
    }

    public HKY(Variable variable, FrequencyModel frequencyModel) {
        super(NucModelType.HKY.getXMLName(), frequencyModel);
        this.kappaParameter = variable;
        this.addVariable(variable);
        variable.addBounds(new Parameter.DefaultBounds(Double.POSITIVE_INFINITY, 0.0, 1));
        this.updateIntermediates = true;
        this.addStatistic(this.tsTvStatistic);
    }

    public void setKappa(double d) {
        this.kappaParameter.setValue(0, d);
        this.updateMatrix = true;
    }

    public final double getKappa() {
        return this.kappaParameter.getValue(0);
    }

    public void setTsTv(double d) {
        this.tsTv = d;
        this.calculateFreqRY();
        this.setKappa(d * this.freqR * this.freqY / (this.freqA * this.freqG + this.freqC * this.freqT));
    }

    public double getTsTv() {
        this.calculateFreqRY();
        this.tsTv = this.getKappa() * (this.freqA * this.freqG + this.freqC * this.freqT) / (this.freqR * this.freqY);
        return this.tsTv;
    }

    @Override
    protected void frequenciesChanged() {
        this.updateIntermediates = true;
    }

    private void calculateIntermediates() {
        this.calculateFreqRY();
        double d = 1.0 / this.freqR - 1.0;
        this.tab1A = this.freqA * d;
        this.tab3A = this.freqA / this.freqR;
        this.tab2A = 1.0 - this.tab3A;
        double d2 = 1.0 / d;
        this.tab1C = this.freqC * d2;
        this.tab3C = this.freqC / this.freqY;
        this.tab2C = 1.0 - this.tab3C;
        this.tab1G = this.freqG * d;
        this.tab3G = this.tab2A;
        this.tab2G = this.tab3A;
        this.tab1T = this.freqT * d2;
        this.tab3T = this.tab2C;
        this.tab2T = this.tab3C;
        this.updateMatrix = true;
        this.updateIntermediates = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getTransitionProbabilities(double d, double[] dArray) {
        HKY hKY = this;
        synchronized (hKY) {
            if (this.updateIntermediates) {
                this.calculateIntermediates();
            }
            if (this.updateMatrix) {
                this.setupMatrix();
            }
        }
        double d2 = this.beta * d;
        double d3 = Math.exp(d2 * this.A_R);
        double d4 = Math.exp(d2 * this.A_Y);
        double d5 = Math.exp(d2);
        double d6 = 1.0 - d5;
        double d7 = this.tab1A * d5;
        dArray[0] = this.freqA + d7 + this.tab2A * d3;
        dArray[1] = this.freqC * d6;
        double d8 = this.tab1G * d5;
        dArray[2] = this.freqG + d8 - this.tab3G * d3;
        dArray[3] = this.freqT * d6;
        dArray[4] = this.freqA * d6;
        double d9 = this.tab1C * d5;
        dArray[5] = this.freqC + d9 + this.tab2C * d4;
        dArray[6] = this.freqG * d6;
        double d10 = this.tab1T * d5;
        dArray[7] = this.freqT + d10 - this.tab3T * d4;
        dArray[8] = this.freqA + d7 - this.tab3A * d3;
        dArray[9] = dArray[1];
        dArray[10] = this.freqG + d8 + this.tab2G * d3;
        dArray[11] = dArray[3];
        dArray[12] = dArray[4];
        dArray[13] = this.freqC + d9 - this.tab3C * d4;
        dArray[14] = dArray[6];
        dArray[15] = this.freqT + d10 + this.tab2T * d4;
    }

    @Override
    public void setupMatrix() {
        double d = this.getKappa();
        this.beta = -1.0 / (2.0 * (this.freqR * this.freqY + d * (this.freqA * this.freqG + this.freqC * this.freqT)));
        this.A_R = 1.0 + this.freqR * (d - 1.0);
        this.A_Y = 1.0 + this.freqY * (d - 1.0);
        this.updateMatrix = false;
    }

    @Override
    protected void setupRelativeRates() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[][] getEigenVectors() {
        HKY hKY = this;
        synchronized (hKY) {
            if (this.updateMatrix) {
                this.setupEigenSystem();
            }
        }
        return this.Evec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[][] getInverseEigenVectors() {
        HKY hKY = this;
        synchronized (hKY) {
            if (this.updateMatrix) {
                this.setupEigenSystem();
            }
        }
        return this.Ievc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] getEigenValues() {
        HKY hKY = this;
        synchronized (hKY) {
            if (this.updateMatrix) {
                this.setupEigenSystem();
            }
        }
        return this.Eval;
    }

    protected void setupEigenSystem() {
        if (!this.eigenInitialised) {
            this.initialiseEigen();
        }
        double d = this.getKappa();
        this.Ievc[0][0] = this.freqA;
        this.Ievc[0][1] = this.freqC;
        this.Ievc[0][2] = this.freqG;
        this.Ievc[0][3] = this.freqT;
        this.Ievc[1][0] = this.freqA * this.freqY;
        this.Ievc[1][1] = -this.freqC * this.freqR;
        this.Ievc[1][2] = this.freqG * this.freqY;
        this.Ievc[1][3] = -this.freqT * this.freqR;
        this.Ievc[2][1] = 1.0;
        this.Ievc[2][3] = -1.0;
        this.Ievc[3][0] = 1.0;
        this.Ievc[3][2] = -1.0;
        this.Evec[0][0] = 1.0;
        this.Evec[1][0] = 1.0;
        this.Evec[2][0] = 1.0;
        this.Evec[3][0] = 1.0;
        this.Evec[0][1] = 1.0 / this.freqR;
        this.Evec[1][1] = -1.0 / this.freqY;
        this.Evec[2][1] = 1.0 / this.freqR;
        this.Evec[3][1] = -1.0 / this.freqY;
        this.Evec[1][2] = this.freqT / this.freqY;
        this.Evec[3][2] = -this.freqC / this.freqY;
        this.Evec[0][3] = this.freqG / this.freqR;
        this.Evec[2][3] = -this.freqA / this.freqR;
        this.beta = -1.0 / (2.0 * (this.freqR * this.freqY + d * (this.freqA * this.freqG + this.freqC * this.freqT)));
        this.A_R = 1.0 + this.freqR * (d - 1.0);
        this.A_Y = 1.0 + this.freqY * (d - 1.0);
        this.Eval[1] = this.beta;
        this.Eval[2] = this.beta * this.A_Y;
        this.Eval[3] = this.beta * this.A_R;
        this.updateMatrix = false;
    }

    @Override
    protected void initialiseEigen() {
        this.Eval = new double[this.stateCount];
        this.Evec = new double[this.stateCount][this.stateCount];
        this.Ievc = new double[this.stateCount][this.stateCount];
        this.eigenInitialised = true;
        this.updateMatrix = true;
    }

    @Override
    public void restoreState() {
        super.restoreState();
        this.updateIntermediates = true;
    }

    public String toXHTML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<em>HKY Model</em> Ts/Tv = ");
        stringBuffer.append(this.getTsTv());
        stringBuffer.append(" (kappa = ");
        stringBuffer.append(this.getKappa());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public Citation.Category getCategory() {
        return Citation.Category.SUBSTITUTION_MODELS;
    }

    @Override
    public String getDescription() {
        return "HKY nucleotide substitution model";
    }

    @Override
    public List<Citation> getCitations() {
        return Collections.singletonList(CITATION);
    }
}

