/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.protobuf;

import java.time.LocalDate;
import java.util.List;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.timeseries.regression.AdditiveOutlier;
import jdplus.toolkit.base.api.timeseries.regression.IOutlier;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.LevelShift;
import jdplus.toolkit.base.api.timeseries.regression.PeriodicOutlier;
import jdplus.toolkit.base.api.timeseries.regression.TransitoryChange;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.protobuf.modelling.ModellingProtos;
import jdplus.toolkit.base.protobuf.modelling.ModellingProtosUtility;
import jdplus.toolkit.base.protobuf.toolkit.ToolkitProtos;
import jdplus.toolkit.base.protobuf.toolkit.ToolkitProtosUtility;
import jdplus.tramoseats.base.api.tramo.CalendarSpec;
import jdplus.tramoseats.base.api.tramo.MeanSpec;
import jdplus.tramoseats.base.api.tramo.RegressionSpec;
import jdplus.tramoseats.base.protobuf.EasterProto;
import jdplus.tramoseats.base.protobuf.TradingDaysProto;
import jdplus.tramoseats.base.protobuf.TramoSpec;
import lombok.Generated;

public final class RegressionProto {
    public static RegressionSpec convert(TramoSpec.RegressionSpec spec, double tc) {
        ModellingProtos.TsVariable var;
        int i;
        Parameter p;
        CalendarSpec.Builder cbuilder = CalendarSpec.builder();
        if (spec.hasEaster()) {
            cbuilder.easter(EasterProto.convert(spec.getEaster()));
        }
        if (spec.hasTd()) {
            cbuilder.tradingDays(TradingDaysProto.convert(spec.getTd()));
        }
        MeanSpec mean = MeanSpec.none();
        if (spec.hasMean() && (p = ToolkitProtosUtility.convert((ToolkitProtos.Parameter)spec.getMean())) != null) {
            boolean check = spec.getCheckMean();
            mean = (MeanSpec)MeanSpec.builder().trendConstant(true).test(check).coefficient(ToolkitProtosUtility.convert((ToolkitProtos.Parameter)spec.getMean())).build();
        }
        RegressionSpec.Builder builder = RegressionSpec.builder().mean(mean).calendar((CalendarSpec)cbuilder.build());
        int n = spec.getOutliersCount();
        for (i = 0; i < n; ++i) {
            ModellingProtos.Outlier outlier = spec.getOutliers(i);
            builder.outlier(RegressionProto.convert(outlier, tc));
        }
        n = spec.getUsersCount();
        for (i = 0; i < n; ++i) {
            var = spec.getUsers(i);
            builder.userDefinedVariable(ModellingProtosUtility.convert((ModellingProtos.TsVariable)var));
        }
        n = spec.getInterventionsCount();
        for (i = 0; i < n; ++i) {
            var = spec.getInterventions(i);
            builder.interventionVariable(ModellingProtosUtility.convert((ModellingProtos.InterventionVariable)var));
        }
        n = spec.getRampsCount();
        for (i = 0; i < n; ++i) {
            var = spec.getRamps(i);
            builder.ramp(ModellingProtosUtility.convert((ModellingProtos.Ramp)var));
        }
        return (RegressionSpec)builder.build();
    }

    public static TramoSpec.RegressionSpec convert(RegressionSpec spec) {
        TramoSpec.RegressionSpec.Builder builder = TramoSpec.RegressionSpec.newBuilder().setEaster(EasterProto.convert(spec.getCalendar().getEaster())).setTd(TradingDaysProto.convert(spec.getCalendar().getTradingDays()));
        MeanSpec mean = spec.getMean();
        if (mean.isUsed()) {
            builder.setMean(ToolkitProtosUtility.convert((Parameter)mean.getCoefficient())).setCheckMean(mean.isTest());
        } else {
            builder.clearMean().setCheckMean(false);
        }
        List outliers = spec.getOutliers();
        outliers.forEach(outlier -> builder.addOutliers(RegressionProto.convert((Variable<IOutlier>)outlier)));
        List users = spec.getUserDefinedVariables();
        users.forEach(user -> builder.addUsers(ModellingProtosUtility.convertTsContextVariable((Variable)user)));
        List ivs = spec.getInterventionVariables();
        ivs.forEach(iv -> builder.addInterventions(ModellingProtosUtility.convertInterventionVariable((Variable)iv)));
        List ramps = spec.getRamps();
        ramps.forEach(ramp -> builder.addRamps(ModellingProtosUtility.convertRamp((Variable)ramp)));
        return builder.build();
    }

    public static Variable<IOutlier> convert(ModellingProtos.Outlier outlier, double tc) {
        Parameter[] parameterArray;
        AdditiveOutlier o;
        LocalDate ldt = ToolkitProtosUtility.convert((ToolkitProtos.Date)outlier.getPosition());
        switch (outlier.getCode()) {
            case "ao": 
            case "AO": {
                o = new AdditiveOutlier(ldt.atStartOfDay());
                break;
            }
            case "ls": 
            case "LS": {
                o = new LevelShift(ldt.atStartOfDay(), true);
                break;
            }
            case "tc": 
            case "TC": {
                o = new TransitoryChange(ldt.atStartOfDay(), tc);
                break;
            }
            case "so": 
            case "SO": {
                o = new PeriodicOutlier(ldt.atStartOfDay(), 0, true);
                break;
            }
            default: {
                return null;
            }
        }
        Parameter c = ToolkitProtosUtility.convert((ToolkitProtos.Parameter)outlier.getCoefficient());
        Variable.Builder builder = Variable.builder().core((ITsVariable)o).name(outlier.getName());
        if (c == null) {
            parameterArray = null;
        } else {
            Parameter[] parameterArray2 = new Parameter[1];
            parameterArray = parameterArray2;
            parameterArray2[0] = c;
        }
        return builder.coefficients(parameterArray).attributes(outlier.getMetadataMap()).build();
    }

    public static ModellingProtos.Outlier convert(Variable<IOutlier> v) {
        IOutlier outlier = (IOutlier)v.getCore();
        return ModellingProtos.Outlier.newBuilder().setName(v.getName()).setCode(outlier.getCode()).setPosition(ToolkitProtosUtility.convert((LocalDate)outlier.getPosition().toLocalDate())).setCoefficient(ToolkitProtosUtility.convert((Parameter)v.getCoefficient(0))).build();
    }

    @Generated
    private RegressionProto() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

