/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf;

import java.util.function.Consumer;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.ssf.ISsfInitialization;
import jdplus.toolkit.base.core.ssf.SsfException;

public class DefaultInitialization
implements ISsfInitialization {
    private final int dim;
    private final int ndiffuse;
    private Consumer<DataBlock> a0;
    private Consumer<FastMatrix> Pf;
    private Consumer<FastMatrix> Pi;
    private Consumer<FastMatrix> B;

    public DefaultInitialization(int dim, int ndiffuse) {
        this.dim = dim;
        this.ndiffuse = ndiffuse;
    }

    public DefaultInitialization a0(Consumer<DataBlock> a0) {
        this.a0 = a0;
        return this;
    }

    public DefaultInitialization Pf(Consumer<FastMatrix> Pf) {
        this.Pf = Pf;
        return this;
    }

    public DefaultInitialization Pi(Consumer<FastMatrix> Pi) {
        if (this.ndiffuse == 0) {
            throw new SsfException("Invalid initialization");
        }
        this.Pi = Pi;
        return this;
    }

    public DefaultInitialization B(Consumer<FastMatrix> B) {
        if (this.ndiffuse == 0) {
            throw new SsfException("Invalid initialization");
        }
        this.B = B;
        return this;
    }

    @Override
    public int getStateDim() {
        return this.dim;
    }

    @Override
    public boolean isDiffuse() {
        return this.ndiffuse > 0;
    }

    @Override
    public int getDiffuseDim() {
        return this.ndiffuse;
    }

    @Override
    public void diffuseConstraints(FastMatrix b) {
        if (this.B != null) {
            this.B.accept(b);
        }
    }

    @Override
    public void a0(DataBlock a) {
        if (this.a0 != null) {
            this.a0.accept(a);
        }
    }

    @Override
    public void Pf0(FastMatrix pf) {
        if (this.Pf != null) {
            this.Pf.accept(pf);
        }
    }

    @Override
    public void Pi0(FastMatrix pi) {
        if (this.Pi != null) {
            this.Pi.accept(pi);
        } else {
            ISsfInitialization.super.Pi0(pi);
        }
    }

    public String toString() {
        FastMatrix M;
        StringBuilder builder = new StringBuilder();
        if (this.a0 == null) {
            builder.append("a0:").append(System.lineSeparator()).append("0");
        } else {
            DataBlock a = DataBlock.make(this.dim);
            this.a0.accept(a);
            builder.append(a.toString("0.#####"));
        }
        builder.append(System.lineSeparator());
        if (this.Pf == null) {
            builder.append("Pf0:").append(System.lineSeparator()).append("0");
        } else {
            M = FastMatrix.square(this.dim);
            this.Pf.accept(M);
            builder.append(M.toString("0.#####"));
        }
        builder.append(System.lineSeparator());
        if (this.B == null) {
            builder.append("B:").append(System.lineSeparator()).append("0");
        } else {
            M = FastMatrix.make(this.dim, this.ndiffuse);
            this.B.accept(M);
            builder.append(M.toString("0.#####"));
        }
        return builder.toString();
    }
}

