% Generated by roxygen2: do not edit by hand
\name{eigen}
\alias{eigen}
\title{Eigenvalues and Eigenvectors of a Matrix}
\arguments{
  \item{x}{a square numeric or complex matrix}
  \item{symmetric}{logical. If TRUE, the algorithm will assume the matrix is symmetric (or Hermitian if complex) and will be faster. If not specified, the algorithm will attempt to determine if the matrix is symmetric.
}
}

\details{
Basic usage of \{.help [\{.fun eigen\}](base::eigen)\}
\code{
A <- matrix(rnorm(9), ncol = 3)
eigen_A <- eigen(A)
eigen_A$values   # eigenvalues
eigen_A$vectors  # eigenvectors
}

Compute eigenvectors and eigenvalues for a symmetric matrix
\code{
B <- matrix(c(1, 2, 1, 3), ncol = 2)
eigen_B <- eigen(B, symmetric = TRUE)
eigen_B$values   # eigenvalues
eigen_B$vectors  # eigenvectors
}

Checking that Av = λv for first eigenvalue/vector pair
\code{
eigen_A <- eigen(A)
lambda <- eigen_A$values[1]
v <- eigen_A$vectors[,1]
all.equal(A \%*\% v, lambda * v, tol = 1e-6)
}}

