/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramoseats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import jdplus.sa.base.api.ComponentType;
import jdplus.sa.base.api.EstimationPolicyType;
import jdplus.sa.base.api.SaDiagnosticsFactory;
import jdplus.sa.base.api.SaManager;
import jdplus.sa.base.api.SaProcessingFactory;
import jdplus.sa.base.api.SaProcessor;
import jdplus.sa.base.api.SaSpecification;
import jdplus.sa.base.core.diagnostics.AdvancedResidualSeasonalityDiagnosticsConfiguration;
import jdplus.sa.base.core.diagnostics.AdvancedResidualSeasonalityDiagnosticsFactory;
import jdplus.sa.base.core.diagnostics.CoherenceDiagnostics;
import jdplus.sa.base.core.diagnostics.CoherenceDiagnosticsConfiguration;
import jdplus.sa.base.core.diagnostics.CoherenceDiagnosticsFactory;
import jdplus.sa.base.core.diagnostics.CombinedSeasonalityDiagnosticsConfiguration;
import jdplus.sa.base.core.diagnostics.CombinedSeasonalityDiagnosticsFactory;
import jdplus.sa.base.core.diagnostics.ResidualTradingDaysDiagnostics;
import jdplus.sa.base.core.diagnostics.ResidualTradingDaysDiagnosticsConfiguration;
import jdplus.sa.base.core.diagnostics.ResidualTradingDaysDiagnosticsFactory;
import jdplus.sa.base.core.diagnostics.SaOutOfSampleDiagnosticsFactory;
import jdplus.sa.base.core.diagnostics.SaOutliersDiagnosticsFactory;
import jdplus.sa.base.core.diagnostics.SaResidualsDiagnosticsFactory;
import jdplus.sa.base.core.diagnostics.SpectralDiagnostics;
import jdplus.sa.base.core.diagnostics.SpectralDiagnosticsConfiguration;
import jdplus.sa.base.core.diagnostics.SpectralDiagnosticsFactory;
import jdplus.toolkit.base.api.arima.SarimaSpec;
import jdplus.toolkit.base.api.dictionaries.Dictionary;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.modelling.ComponentInformation;
import jdplus.toolkit.base.api.processing.AlgorithmDescriptor;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.regression.ITradingDaysVariable;
import jdplus.toolkit.base.core.modelling.GeneralLinearModel;
import jdplus.toolkit.base.core.regarima.diagnostics.OutOfSampleDiagnosticsConfiguration;
import jdplus.toolkit.base.core.regarima.diagnostics.OutliersDiagnosticsConfiguration;
import jdplus.toolkit.base.core.regarima.diagnostics.ResidualsDiagnosticsConfiguration;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModel;
import jdplus.tramoseats.base.api.seats.DecompositionSpec;
import jdplus.tramoseats.base.api.tramo.TramoSpec;
import jdplus.tramoseats.base.api.tramoseats.TramoSeatsDictionaries;
import jdplus.tramoseats.base.api.tramoseats.TramoSeatsSpec;
import jdplus.tramoseats.base.core.seats.SeatsResults;
import jdplus.tramoseats.base.core.seats.diagnostics.SeatsDiagnosticsConfiguration;
import jdplus.tramoseats.base.core.seats.diagnostics.SeatsDiagnosticsFactory;
import jdplus.tramoseats.base.core.tramo.TramoFactory;
import jdplus.tramoseats.base.core.tramoseats.TramoSeatsKernel;
import jdplus.tramoseats.base.core.tramoseats.TramoSeatsResults;

public final class TramoSeatsFactory
implements SaProcessingFactory<TramoSeatsSpec, TramoSeatsResults> {
    private final List<SaDiagnosticsFactory<?, TramoSeatsResults>> diagnostics = new CopyOnWriteArrayList();

    public static TramoSeatsFactory getInstance() {
        return (TramoSeatsFactory)SaManager.processors().stream().filter(x -> x instanceof TramoSeatsFactory).findAny().orElse(new TramoSeatsFactory());
    }

    public TramoSeatsFactory() {
        this.diagnostics.addAll(TramoSeatsFactory.defaultDiagnostics());
    }

    public static List<SaDiagnosticsFactory<?, TramoSeatsResults>> defaultDiagnostics() {
        CoherenceDiagnosticsFactory coherence = new CoherenceDiagnosticsFactory(CoherenceDiagnosticsConfiguration.getDefault(), r -> r.getFinals() == null ? null : new CoherenceDiagnostics.Input(r.getFinals().getMode(), (Explorable)r));
        SaOutOfSampleDiagnosticsFactory outofsample = new SaOutOfSampleDiagnosticsFactory(OutOfSampleDiagnosticsConfiguration.getDefault(), r -> r.getDiagnostics() == null ? null : r.getDiagnostics().getGenericDiagnostics().forecastingTest());
        SaResidualsDiagnosticsFactory residuals = new SaResidualsDiagnosticsFactory(ResidualsDiagnosticsConfiguration.getDefault(), r -> r.getPreprocessing());
        SaOutliersDiagnosticsFactory outliers = new SaOutliersDiagnosticsFactory(OutliersDiagnosticsConfiguration.getDefault(), r -> r.getPreprocessing());
        SpectralDiagnosticsFactory spectral = new SpectralDiagnosticsFactory(SpectralDiagnosticsConfiguration.getDefault(), r -> {
            SeatsResults sd = r.getDecomposition();
            if (sd == null) {
                return null;
            }
            return new SpectralDiagnostics.Input(r.getDecomposition().getFinalComponents().getMode(), sd.getFinalComponents().getSeries(ComponentType.Series, ComponentInformation.Value), sd.getFinalComponents().getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Value));
        });
        SeatsDiagnosticsFactory<TramoSeatsResults> seats = new SeatsDiagnosticsFactory<TramoSeatsResults>(SeatsDiagnosticsConfiguration.getDefault(), r -> r.getDiagnostics() == null ? null : r.getDiagnostics().getSpecificDiagnostics());
        AdvancedResidualSeasonalityDiagnosticsFactory advancedResidualSeasonality = new AdvancedResidualSeasonalityDiagnosticsFactory(AdvancedResidualSeasonalityDiagnosticsConfiguration.getDefault(), r -> r.getDiagnostics() == null ? null : r.getDiagnostics().getGenericDiagnostics());
        CombinedSeasonalityDiagnosticsFactory combinedSeasonality = new CombinedSeasonalityDiagnosticsFactory(CombinedSeasonalityDiagnosticsConfiguration.getDefault(), r -> r.getDiagnostics() == null ? null : r.getDiagnostics().getGenericDiagnostics());
        ResidualTradingDaysDiagnosticsFactory residualTradingDays = new ResidualTradingDaysDiagnosticsFactory(ResidualTradingDaysDiagnosticsConfiguration.getDefault(), r -> {
            RegSarimaModel preprocessing = r.getPreprocessing();
            boolean td = false;
            if (preprocessing != null) {
                td = Arrays.stream(preprocessing.getDescription().getVariables()).anyMatch(v -> v.getCore() instanceof ITradingDaysVariable);
            }
            return r.getDiagnostics() == null ? null : new ResidualTradingDaysDiagnostics.Input(r.getDiagnostics().getGenericDiagnostics().residualTradingDaysTests(), td);
        });
        ArrayList all = new ArrayList();
        all.add((SaDiagnosticsFactory<?, TramoSeatsResults>)coherence);
        all.add((SaDiagnosticsFactory<?, TramoSeatsResults>)residuals);
        all.add((SaDiagnosticsFactory<?, TramoSeatsResults>)outofsample);
        all.add((SaDiagnosticsFactory<?, TramoSeatsResults>)outliers);
        all.add((SaDiagnosticsFactory<?, TramoSeatsResults>)spectral);
        all.add(seats);
        all.add((SaDiagnosticsFactory<?, TramoSeatsResults>)combinedSeasonality);
        all.add((SaDiagnosticsFactory<?, TramoSeatsResults>)advancedResidualSeasonality);
        all.add((SaDiagnosticsFactory<?, TramoSeatsResults>)residualTradingDays);
        return all;
    }

    public AlgorithmDescriptor descriptor() {
        return TramoSeatsSpec.DESCRIPTOR_V3;
    }

    public TramoSeatsSpec generateSpec(TramoSeatsSpec spec, TramoSeatsResults estimation) {
        if (!estimation.isValid()) {
            return null;
        }
        return this.generateSpec(spec, (GeneralLinearModel.Description<SarimaSpec>)estimation.getPreprocessing().getDescription());
    }

    public TramoSeatsSpec generateSpec(TramoSeatsSpec spec, GeneralLinearModel.Description<SarimaSpec> desc) {
        TramoSpec ntspec = TramoFactory.getInstance().generateSpec(spec.getTramo(), desc);
        DecompositionSpec nsspec = this.update(spec.getSeats());
        return (TramoSeatsSpec)spec.toBuilder().tramo(ntspec).seats(nsspec).build();
    }

    public TramoSeatsSpec refreshSpec(TramoSeatsSpec currentSpec, TramoSeatsSpec domainSpec, EstimationPolicyType policy, TsDomain domain) {
        if (policy == EstimationPolicyType.None) {
            return currentSpec;
        }
        if (policy == EstimationPolicyType.Complete) {
            return domainSpec;
        }
        TramoSpec ntspec = TramoFactory.getInstance().refreshSpec(currentSpec.getTramo(), domainSpec.getTramo(), policy, domain);
        return (TramoSeatsSpec)currentSpec.toBuilder().tramo(ntspec).build();
    }

    private DecompositionSpec update(DecompositionSpec seats) {
        return seats;
    }

    public SaProcessor processor(TramoSeatsSpec spec) {
        return (s, cxt, log) -> TramoSeatsKernel.of(spec, cxt).process(s, log);
    }

    public TramoSeatsSpec decode(SaSpecification spec) {
        if (spec instanceof TramoSeatsSpec) {
            return (TramoSeatsSpec)spec;
        }
        return null;
    }

    public boolean canHandle(SaSpecification spec) {
        return spec instanceof TramoSeatsSpec;
    }

    public List<SaDiagnosticsFactory<?, TramoSeatsResults>> diagnosticFactories() {
        return Collections.unmodifiableList(this.diagnostics);
    }

    public void addDiagnostics(SaDiagnosticsFactory<?, TramoSeatsResults> diag) {
        this.diagnostics.add(diag);
    }

    public void replaceDiagnostics(SaDiagnosticsFactory<?, TramoSeatsResults> olddiag, SaDiagnosticsFactory<?, TramoSeatsResults> newdiag) {
        int idx = this.diagnostics.indexOf(olddiag);
        if (idx < 0) {
            this.diagnostics.add(newdiag);
        } else {
            this.diagnostics.set(idx, newdiag);
        }
    }

    public void resetDiagnosticFactories(List<SaDiagnosticsFactory<?, TramoSeatsResults>> factories) {
        this.diagnostics.clear();
        this.diagnostics.addAll(factories);
    }

    public Dictionary outputDictionary() {
        return TramoSeatsDictionaries.TRAMOSEATSDICTIONARY;
    }
}

