/*
 * Decompiled with CFR 0.152.
 */
package jdplus.tramoseats.base.core.tramo;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.matrices.Matrix;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.regression.ITradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.ModellingUtility;
import jdplus.toolkit.base.api.timeseries.regression.Variable;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.modelling.regression.Regression;
import jdplus.toolkit.base.core.regsarima.regular.ModelDescription;
import jdplus.toolkit.base.core.regsarima.regular.ProcessingResult;
import jdplus.toolkit.base.core.regsarima.regular.RegSarimaModelling;
import jdplus.toolkit.base.core.stats.linearmodel.LeastSquaresResults;
import jdplus.toolkit.base.core.stats.linearmodel.LinearModel;
import jdplus.toolkit.base.core.stats.linearmodel.Ols;
import jdplus.tramoseats.base.core.tramo.ModelComparator;
import jdplus.tramoseats.base.core.tramo.ModelController;
import jdplus.tramoseats.base.core.tramo.TramoContext;
import jdplus.tramoseats.base.core.tramo.TramoModelBuilder;

class TradingDaysController
extends ModelController {
    private final ITradingDaysVariable td;
    private double ptd = 0.01;

    TradingDaysController(ITradingDaysVariable td, double ptd) {
        this.td = td;
        this.ptd = ptd;
    }

    @Override
    ProcessingResult process(RegSarimaModelling modelling, TramoContext context) {
        ModelDescription desc = modelling.getDescription();
        boolean hascal = desc.variables().anyMatch(var -> ModellingUtility.isAutomaticallyIdentified((Variable)var) && ModellingUtility.isDaysRelated((Variable)var));
        if (hascal) {
            return ProcessingResult.Unchanged;
        }
        if (!this.needProcessing(modelling)) {
            return ProcessingResult.Unchanged;
        }
        ModelDescription nmodel = this.newModel(modelling);
        nmodel.removeVariable(var -> ModellingUtility.isOutlier((Variable)var, (boolean)true));
        RegSarimaModelling ncontext = RegSarimaModelling.of((ModelDescription)nmodel);
        if (!this.estimate(ncontext, true)) {
            return ProcessingResult.Failed;
        }
        ModelComparator mcmp = ModelComparator.builder().build();
        int cmp = mcmp.compare(modelling, ncontext);
        if (cmp < 1) {
            return ProcessingResult.Unchanged;
        }
        this.transferInformation(ncontext, modelling);
        return ProcessingResult.Changed;
    }

    private boolean needProcessing(RegSarimaModelling context) {
        LinearModel lm;
        LeastSquaresResults lsr;
        DoubleSeq res = context.getEstimation().getConcentratedLikelihood().e();
        LinearModel.Builder builder = LinearModel.builder();
        builder.y(res);
        TsDomain domain = context.getDescription().getEstimationDomain();
        domain = domain.drop(domain.getLength() - res.length(), 0);
        if (this.td != null) {
            FastMatrix mtd = Regression.matrix((TimeSeriesDomain)domain, (ITsVariable[])new ITsVariable[]{this.td});
            builder.addX((Matrix)mtd);
        }
        if ((lsr = Ols.compute((LinearModel)(lm = builder.build()))) == null) {
            return false;
        }
        return lsr.Ftest().getPvalue() < this.ptd;
    }

    private ModelDescription newModel(RegSarimaModelling context) {
        ModelDescription ndesc = ModelDescription.copyOf((ModelDescription)context.getDescription());
        ndesc.removeVariable(var -> ModellingUtility.isDaysRelated((Variable)var));
        ndesc.addVariable(Variable.variable((String)"td", (ITsVariable)this.td, TramoModelBuilder.calendarAMI));
        return ndesc;
    }
}

