/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.binary;

import java.io.InputStream;
import java.util.Queue;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.ExcelNumberFormat;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;
import org.apache.poi.xssf.binary.XSSFBCellHeader;
import org.apache.poi.xssf.binary.XSSFBCellRange;
import org.apache.poi.xssf.binary.XSSFBComment;
import org.apache.poi.xssf.binary.XSSFBCommentsTable;
import org.apache.poi.xssf.binary.XSSFBHeaderFooter;
import org.apache.poi.xssf.binary.XSSFBHeaderFooters;
import org.apache.poi.xssf.binary.XSSFBParseException;
import org.apache.poi.xssf.binary.XSSFBParser;
import org.apache.poi.xssf.binary.XSSFBRecordType;
import org.apache.poi.xssf.binary.XSSFBStylesTable;
import org.apache.poi.xssf.binary.XSSFBUtils;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.usermodel.XSSFComment;

@Internal
public class XSSFBSheetHandler
extends XSSFBParser {
    private static final int CHECK_ALL_ROWS = -1;
    private final SharedStrings stringsTable;
    private final XSSFBSheetContentsHandler handler;
    private final XSSFBStylesTable styles;
    private final XSSFBCommentsTable comments;
    private final boolean formulasNotResults;
    private int lastEndedRow = -1;
    private int lastStartedRow = -1;
    private int currentRow;
    private byte[] rkBuffer = new byte[8];
    private XSSFBCellRange hyperlinkCellRange;
    private StringBuilder xlWideStringBuffer = new StringBuilder();
    private final XSSFBCellHeader cellBuffer = new XSSFBCellHeader();

    public XSSFBSheetHandler(InputStream is, XSSFBStylesTable styles, XSSFBCommentsTable comments, SharedStrings strings, XSSFBSheetContentsHandler sheetContentsHandler, boolean formulasNotResults) {
        super(is);
        this.styles = styles;
        this.comments = comments;
        this.stringsTable = strings;
        this.handler = sheetContentsHandler;
        this.formulasNotResults = formulasNotResults;
    }

    public XSSFBSheetHandler(InputStream is, XSSFBStylesTable styles, XSSFBCommentsTable comments, SharedStrings strings, XSSFSheetXMLHandler.SheetContentsHandler sheetContentsHandler, DataFormatter dataFormatter, boolean formulasNotResults) {
        super(is);
        this.styles = styles;
        this.comments = comments;
        this.stringsTable = strings;
        this.handler = new XSSFBSheetContentsHandlerWrapper(sheetContentsHandler, dataFormatter);
        this.formulasNotResults = formulasNotResults;
    }

    @Override
    public void handleRecord(int id, byte[] data) throws XSSFBParseException {
        XSSFBRecordType type = XSSFBRecordType.lookup(id);
        switch (type) {
            case BrtRowHdr: {
                int rw = XSSFBUtils.castToInt(LittleEndian.getUInt((byte[])data, (int)0));
                if (rw > 0x100000) {
                    throw new XSSFBParseException("Row number beyond allowable range: " + rw);
                }
                this.currentRow = rw;
                this.checkMissedComments(this.currentRow);
                this.startRow(this.currentRow);
                break;
            }
            case BrtCellIsst: {
                this.handleBrtCellIsst(data);
                break;
            }
            case BrtCellSt: {
                this.handleCellSt(data);
                break;
            }
            case BrtCellRk: {
                this.handleCellRk(data);
                break;
            }
            case BrtCellReal: {
                this.handleCellReal(data);
                break;
            }
            case BrtCellBool: 
            case BrtFmlaBool: {
                this.handleBoolean(data);
                break;
            }
            case BrtCellError: {
                this.handleCellError(data);
                break;
            }
            case BrtCellBlank: {
                this.beforeCellValue(data);
                break;
            }
            case BrtFmlaString: {
                this.handleFmlaString(data);
                break;
            }
            case BrtFmlaNum: {
                this.handleFmlaNum(data);
                break;
            }
            case BrtFmlaError: {
                this.handleFmlaError(data);
                break;
            }
            case BrtEndSheetData: {
                this.checkMissedComments(-1);
                this.endRow(this.lastStartedRow);
                break;
            }
            case BrtBeginHeaderFooter: {
                this.handleHeaderFooter(data);
            }
        }
    }

    private void beforeCellValue(byte[] data) {
        XSSFBCellHeader.parse(data, 0, this.currentRow, this.cellBuffer);
        this.checkMissedComments(this.currentRow, this.cellBuffer.getColNum());
    }

    private void handleStringCellValue(String val) {
        CellAddress cellAddress = this.getCellAddress();
        XSSFBComment comment = this.getCellComment(cellAddress);
        this.handler.stringCell(cellAddress.formatAsString(), val, comment);
    }

    private void handleDoubleCellValue(double val) {
        CellAddress cellAddress = this.getCellAddress();
        XSSFBComment comment = this.getCellComment(cellAddress);
        ExcelNumberFormat nf = this.getExcelNumberFormat();
        this.handler.doubleCell(cellAddress.formatAsString(), val, comment, nf);
    }

    private void handleErrorCellValue(int val) {
        FormulaError fe;
        try {
            fe = FormulaError.forInt((int)val);
        }
        catch (IllegalArgumentException e) {
            fe = null;
        }
        CellAddress cellAddress = this.getCellAddress();
        XSSFBComment comment = this.getCellComment(cellAddress);
        this.handler.errorCell(cellAddress.formatAsString(), fe, comment);
    }

    private CellAddress getCellAddress() {
        return new CellAddress(this.currentRow, this.cellBuffer.getColNum());
    }

    private XSSFBComment getCellComment(CellAddress cellAddress) {
        XSSFBComment comment = null;
        if (this.comments != null) {
            comment = this.comments.get(cellAddress);
        }
        return comment;
    }

    private ExcelNumberFormat getExcelNumberFormat() {
        int styleIdx = this.cellBuffer.getStyleIdx();
        String formatString = this.styles.getNumberFormatString(styleIdx);
        short styleIndex = this.styles.getNumberFormatIndex(styleIdx);
        if (formatString == null) {
            formatString = BuiltinFormats.getBuiltinFormat((int)0);
            styleIndex = 0;
        }
        return new ExcelNumberFormat((int)styleIndex, formatString);
    }

    private void handleFmlaNum(byte[] data) {
        this.beforeCellValue(data);
        double val = LittleEndian.getDouble((byte[])data, (int)8);
        this.handleDoubleCellValue(val);
    }

    private void handleCellSt(byte[] data) {
        this.beforeCellValue(data);
        this.xlWideStringBuffer.setLength(0);
        XSSFBUtils.readXLWideString(data, 8, this.xlWideStringBuffer);
        this.handleStringCellValue(this.xlWideStringBuffer.toString());
    }

    private void handleFmlaString(byte[] data) {
        this.beforeCellValue(data);
        this.xlWideStringBuffer.setLength(0);
        XSSFBUtils.readXLWideString(data, 8, this.xlWideStringBuffer);
        this.handleStringCellValue(this.xlWideStringBuffer.toString());
    }

    private void handleCellError(byte[] data) {
        this.beforeCellValue(data);
        int val = data[8] & 0xFF;
        this.handleErrorCellValue(val);
    }

    private void handleFmlaError(byte[] data) {
        this.beforeCellValue(data);
        int val = data[8] & 0xFF;
        this.handleErrorCellValue(val);
    }

    private void handleBoolean(byte[] data) {
        this.beforeCellValue(data);
        boolean val = data[8] == 1;
        CellAddress cellAddress = this.getCellAddress();
        XSSFBComment comment = this.getCellComment(cellAddress);
        this.handler.booleanCell(cellAddress.formatAsString(), val, comment);
    }

    private void handleCellReal(byte[] data) {
        this.beforeCellValue(data);
        double val = LittleEndian.getDouble((byte[])data, (int)8);
        this.handleDoubleCellValue(val);
    }

    private void handleCellRk(byte[] data) {
        this.beforeCellValue(data);
        double val = this.rkNumber(data, 8);
        this.handleDoubleCellValue(val);
    }

    private void handleBrtCellIsst(byte[] data) {
        this.beforeCellValue(data);
        int idx = XSSFBUtils.castToInt(LittleEndian.getUInt((byte[])data, (int)8));
        RichTextString rtss = this.stringsTable.getItemAt(idx);
        this.handleStringCellValue(rtss.getString());
    }

    private void handleHeaderFooter(byte[] data) {
        XSSFBHeaderFooters headerFooter = XSSFBHeaderFooters.parse(data);
        this.outputHeaderFooter(headerFooter.getHeader());
        this.outputHeaderFooter(headerFooter.getFooter());
        this.outputHeaderFooter(headerFooter.getHeaderEven());
        this.outputHeaderFooter(headerFooter.getFooterEven());
        this.outputHeaderFooter(headerFooter.getHeaderFirst());
        this.outputHeaderFooter(headerFooter.getFooterFirst());
    }

    private void outputHeaderFooter(XSSFBHeaderFooter headerFooter) {
        String text = headerFooter.getString();
        if (StringUtil.isNotBlank((CharSequence)text)) {
            this.handler.headerFooter(text, headerFooter.isHeader(), headerFooter.getHeaderFooterTypeLabel());
        }
    }

    private void checkMissedComments(int currentRow, int colNum) {
        if (this.comments == null) {
            return;
        }
        Queue<CellAddress> queue = this.comments.getAddresses();
        while (!queue.isEmpty()) {
            CellAddress cellAddress = queue.peek();
            if (cellAddress.getRow() == currentRow && cellAddress.getColumn() < colNum) {
                cellAddress = queue.remove();
                this.dumpEmptyCellComment(cellAddress, this.comments.get(cellAddress));
                continue;
            }
            if (cellAddress.getRow() == currentRow && cellAddress.getColumn() == colNum) {
                queue.remove();
                return;
            }
            if (cellAddress.getRow() == currentRow && cellAddress.getColumn() > colNum) {
                return;
            }
            if (cellAddress.getRow() <= currentRow) continue;
            return;
        }
    }

    private void checkMissedComments(int currentRow) {
        if (this.comments == null) {
            return;
        }
        Queue<CellAddress> queue = this.comments.getAddresses();
        int lastInterpolatedRow = -1;
        while (!queue.isEmpty()) {
            CellAddress cellAddress = queue.peek();
            if (currentRow != -1 && cellAddress.getRow() >= currentRow) break;
            cellAddress = queue.remove();
            if (cellAddress.getRow() != lastInterpolatedRow) {
                this.startRow(cellAddress.getRow());
            }
            this.dumpEmptyCellComment(cellAddress, this.comments.get(cellAddress));
            lastInterpolatedRow = cellAddress.getRow();
        }
    }

    private void startRow(int row) {
        if (row == this.lastStartedRow) {
            return;
        }
        if (this.lastStartedRow != this.lastEndedRow) {
            this.endRow(this.lastStartedRow);
        }
        this.handler.startRow(row);
        this.lastStartedRow = row;
    }

    private void endRow(int row) {
        if (this.lastEndedRow == row) {
            return;
        }
        this.handler.endRow(row);
        this.lastEndedRow = row;
    }

    private void dumpEmptyCellComment(CellAddress cellAddress, XSSFBComment comment) {
        this.handler.stringCell(cellAddress.formatAsString(), null, comment);
    }

    private double rkNumber(byte[] data, int offset) {
        byte b0 = data[offset];
        boolean numDivBy100 = (b0 & 1) == 1;
        boolean floatingPoint = (b0 >> 1 & 1) == 0;
        b0 = (byte)(b0 & 0xFFFFFFFE);
        this.rkBuffer[4] = b0 = (byte)(b0 & 0xFFFFFFFD);
        System.arraycopy(data, offset + 1, this.rkBuffer, 5, 3);
        double d = 0.0;
        if (floatingPoint) {
            d = LittleEndian.getDouble((byte[])this.rkBuffer);
        } else {
            int rawInt = LittleEndian.getInt((byte[])this.rkBuffer, (int)4);
            d = rawInt >> 2;
        }
        d = numDivBy100 ? d / 100.0 : d;
        return d;
    }

    public static interface SheetContentsHandler
    extends XSSFSheetXMLHandler.SheetContentsHandler {
        public void hyperlinkCell(String var1, String var2, String var3, String var4, XSSFComment var5);
    }

    private final class XSSFBSheetContentsHandlerWrapper
    implements XSSFBSheetContentsHandler {
        private final XSSFSheetXMLHandler.SheetContentsHandler delegate;
        private final DataFormatter dataFormatter;

        XSSFBSheetContentsHandlerWrapper(XSSFSheetXMLHandler.SheetContentsHandler delegate, DataFormatter dataFormatter) {
            this.delegate = delegate;
            this.dataFormatter = dataFormatter;
        }

        @Override
        public void startRow(int rowNum) {
            this.delegate.startRow(rowNum);
        }

        @Override
        public void endRow(int rowNum) {
            this.delegate.endRow(rowNum);
        }

        @Override
        public void stringCell(String cellReference, String value, XSSFComment comment) {
            this.delegate.cell(cellReference, value, comment);
        }

        @Override
        public void doubleCell(String cellReference, double value, XSSFComment comment, ExcelNumberFormat nf) {
            String formattedValue = this.dataFormatter.formatRawCellContents(value, nf.getIdx(), nf.getFormat());
            this.delegate.cell(cellReference, formattedValue, comment);
        }

        @Override
        public void booleanCell(String cellReference, boolean value, XSSFComment comment) {
            this.delegate.cell(cellReference, Boolean.toString(value), comment);
        }

        @Override
        public void errorCell(String cellReference, FormulaError fe, XSSFComment comment) {
            this.delegate.cell(cellReference, "ERROR", comment);
        }

        @Override
        public void headerFooter(String text, boolean isHeader, String tagName) {
            this.delegate.headerFooter(text, isHeader, tagName);
        }

        @Override
        public void endSheet() {
            this.delegate.endSheet();
        }
    }

    public static interface XSSFBSheetContentsHandler {
        public void startRow(int var1);

        public void endRow(int var1);

        public void stringCell(String var1, String var2, XSSFComment var3);

        public void doubleCell(String var1, double var2, XSSFComment var4, ExcelNumberFormat var5);

        public void booleanCell(String var1, boolean var2, XSSFComment var3);

        public void errorCell(String var1, FormulaError var2, XSSFComment var3);

        public void headerFooter(String var1, boolean var2, String var3);

        public void endSheet();
    }
}

