/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.modelling.extractors;

import jdplus.toolkit.base.api.information.InformationMapping;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodStatistics;

public class LikelihoodStatisticsExtractor
extends InformationMapping<LikelihoodStatistics> {
    public LikelihoodStatisticsExtractor() {
        this.set("ll", Double.class, source -> source.getLogLikelihood());
        this.set("adjustedll", Double.class, source -> source.getAdjustedLogLikelihood());
        this.set("ssqerr", Double.class, source -> source.getSsqErr());
        this.set("nparams", Integer.class, source -> source.getEstimatedParametersCount());
        this.set("nobs", Integer.class, source -> source.getObservationsCount());
        this.set("neffectiveobs", Integer.class, source -> source.getEffectiveObservationsCount());
        this.set("df", Integer.class, source -> source.getEffectiveObservationsCount() - source.getEstimatedParametersCount());
        this.set("aic", Double.class, source -> source.getAIC());
        this.set("aicc", Double.class, source -> source.getAICC());
        this.set("bic", Double.class, source -> source.getBIC());
        this.set("bicc", Double.class, source -> source.getBICC());
        this.set("bic2", Double.class, source -> source.getBIC2());
        this.set("hannanquinn", Double.class, source -> source.getHannanQuinn());
    }

    public Class getSourceClass() {
        return LikelihoodStatistics.class;
    }
}

