/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.math.linearfilters;

import java.util.function.IntToDoubleFunction;
import jdplus.toolkit.base.api.math.Complex;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.ComplexUtility;
import jdplus.toolkit.base.core.math.linearfilters.BackFilter;
import jdplus.toolkit.base.core.math.linearfilters.SymmetricFilter;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.decomposition.EigenSystem;
import jdplus.toolkit.base.core.math.matrices.decomposition.IEigenSystem;
import jdplus.toolkit.base.core.math.polynomials.LeastSquaresDivision;
import jdplus.toolkit.base.core.math.polynomials.Polynomial;
import jdplus.toolkit.base.core.math.polynomials.UnitRoots;
import jdplus.toolkit.base.core.math.polynomials.UnitRootsSolver;

public class EigenValuesDecomposer {
    private double fac;
    private BackFilter bf;
    private static final double EPS = 1.0E-9;

    public BackFilter getBFilter() {
        return this.bf;
    }

    public double getFactor() {
        return this.fac;
    }

    public boolean decompose(SymmetricFilter sf) {
        try {
            IntToDoubleFunction weights = sf.weights();
            double var = weights.applyAsDouble(0);
            if (var < 0.0) {
                return false;
            }
            if (sf.length() == 1) {
                this.bf = BackFilter.ONE;
                this.fac = var;
            } else {
                double[] w = sf.weightsToArray();
                int i = 0;
                while (i < w.length) {
                    int n = i++;
                    w[n] = w[n] / var;
                }
                Polynomial P = Polynomial.of(w);
                P = this.removeUnitRoots(P);
                w = P.toArray();
                int n = P.degree();
                if (n > 0) {
                    FastMatrix M = FastMatrix.square(n + 1);
                    M.subDiagonal(-1).drop(0, 1).set(1.0);
                    DataBlock col = M.column(n - 1).drop(0, 1);
                    col.setAY(-1.0 / w[n], DataBlock.of(w, 0, n));
                    M.set(0, n, 1.0);
                    IEigenSystem es = EigenSystem.create(M, false);
                    Complex[] vals = es.getEigenValues();
                    Complex[] nvals = new Complex[vals.length / 2];
                    int j = 0;
                    for (int i2 = 0; i2 < vals.length; ++i2) {
                        Complex cur = vals[i2];
                        if (cur.equals(Complex.ZERO, 1.0E-9) || !(cur.abs() > 1.0)) continue;
                        nvals[j++] = vals[i2];
                    }
                    ComplexUtility.lejaOrder(nvals);
                    Polynomial Z = Polynomial.fromComplexRoots(nvals);
                    Z = Z.times(1.0 / Z.get(0));
                    this.bf = this.bf.times(new BackFilter(Z));
                }
            }
            this.fac = var / this.bf.asPolynomial().coefficients().ssq();
            return true;
        }
        catch (Exception err) {
            return false;
        }
    }

    private Polynomial removeUnitRoots(Polynomial P) {
        UnitRoots ur;
        UnitRoots sur;
        UnitRootsSolver urs = new UnitRootsSolver(0);
        if (urs.factorize(P) && (sur = (ur = urs.getUnitRoots()).sqrt()) != null) {
            Polynomial urp = sur.asPolynomial();
            Polynomial ur2 = urp.times(urp);
            this.bf = new BackFilter(urp);
            LeastSquaresDivision lsd = new LeastSquaresDivision();
            lsd.divide(P, ur2);
            P = lsd.getQuotient();
            double[] c = P.toArray();
            int d = P.degree();
            int n = d / 2;
            for (int i = 0; i < n; ++i) {
                double q;
                c[i] = q = (c[i] + c[d - i]) / 2.0;
                c[d - i] = q;
            }
            P = Polynomial.of(c);
        }
        if (this.bf == null) {
            this.bf = BackFilter.ONE;
        }
        return P;
    }
}

