/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.core.tests;

import jdplus.sa.base.api.diagnostics.CombinedSeasonalityTest;
import jdplus.sa.base.core.tests.EvolutiveSeasonality;
import jdplus.sa.base.core.tests.KruskalWallis;
import jdplus.sa.base.core.tests.StableSeasonality;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.stats.OneWayAnova;
import jdplus.toolkit.base.api.stats.StatisticalTest;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.core.stats.tests.TestsUtility;

public class CombinedSeasonality {
    private double thfs = 0.001;
    private double thfm = 0.05;
    private double thkw = 0.001;
    private final OneWayAnova stable;
    private final OneWayAnova evolutive;
    private final KruskalWallis kruskalWallis;

    public static CombinedSeasonality of(TsData s, double xbar) {
        TsPeriod start = s.getStart();
        return new CombinedSeasonality(s.getValues(), start.annualFrequency(), start.annualPosition(), xbar);
    }

    public CombinedSeasonality(DoubleSeq series, int period, int startPeriod, double xbar) {
        this.kruskalWallis = new KruskalWallis(series, period);
        this.stable = StableSeasonality.of(series, period);
        this.evolutive = EvolutiveSeasonality.of(series, period, startPeriod, xbar);
    }

    public OneWayAnova getEvolutiveSeasonalityTest() {
        return this.evolutive;
    }

    public double getMovingSeasonalityAcceptanceLevel() {
        return this.thfm;
    }

    public double getNonParametricAcceptanceLevel() {
        return this.thkw;
    }

    public KruskalWallis getNonParametricTestForStableSeasonality() {
        return this.kruskalWallis;
    }

    public OneWayAnova getStableSeasonalityTest() {
        return this.stable;
    }

    public double getStableSeasonalityAcceptanceLevel() {
        return this.thfs;
    }

    public CombinedSeasonalityTest.IdentifiableSeasonality getSummary() {
        double T;
        double T2;
        StatisticalTest stest = TestsUtility.ofAnova((OneWayAnova)this.stable);
        StatisticalTest etest = TestsUtility.ofAnova((OneWayAnova)this.evolutive);
        double ps = stest.getPvalue();
        double pm = etest.getPvalue();
        if (ps >= this.thfs) {
            return CombinedSeasonalityTest.IdentifiableSeasonality.None;
        }
        boolean resfm = pm < this.thfm;
        double fs = stest.getValue();
        double fm = etest.getValue();
        double T1 = 7.0 / fs;
        double d = T2 = fs == 0.0 ? 9.0 : 3.0 * fm / fs;
        if (T1 > 9.0) {
            T1 = 9.0;
        }
        if (T2 > 9.0) {
            T2 = 9.0;
        }
        if (resfm && (T = Math.sqrt((T1 + T2) / 2.0)) >= 1.0) {
            return CombinedSeasonalityTest.IdentifiableSeasonality.None;
        }
        if (T1 >= 1.0 || T2 >= 1.0) {
            return CombinedSeasonalityTest.IdentifiableSeasonality.ProbablyNone;
        }
        if (this.kruskalWallis.build().getPvalue() >= this.thkw) {
            return CombinedSeasonalityTest.IdentifiableSeasonality.ProbablyNone;
        }
        return CombinedSeasonalityTest.IdentifiableSeasonality.Present;
    }

    public double mvalue() {
        double T2;
        double fs = this.stable.ftest();
        double fm = this.evolutive.ftest();
        double T1 = 7.0 / fs;
        double d = T2 = fs == 0.0 ? 9.0 : 3.0 * fm / fs;
        if (T1 > 9.0) {
            T1 = 9.0;
        }
        if (T2 > 9.0) {
            T2 = 9.0;
        }
        return Math.sqrt(0.5 * (T1 + T2));
    }

    public void setMovingSeasonalityAcceptanceLevel(double value) {
        this.thfm = value;
    }

    public void setNonParametricAcceptanceLevel(double value) {
        this.thkw = value;
    }

    public void setStableSeasonalityAcceptanceLevel(double value) {
        this.thfs = value;
    }
}

