## ----mesage=FALSE, warning=FALSE----------------------------------------------
library(rfars)
library(dplyr)
library(stringr)

## ----eval=F, echo=T-----------------------------------------------------------
#  View(rfars::fars_codebook)
#  View(rfars::gescrss_codebook)

## ----results='asis'-----------------------------------------------------------
cb <- rfars::fars_codebook %>% filter(if_any(everything(), ~ str_detect(., "alcohol"))) 

distinct(cb, source, file, name_ncsa, name_rfars, label, Definition, `Additional Information`) %>%
  knitr::kable(format = "html")

## ----results='asis'-----------------------------------------------------------
filter(cb, name_rfars == "drinking") %>%
  distinct(name_rfars, value_label, `2014`, `2015`, `2016`, `2017`, `2018`, `2019`, `2020`, `2021`, `2022`, `2023`) %>%
  knitr::kable(format = "html")

## ----results='asis'-----------------------------------------------------------
filter(cb, name_rfars %in% c("mdrdstrd", "drdistract")) %>%
  distinct(name_rfars, value_label, `2014`, `2015`, `2016`, `2017`, `2018`, `2019`, `2020`, `2021`, `2022`, `2023`) %>%
  arrange(value_label, name_rfars) %>%
  knitr::kable(format = "html")

## ----results='asis'-----------------------------------------------------------
filter(rfars::fars_codebook, name_rfars == "per_typ") %>%
  distinct(name_rfars, value_label, `2014`, `2015`, `2016`, `2017`, `2018`, `2019`, `2020`, `2021`, `2022`, `2023`) %>%
  arrange(value_label, name_rfars) %>%
  knitr::kable(format = "html")

