% Generated by roxygen2: do not edit by hand
\name{svd}
\alias{svd}
\title{Singular Value Decomposition of a Matrix}
\arguments{
  \item{x}{a numeric or complex matrix}
  \item{nu}{number of left singular vectors to be computed (default: all)}
  \item{nv}{number of right singular vectors to be computed (default: all)
}
}

\details{
Basic usage of svd
\code{
A <- matrix(rnorm(20), ncol = 5)
svd_A <- svd(A)
(d <- svd_A$d) # singular values
(U <- svd_A$u) # left singular vectors
(V <- svd_A$v) # right singular vectors
}

Checking that A = UDV'
\code{
(D <- diag(d)) # matrix of singular values
all.equal(A, U \%*\% D \%*\% t(V), tol = 1e-6)
}

Compute only first two singular vectors
\code{
svd_A <- svd(A, nu = 2, nv = 2)
svd_A$d  # singular values
svd_A$u  # first two left singular vectors
svd_A$v  # first two right singular vectors
}}

