library(abclass)

if (requireNamespace("quadprog", quietly = TRUE)) {
    ## toy examples for demonstration purpose
    ## reference: example 1 in Zhang and Liu (2014)
    set.seed(123)
    ntrain <- 100 # size of training set
    ntest <- 1000 # size of testing set
    p0 <- 2       # number of actual predictors
    p1 <- 2       # number of random predictors
    k <- 3        # number of categories

    n <- ntrain + ntest; p <- p0 + p1
    train_idx <- seq_len(ntrain)
    y <- sample(k, size = n, replace = TRUE)         # response
    mu <- matrix(rnorm(p0 * k), nrow = k, ncol = p0) # mean vector
    ## normalize the mean vector so that they are distributed on the unit circle
    mu <- mu / apply(mu, 1, function(a) sqrt(sum(a ^ 2)))
    x0 <- t(sapply(y, function(i) rnorm(p0, mean = mu[i, ], sd = 0.25)))
    x1 <- matrix(rnorm(p1 * n, sd = 0.3), nrow = n, ncol = p1)
    x <- cbind(x0, x1)
    train_x <- x[train_idx, ]
    test_x <- x[- train_idx, ]
    y <- factor(paste0("label_", y))
    train_y <- y[train_idx]
    test_y <- y[- train_idx]

    ## regularization with the supnorm lasso penalty
    options("mc.cores" = 1)

    model <- supclass(train_x, train_y, model = "psvm", penalty = "lasso")
    pred <- predict(model, test_x)
    table(test_y, pred)
    mean(test_y == pred) # accuracy
}
