## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ----leaders------------------------------------------------------------------
library(MaddisonData)

Leaders0 <- MaddisonData::MaddisonLeaders()
Leaders00 <- table(Leaders0$ISO)
MaddisonData::MaddisonCountries[names(Leaders00), 1:2]

## ----leaders1-----------------------------------------------------------------
Leaders1 <- MaddisonData::MaddisonLeaders(c('ARE', 'KWT', 'QAT'))
Leaders10 <- table(Leaders1$ISO)
MaddisonData::MaddisonCountries[names(Leaders10), 1:2]

## ----plotMad------------------------------------------------------------------
#library(MaddisonData)

Leaders10d <- subset(MaddisonData, ISO %in% names(Leaders10))
plotLeaders1 <- MaddisonData::ggplotPath(y='gdppc', group='ISO', 
                        data=Leaders10d, scaley=1000)

plotLeaders1
plotLeaders1 + ggplot2::xlim(1200, 2022)

## ----MadSources---------------------------------------------------------------
MadSources15 <- MaddisonData::getMaddisonSources(names(Leaders10))
head(MadSources15)

## ----plotDur------------------------------------------------------------------
plot(yearEnd-yearBegin+1~yearBegin, Leaders1, log='y', las=1)

Leaders1$dYrs0 <- with(Leaders1, yearEnd-yearBegin+1)
Leaders1$dYrs1 <- c(tail(Leaders1$yearBegin, -1) - head(Leaders1$yearEnd, -1),
                    NA)
Leaders1
tail(Leaders1)

## ----plotMad1600--------------------------------------------------------------
MadDat1600 <- subset(MaddisonData::MaddisonData, year>1600)
Leaders1600 <- MaddisonData::MaddisonLeaders(c('ARE', 'KWT', 'QAT'), 
                               data=MadDat1600)

table(Leaders1600$ISO)

Leaders1600d <- subset(MaddisonData, ISO %in% names(table(Leaders1600$ISO)))
plotLeaders1600 <- MaddisonData::ggplotPath(y='gdppc', group='ISO', 
                        data=Leaders1600d, scaley=1000)
  
plotLeaders1600 + ggplot2::xlim(1601, 2022)

## ----NLD_GBR_USA--------------------------------------------------------------

NLD_GBR_USAd <- subset(MaddisonData, ISO %in% c("NLD", 'GBR', 'USA'))

NLD_GBR_USA <- ggplotPath(y='gdppc', group='ISO', 
                        data=NLD_GBR_USAd, scaley=1000)

NLD_GBR_USA + ggplot2::xlim(1301, 2022)
NLD_GBR_USA + ggplot2::xlim(1601, 2022)

## ----UKevents1, eval=FALSE----------------------------------------------------
# UKevents1 <- matrix(c(
#   "1066-10-14", "Norman Conquest",
#   '1215-06-16', 'Magna Carta'
# ), ncol=2)

## ----1250_1350, eval=FALSE----------------------------------------------------
# GBRgdppc + ggplot2::coord_cartesian(xlim=c(1250, 1350), ylim=c(0.9, 2))

## ----UKevents2, eval=FALSE----------------------------------------------------
# UKevents2 <- rbind(UKevents1,
#   c("1348-06", "Black Death") )
# 
# GBR <- subset(MaddisonData, (ISO == 'GBR') & (1347<year) & (year<1451))
# (GBRpop <-
# 
# 
#     plotMaddison('GBR', 'pop'))
# 
# 
# 
# head(GBRpop@data)

## ----1300_1700, eval=FALSE----------------------------------------------------
# GBRgdppc + ggplot2::coord_cartesian(xlim=c(1300, 1700), ylim=c(0.98, 2.7))

## ----1380_1400, eval=FALSE----------------------------------------------------
# GBRgdppc + ggplot2::coord_cartesian(xlim=c(1380, 1400), ylim=c(1.5, 2))

## ----1640_1700, eval=FALSE----------------------------------------------------
# GBRgdppc + ggplot2::coord_cartesian(xlim=c(1640, 1700), ylim=c(1.5, 3))
# GBRgdppc + ggplot2::coord_cartesian(xlim=c(1640, 1730), ylim=c(1.5, 3))
# GBRgdppc + ggplot2::coord_cartesian(xlim=c(1640, 1920), ylim=c(1.5, 9))
# GBRgdppc + ggplot2::coord_cartesian(xlim=c(1900, 2022), ylim=c(6, 40))
# GBRgdppc + ggplot2::coord_cartesian(xlim=c(2000, 2022), ylim=c(30, 40))

## ----UKevents3, eval=FALSE----------------------------------------------------
# UKevents3 <- rbind(UKevents2,
#   c("1377-06-21", "King Richard II"),
#   c('1399-09-40', 'King Henry IV'),
#   c('1413-03-21', 'King Henry V'),
#   c('1422-09-01', 'King Henry VI'),
#   c('1461-03-04', 'King Edward IV'),
#   c('1483-04-09', 'King Edward V'),
#   c('1483-06-26', 'King Richard III'),
#   c('1485-08-22', 'House of Tudor'),
#   c('1603-03-24', 'King James I'),
#   c('1625-03-27', 'King Charles I'),
#   c('1649-02-14', 'Lord Protector Oliver Cromwell'),
#   c('1658-09-03', 'Lord Protector Richard Cromwell'),
#   c('1660-05-29', 'King Charles II'),
#   c('1685-02-06', 'King James II'),
#   c('1689-01-01', 'William and Mary'),
#   c('1702-03-01', 'Queene Ann'),
#   c('1714-08-01', 'King George I'),
#   c('1722-06-22', 'King George II'),
#   c('1760-10-25', 'King George III'),
#   c('1820-01-29', 'King George IV'),
#   c('1830-06-29', 'King William IV'),
#   c('1837-06-20', 'Queen Victoria'),
#   c('1901-01-22', 'King Edward VII'),
#   c('1910-05-06', 'King George V'),
#   c('1936-01-20', 'King Edward VIII'),
#   c('1936-12-11', 'King George VI'),
#   c('1952-02-06', 'Queen Elizabeth II'),
#   c('1997-05-02', 'PM Tony Blair'),
#   c('2007-06-27', 'PM Gordon Brown'),
#   c('2010-05-11', 'PM David Cameron'),
#   c('2016-07-13', 'PM Theresa May'),
#   c('2019-07-22', 'PM Boris Johnson'),
#   c('2022-09-06', 'PM Liz Truss')
#   )

## ----MadSources2, eval=FALSE--------------------------------------------------
# (GBRsources <- MaddisonData::getMaddisonSources('GBR'))
# # the print method for a tibble does not print all;
# # convert to a data.frame:
# as.data.frame(GBRsources)

